<?php
class ControllerExtensionAnalyticsScriptManager extends Controller {
    private $error = array();

    public function install() {
        //update cleanup
        $old_files = array(
            DIR_APPLICATION.'controller/extension/analytics/conversion_manager.php',
            DIR_APPLICATION.'controller/extension/analytics/remarketing_manager.php',
            DIR_APPLICATION.'language/en-gb/extension/analytics/conversion_manager.php',
            DIR_APPLICATION.'language/en-gb/extension/analytics/remarketing_manager.php',
            DIR_APPLICATION.'view/template/extension/analytics/conversion_manager.twig',
            DIR_APPLICATION.'view/template/extension/analytics/remarketing_manager.twig',
            DIR_CATALOG.'controller/extension/analytics/conversion_manager.php',
            DIR_CATALOG.'controller/extension/analytics/remarketing_manager.php'
        );
        foreach ($old_files as $file_name) {
            if (file_exists($file_name)) {
                unlink($file_name);
            }
        }
    }

    public function index() {

        $this->language->load('extension/analytics/script_manager');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('analytics_script_manager', $this->request->post, $this->request->get['store_id']);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['code'])) {
            $data['error_code'] = $this->error['code'];
        } else {
            $data['error_code'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/analytics/script_manager', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true)
        );

        $data['action'] = $this->url->link('extension/analytics/script_manager', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true);
        $data['user_token'] = $this->session->data['user_token'];
//($this->config->get('analytics_script_manager_use_ecommerce') != "" ? 'copy' => $this->language->get('text_copy') : null)
//'copy' => ($this->config->get('analytics_script_manager_use_ecommerce') != "" ? $this->language->get('text_copy') : null)
        //initiate checkbox options
        $switch = array(1 => $this->language->get('text_enabled'), 0 => $this->language->get('text_disabled'));
        $product_id_options = array('product_id' => $this->language->get('text_product_id'), 'model' => $this->language->get('text_model'));
        $product_id2_options = array('none' => $this->language->get('text_none'), 'product_id' => $this->language->get('text_product_id'), 'model' => $this->language->get('text_model'));
        $google_option_id = array('option_id' => $this->language->get('text_option_id'), 'option_name' => $this->language->get('text_option_name'));
        $facebook_option_id = array('option_id' => $this->language->get('text_option_id'), 'option_name' => $this->language->get('text_option_name'));
        $product_variations = $this->getProductOptions();
        $facebook_currencies = $this->getFacebookCurrencies(1);
        $google_currencies = $this->getGoogleCurrencies(1);
        //generate html settings
        $data['sm_status'] = $this->createCheckboxSetting('status', $switch, 1);
        $data['sm_header_ajax'] = $this->createCheckboxSetting('header_ajax', $switch, 1);
        $data['sm_add_to_cart_button'] = $this->createInputSetting('add_to_cart_button', null);
        $data['sm_adwords_id'] = $this->createInputSetting('adwords_id', null, ' ');
        $data['sm_analytics_id'] = $this->createInputSetting('analytics_id', null, ' ');
        $data['sm_anonymize_ip'] = $this->createCheckboxSetting('anonymize_ip', $switch, 1);
        $data['sm_google_pid1'] = $this->createCheckboxSetting('google_pid1', $this->getFeedOption($product_id_options, array('feed_google_merchant_center_pid1','feed_google_business_data_pid1')), 'product_id');
        $data['sm_google_pid2'] = $this->createCheckboxSetting('google_pid2', $this->getFeedOption($product_id2_options, array('feed_google_business_data_pid2')), 'none');
        $data['sm_conversion_label'] = $this->createInputSetting('conversion_label', null, ' ');
        $data['sm_google_shipping'] = $this->createCheckboxSetting('google_shipping', $switch, 0);
        $data['sm_use_analytics'] = $this->createCheckboxSetting('use_analytics', $switch, 0);
        $data['sm_use_merchant'] = $this->createCheckboxSetting('use_merchant', $switch, 0);
        $data['sm_use_ecommerce'] = $this->createCheckboxSetting('use_ecommerce', $switch, 0);
        $data['sm_use_google_legacy'] = $this->createCheckboxSetting('use_google_legacy', $switch, 0);
        $data['sm_google_user_id'] = $this->createCheckboxSetting('google_user_id', $switch, 0);
        $data['sm_dimension_itemid'] = $this->createNumberSetting('dimension_itemid', null);
        $data['sm_dimension_itemid2'] = $this->createNumberSetting('dimension_itemid2', null);
        $data['sm_dimension_pagetype'] = $this->createNumberSetting('dimension_pagetype', null);
        $data['sm_dimension_totalvalue'] = $this->createNumberSetting('dimension_totalvalue', null);
        $data['sm_google_option_ids'] = $this->createCheckboxSetting('google_option_ids', $this->getFeedOption($google_option_id, array('feed_google_merchant_center_option_ids')), 'option_id');
        $data['sm_google_options'] = $this->createMultiCheckboxSetting('google_options', $product_variations, array());
        $data['sm_google_tax'] = $this->createCheckboxSetting('google_tax', $switch, 0);
        $data['sm_google_currency'] = $this->createCheckboxSetting('google_currency', $google_currencies, $this->config->get('config_currency'));
        $data['sm_optimize_id'] = $this->createInputSetting('optimize_id', null, ' ');
        $data['sm_optimize_timeout'] = $this->createNumberSetting('optimize_timeout', 0);
        $data['sm_facebook_id'] = $this->createInputSetting('facebook_id', null, ' ');
        $data['sm_facebook_pid'] = $this->createCheckboxSetting('facebook_pid', $this->getFeedOption($product_id_options, array('feed_facebook_catalog_pid1')), 'product_id');
        $data['sm_facebook_tax'] = $this->createCheckboxSetting('facebook_tax', $switch, 0);
        $data['sm_facebook_option_ids'] = $this->createCheckboxSetting('facebook_option_ids', $this->getFeedOption($facebook_option_id, array('feed_facebook_catalog_option_ids')), 'option_id');
        $data['sm_facebook_options'] = $this->createMultiCheckboxSetting('facebook_options', $product_variations, array());
        $data['sm_facebook_custom_products'] = $this->createCheckboxSetting('facebook_custom_products', $switch, 0);
        $data['sm_facebook_advanced_matching'] = $this->createCheckboxSetting('facebook_advanced_matching', $switch, 0);
        $data['sm_facebook_shipping'] = $this->createCheckboxSetting('facebook_shipping', $switch, 0);
        $data['sm_facebook_currency'] = $this->createCheckboxSetting('facebook_currency', $facebook_currencies, $this->config->get('config_currency'));
        $data['sm_dynamic_all'] = $this->createTextareaSetting('dynamic_all', null);
        $data['sm_dynamic_success'] = $this->createTextareaSetting('dynamic_success', null);
        $data['sm_dynamic_product'] = $this->createTextareaSetting('dynamic_product', null);
        $data['sm_dynamic_category'] = $this->createTextareaSetting('dynamic_category', null);
        $data['sm_dynamic_cart'] = $this->createTextareaSetting('dynamic_cart', null);
        $data['sm_dynamic_cart_add'] = $this->createTextareaSetting('dynamic_cart_add', null);
        $data['sm_dynamic_checkout'] = $this->createTextareaSetting('dynamic_checkout', null);
        $data['sm_dynamic_other'] = $this->createTextareaSetting('dynamic_other', null);
        $data['sm_custom_options'] = $this->createMultiCheckboxSetting('custom_options', $product_variations, array());
        $data['sm_custom_currency'] = $this->createCheckboxSetting('custom_currency', $google_currencies, $this->config->get('config_currency'));
        $data['sm_template_location'] = $this->createInputSetting('template_location', 'script_templates', ' ');
        $data['sm_download_button'] = $this->createDownloadButton('download_button', 'https://infinia.systems/opencart-script-templates/');

        //labels
        $data['sm_google_title'] = $this->createSettingsTitle('google_title');
        $data['sm_via_analytics_title'] = $this->createSettingsTitle('via_analytics_title');
        $data['sm_facebook_title'] = $this->createSettingsTitle('facebook_title');
        $data['sm_dynamic_title'] = $this->createSettingsTitle('dynamic_title');
        //set other translations
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        //custom dynamic settings
        $custom_text_inputs = array();
        $template_location = trim($this->config->get('analytics_script_manager_template_location'), ' '.DIRECTORY_SEPARATOR);
        if (empty($template_location)) {
            $template_location = 'script_templates';
        }
        $root_folder = str_replace('catalog/', '', DIR_CATALOG).$template_location;
        if (is_dir($root_folder)) {
            $templates = scandir($root_folder);
            foreach ($templates as $name) {
                if ($name != 'index.php' && substr($name, -4) === '.php') {
                    $template = file_get_contents($root_folder.'/'.$name);
                    $script_name = 'custom_'.preg_replace('/[^a-z0-9_]/', '', mb_strtolower(str_replace(' ', '_', str_replace('.php', '', $name))));
                    preg_match_all('/#[\\w| ]+_text_input#/', $template, $matches);
                    foreach (reset($matches) as $value) {
                        $title = str_replace('_text_input', '', str_replace('#', '', $value));
                        $explode = explode('|', $title);
                        if (count($explode) === 2) {//uses simple titles
                            $title = reset($explode);
                            $key = $script_name.'_'.end($explode);
                        } else {
                            $title = mb_convert_case(str_replace('_', ' ', str_replace('.php', '', $name)), MB_CASE_TITLE, "UTF-8").'-'.mb_strtolower(str_replace('_', ' ', $title)).$this->language->get('entry_custom_text_input');
                            $key = $script_name.'_'.mb_strtolower(str_replace('_text_input', '', str_replace('#', '', $value)));
                        }
                        if (!array_key_exists($key, $custom_text_inputs)) {
                            $custom_text_inputs[$key] = $this->createInputSetting($key, null, ' ', 'custom_text_input', $title);
                        }
                    }
                }
            }
        }
        $data['sm_dynamic_text_inputs'] = $custom_text_inputs;

        $this->response->setOutput($this->load->view('extension/analytics/script_manager', $data));
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/analytics/script_manager')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

    protected function getSettingData($name, $default_value = null, $remove_char = "")
    {
        $name = 'analytics_script_manager_'.$name;
        $value = $default_value;
        if (isset($this->request->post[$name])) {
            $value = $this->request->post[$name];
        } elseif ($default_value == null || $this->model_setting_setting->getSettingValue($name, $this->request->get['store_id']) != '') {
            $value = $this->model_setting_setting->getSettingValue($name, $this->request->get['store_id']);
        }
        if (!is_array($value)) {
            str_replace($remove_char, '', $value);
            if (substr($value, 0, 1) === '[') {
                $value = json_decode($value);
            }
        }
        return $value;
    }

    protected function createInputSetting($name, $default_value, $remove_char = "", $postfix = null, $title = '')
    {
        $postfix = ($postfix === null ? $name : $postfix);
        $id = 'input-analytics-script-manager-'.str_replace('_', '-', $name);
        return '<div class="form-group">
          <label class="col-sm-2 control-label" for="'.$id.'"><span data-toggle="tooltip" title="'.$this->language->get('help_'.$postfix).'">'.($title == '' ? $this->language->get('entry_'.$postfix) : $title).'</span></label>
          <div class="col-sm-10">
            <input type="text" name="analytics_script_manager_'.$name.'" value="'.$this->getSettingData($name, $default_value, $remove_char).'" placeholder="'.($title == '' ? $this->language->get('entry_'.$postfix) : $title).'" id="'.$id.'" class="form-control" />
          </div>
        </div>';
    }

    protected function createTextareaSetting($name, $default_value)
    {
        $id = 'input-analytics-script-manager-'.str_replace('_', '-', $name);
        return '<div class="form-group">
          <label class="col-sm-2 control-label" for="'.$id.'"><span data-toggle="tooltip" data-html="true" title="'.$this->language->get('help_'.$name).'">'.$this->language->get('entry_'.$name).'</span></label>
          <div class="col-sm-10">
            <textarea name="analytics_script_manager_'.$name.'" rows="5" placeholder="'.$this->language->get('entry_'.$name).'" id="'.$id.'" class="form-control">'.$this->getSettingData($name, $default_value).'</textarea>
          </div>
        </div>';
    }

    protected function createNumberSetting($name, $default_value)
    {
        $id = 'input-analytics-script-manager-'.str_replace('_', '-', $name);
        return '<div class="form-group">
          <label class="col-sm-2 control-label" for="'.$id.'"><span data-toggle="tooltip" title="'.$this->language->get('help_'.$name).'">'.$this->language->get('entry_'.$name).'</span></label>
          <div class="col-sm-2">
            <input type="number" step="1" name="analytics_script_manager_'.$name.'" value="'.$this->getSettingData($name, $default_value).'" placeholder="'.$this->language->get('entry_'.$name).'" id="'.$id.'" class="form-control" />
          </div>
        </div>';
    }

    protected function createCheckboxSetting($name, $options, $default_value)
    {
        $id = 'input-analytics-script-manager-'.str_replace('_', '-', $name);
        $selected = $this->getSettingData($name, $default_value);
        $html = '<div class="form-group">
          <label class="col-sm-2 control-label" for="'.$id.'"><span data-toggle="tooltip" data-html="true" title="'.$this->language->get('help_'.$name).'">'.$this->language->get('entry_'.$name).'</span></label>
          <div class="col-sm-10">
            <select name="analytics_script_manager_'.$name.'" id="'.$id.'" class="form-control">';
        foreach ($options as $key => $value) {
            $html .= '<option '.($selected == $key ? 'selected="selected" ' : ' ').'value="'.$key.'">'.$value.'</option>';
        }
        $html .='</select>
          </div>
        </div>';
        return $html;
    }

    protected function createSettingsTitle($name)
    {
        $html = '<legend>'.$this->language->get('text_'.$name).'</legend>';
        if ($this->language->get('help_'.$name) != '') {
            $html .= '<div class="alert alert-info"><i class="fa fa-info-circle"></i>'.$this->language->get('help_'.$name).'
              <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>';
        }
        return $html;
    }

    public function createMultiCheckboxSetting($name, $options, $default_value = array())
    {
        $id = 'input-analytics-script-manager-'.str_replace('_', '-', $name);
        $selected = $this->getSettingData($name, $default_value);
        if (!is_array($selected)) {
            $selected = array();
        }
        $html =	'<div class="form-group">
                <label class="col-sm-2 control-label" for="'.$id.'"><span data-toggle="tooltip" data-html="true" title="'.$this->language->get('help_'.$name).'">'.$this->language->get('entry_'.$name).'</span></label>
                <div class="col-sm-10">
                    <div class="well well-sm" style="height: 150px; overflow: auto;">';
                    foreach ($options as $key => $value) {
                        $html .= '<div class="checkbox switching"><label style="display: block;"><input type="checkbox" name="analytics_script_manager_'.$name.'[]" value="'.$key.'"'.(in_array($key , $selected) ? ' checked="checked"' : '' ).' />'.$value.'</label></div>';
                    }
                    $html .='</div>
                </div>
            </div>';
        return $html;
    }

    protected function createDownloadButton($name, $url)
    {
        return '<div class="form-group">
                <label class="col-sm-2 control-label"><span data-toggle="tooltip" data-html="true" title="'.$this->language->get('help_'.$name).'">'.$this->language->get('entry_'.$name).'</span></label>
                <div class="col-sm-10">
                <a class="feed-btn btn btn-default" target="_blank" href="'.$url.'">
                    <i class="fa fa-download"></i> '.$this->language->get('text_'.$name).'</a>
                </div>
            </div>';
    }

    protected function getProductOptions() {
        $query=$this->db->query("SELECT od.option_id AS option_id, od.name AS name
            FROM `".DB_PREFIX."option_description` AS od
            INNER JOIN `".DB_PREFIX."option_value_description` AS ovd
            ON ovd.option_id = od.option_id
            WHERE od.`language_id` LIKE '".(int)$this->config->get('config_language_id')."'
            GROUP BY ovd.option_id;");
        $options_attributes = array();
        foreach ($query->rows as $value) {
            $options_attributes[$value['option_id']]=$value['name'];
        }
        return $options_attributes;
    }

    protected function getFeedOption($options, $settings)//will return copy setting if at least one is found, make sure to check which to use
    {
        foreach ($settings as $value) {
            if ($this->config->get($value) != "") {//setting found return new options
                return array_merge(array('copy' => $this->language->get('text_copy')), $options);
            }
        }
        return $options;//setting not found return original options
    }

    protected function setLanguageData(&$data, $name)//not used!!!
    {
        $data[$name] = $this->language->get($name);
    }

    protected function setSettingData(&$data, $name, $default_value = null)//not used!!!
    {
        $name = 'analytics_script_manager_'.$name;
        if (isset($this->request->post[$name])) {
            $data[$name] = $this->request->post[$name];
        }  elseif ($default_value == null || $this->model_setting_setting->getSettingValue($name, $this->request->get['store_id']) != '') {
            $data[$name] = $this->model_setting_setting->getSettingValue($name, $this->request->get['store_id']);
        } else {
            $data[$name] = $default_value;
        }
    }

    protected function getFacebookCurrencies($disabled = 1)
    {
        $supported = array('DZD','ARS','AUD','BDT','BOB','BRL','GBP','CAD','CLP','CNY','COP','CRC','CZK','DKK','EGP','EUR','GTQ','HNL','HKD','HUF','ISK','INR','IDR','ILS','JPY','KES','KRW','MOP','MYR','MXN','NZD','NIO','NGN','NOK','PKR','PYG','PEN','PHP','PLN','QAR','RON','RUB','SAR','SGD','ZAR','SEK','CHF','TWD','THB','TRY','AED','USD','UYU','VEF','VND');
        $currencies = array('customer' => $this->language->get('text_customer_currency'));
        $query = $this->db->query("SELECT `currency_id`, `title`, `code` FROM `".DB_PREFIX."currency` ".($disabled ? "" : "WHERE `status` LIKE '1' ")."ORDER BY `currency_id`;");
        foreach ($query->rows as $value) {
            $code = $value['code'];
            if (in_array($code, $supported)) {
                $currencies[$code]=$value['title'].' ('.$code.')'.($code == $this->config->get('config_currency') ? ' - Default' : '');
            } else {
                $currencies['USD'.$code]=$value['title'].' ('.$code.') - Not supported by Facebook';
            }
        }
		return $currencies;
    }

    protected function getGoogleCurrencies($disabled = 1)
    {
        $currencies = array('customer' => $this->language->get('text_customer_currency'));
        $query = $this->db->query("SELECT `currency_id`, `title`, `code` FROM `".DB_PREFIX."currency` ".($disabled ? "" : "WHERE `status` LIKE '1' ")."ORDER BY `currency_id`;");
        foreach ($query->rows as $value) {
            $code = $value['code'];
            $currencies[$code]=$value['title'].' ('.$code.')'.($code == $this->config->get('config_currency') ? ' - Default' : '');
        }
		return $currencies;
    }
}
