<?php

class ControllerCustomerCustomerSetting extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('customer/customer_setting');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer_setting');

        $this->getForm();
    }

    public function add()
    {
        $this->load->language('customer/customer_setting');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer_setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            // $this->model_customer_customer_group->addCustomerGroup($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer_setting', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }


    public function delete()
    {
        $this->load->language('customer/customer_group');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer_group');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $customer_group_id) {
                $this->model_customer_customer_group->deleteCustomerGroup($customer_group_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer_group', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getForm()
    {
        $data['text_form'] = !isset($this->request->get['customer_group_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');


        $data = [];
        $settings = $this->config->get('config_customer_form_settings');

        if (isset($settings) && !empty($settings)) {
            foreach ($settings as $setting => $value) {
                $data[$setting] = (int)$value;
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }



        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('customer/customer_group', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['customer_group_id'])) {
            $data['action'] = $this->url->link('customer/customer_group/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('customer/customer_group/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_group_id=' . $this->request->get['customer_group_id'] . $url, true);
        }


        $data['cancel'] = $this->url->link('customer/customer_setting', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();



        if (isset($this->request->post['sort_order'])) {
            $data['sort_order'] = $this->request->post['sort_order'];
        } elseif (!empty($customer_group_info)) {
            $data['sort_order'] = $customer_group_info['sort_order'];
        } else {
            $data['sort_order'] = '';
        }




        $data['user_token'] = $this->session->data['user_token'];


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('customer/customer_setting', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'customer/customer_group')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['customer_group_description'] as $language_id => $value) {
            if ((utf8_strlen($value['name']) < 3) || (utf8_strlen($value['name']) > 32)) {
                $this->error['name'][$language_id] = $this->language->get('error_name');
            }
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'customer/customer_group')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $this->load->model('setting/store');
        $this->load->model('customer/customer');

        foreach ($this->request->post['selected'] as $customer_group_id) {
            if ($this->config->get('config_customer_group_id') == $customer_group_id) {
                $this->error['warning'] = $this->language->get('error_default');
            }

            $store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($customer_group_id);

            if ($store_total) {
                $this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
            }

            $customer_total = $this->model_customer_customer->getTotalCustomersByCustomerGroupId($customer_group_id);

            if ($customer_total) {
                $this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
            }
        }

        return !$this->error;
    }

    public function saveSetting()
    {
        $this->load->model('customer/customer_setting');

        $json = [];

        $first_name =($this->request->post['first_name']) ? $this->request->post['first_name'] : 0;
        $lastname =($this->request->post['lastname']) ? $this->request->post['lastname'] : 0;
        $ic =($this->request->post['ic']) ? $this->request->post['ic'] : 0;
        $customer_card =($this->request->post['customer_card']) ? $this->request->post['customer_card'] : 0;
        $email =($this->request->post['email']) ? $this->request->post['email'] : 0;
        $telephone =($this->request->post['telephone']) ? $this->request->post['telephone'] : 0;
        $fax =($this->request->post['fax']) ? $this->request->post['fax'] : 0;
        $gender =($this->request->post['gender']) ? $this->request->post['gender'] : 0;
        $dob =($this->request->post['dob']) ? $this->request->post['dob'] : 0;
        $home =($this->request->post['home']) ? $this->request->post['home'] : 0;
        $ic_duplicate =($this->request->post['ic_duplicate']) ? $this->request->post['ic_duplicate'] : 0;
        $card_duplicate =($this->request->post['card_duplicate']) ? $this->request->post['card_duplicate'] : 0;
        $email_duplicate =($this->request->post['email_duplicate']) ? $this->request->post['email_duplicate'] : 0;
        $phone_duplicate =($this->request->post['phone_duplicate']) ? $this->request->post['phone_duplicate'] : 0;
        $address_first_name =($this->request->post['address_firstname']) ? $this->request->post['address_firstname'] : 0;
        $address_last_name =($this->request->post['address_lastname']) ? $this->request->post['address_lastname'] : 0;
        $address1 =($this->request->post['address1']) ? $this->request->post['address1'] : 0;
        $address2 =($this->request->post['address2']) ? $this->request->post['address2'] : 0;
        $address3 =($this->request->post['address3']) ? $this->request->post['address3'] : 0;
        $city =($this->request->post['city']) ? $this->request->post['city'] : 0;
        $postcode =($this->request->post['postcode']) ? $this->request->post['postcode'] : 0;
        $country =($this->request->post['country']) ? $this->request->post['country'] : 0;
        $zone =($this->request->post['zone']) ? $this->request->post['zone'] : 0;



        $config_customer = array(
            'config_customer_form_firstname_required' => $first_name,
            'config_customer_form_lastname_required' => $lastname,
            'config_customer_form_customer_ic_required' => $ic,
            'config_customer_form_customer_card_required' => $customer_card,
            'config_customer_form_email_required' => $email,
            'config_customer_form_telephone_required' => $telephone,
            'config_customer_form_fax_required' =>$fax,
            'config_customer_form_gender_required' => $gender,
            'config_customer_form_dob_required' => $dob,
            'config_customer_form_home_required' => $home,
            'config_customer_form_customer_ic_duplicate_validation' => $ic_duplicate,
            'config_customer_form_customer_card_duplicated_validation' => $card_duplicate,
            'config_customer_form_email_duplicate_validation' => $email_duplicate,
            'config_customer_form_telephone_duplicate_validation' => $phone_duplicate,
            'config_address_form_firstname_required' => $address_first_name,
            'config_address_form_lastname_required' => $address_last_name,
            'config_address_form_address_1_required' => $address1,
            'config_address_form_address_2_required' => $address2,
            'config_address_form_address_3_required' => $address3,
            'config_address_form_city_required' => $city,
            'config_address_form_postcode_required' => $postcode,
            'config_address_form_country_required' => $country,
            'config_address_form_zone_required' => $zone
        );



        $jsonconfig = json_encode($config_customer);

        $this->model_customer_customer_setting->updateSetting($jsonconfig);




        $json['success'] = 1;


        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
}
