<?php

class ControllerCustomerCustomer extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('customer/customer');

        $this->getList();
    }

    public function exportCustomer()
    {
        $this->load->model('customer/customer');
        $this->load->model('localisation/zone');
        $this->load->model('localisation/country');


        $this->load->language('customer/customer');

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_card'])) {
            $filter_card = $this->request->get['filter_card'];
        } else {
            $filter_card = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = null;
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        // if (isset($this->request->get['filter_approved'])) {
        //     $filter_approved = $this->request->get['filter_approved'];
        // } else {
        //     $filter_approved = null;
        // }


        if (isset($this->request->get['filter_customer_group_id'])) {
            $filter_customer_group_id = $this->request->get['filter_customer_group_id'];
        } else {
            $filter_customer_group_id = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'c.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_card' => $filter_card,
            'filter_ic' => $filter_ic,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_status' => $filter_status,
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_customer_group_id' => $filter_customer_group_id,
            'filter_customer_group'    => $filter_customer_group,       
            'filter_gender' => $filter_gender,
         );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setTitle('Title')
            ->setSubject('Subject')
            ->setDescription('Description')
            ->setKeywords('report etcm.me')
            ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri')
            ->setSize(11);

        $table_collection = array();
        $results = $this->model_customer_customer->getCustomers($filter_data);

        
        
        if (!empty($results)) {
            foreach ($results as $result) {

                if ($result['gender'] == '1') {
                    $gen = $this->language->get('text_male');
                } elseif ($result['gender'] == '2') {
                    $gen = $this->language->get('text_female');
                } else {
                    $gen = '';
                }

                if ($result['marital_status'] == '1') {
                    $marital = $this->language->get('text_single');
                } elseif ($result['marital_status'] == '2') {
                    $marital = $this->language->get('text_married');
                } else {
                    $marital = '';
                }

                if($result['religion'] == "1"){
                    $religion= $this->language->get('text_islam');
                }elseif($result['religion'] == "2"){
                    $religion= $this->language->get('text_buddhism');
                } elseif($result['religion'] == "3"){
                    $religion= $this->language->get('text_hinduism');
                }else{
                    $religion= $this->language->get('text_christian');
                }

                if($result['race'] == "1"){
                    $race= $this->language->get('text_malay');
                }elseif($result['race'] == "2"){
                    $race= $this->language->get('text_chinese');
                } elseif($result['race'] == "3"){
                    $race= $this->language->get('text_indian');
                }elseif($result['race'] == "4"){
                    $race= $this->language->get('text_race_indigenous_ethic_group');
                }else{
                    $race= $this->language->get('text_race_foreigner');
                }

                $address_id = $result['address_id'];

                if ($address_id > 0) {
                    $address_info = $this->model_customer_customer->getAddress($address_id);

                    $address_1 = !empty($address_info) ? $address_info['address_1'] : '';
                    $address_2 = !empty($address_info) ? $address_info['address_2'] : '';
                    $address_3 = !empty($address_info) ? $address_info['address_3'] : '';
                    $city = !empty($address_info) ? $address_info['city'] : '';
                    $postcode = !empty($address_info) ? $address_info['postcode'] : '';

                    $zone_id = !empty($address_info) ? $address_info['zone_id'] : 0;
                    $country_id = !empty($address_info) ? $address_info['country_id'] : 0;

                    $zone_info = ($zone_id > 0) ? $this->model_localisation_zone->getZone($zone_id) : [];
                    $zone_name = !empty($zone_info) ? $zone_info['name'] : '';

                    $country_info = ($country_id > 0) ? $this->model_localisation_country->getCountry($country_id) : [];
                    $country_name = !empty($country_info) ? $country_info['name'] : '';
                } else {
                    $address_1 = '';
                    $address_2 = '';
                    $address_3 = '';
                    $city = '';
                    $postcode = '';
                    $zone_name = '';
                    $country_name = '';
                }

                $this->load->model('setting/store');
                $data['stores'] = array();
    
                $sname = $this->config->get('config_name');
    
                $data['stores'][] = array(
                    'store_id' => 0,
                    'name' => $sname
                );
    
                $stores = $this->model_setting_store->getStores();
    
                foreach ($stores as $store) {
                    $data['stores'][] = array(
                        'store_id' => $store['store_id'],
                        'name' => $store['name']
                    );
                }

                $table_collection[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    // 'Age'=> $this->calculateAge($result['dob']),
                    'gender' => $gen,
                    'dob' =>$result['dob'],
                    'customer_ic' => $result['customer_ic'],
                    'telephone' => $result['telephone'],
                    'email' => $result['email'],
                    'customer_card' => $result['customer_card'],
                    // 'customer_group' => $result['customer_group'],
                    // 'store_name' => $sname,
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home'],
                    'nationality'=>$result['nationality'],
                    'marital_status'=>$marital,
                    'relgion' =>$religion,
                    'race'=>$race,
                    'allergic'=>$result['allergic'],
                    'diagnostic_history'=>$result['diagnostic_history'],
                    'occupation'=>$result['occupation'],
                    'address_id'=>$result['address_id'],
                    'address_1' =>$address_1,
                    'address_2' =>$address_2,
                    'address_3' =>$address_3,
                    'city'      =>$city,
                    'postcode' =>$postcode,
                    'zone_name' =>$zone_name,
                    'country_name'=>$country_name,
                    // 'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    // 'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'))
                ];
            }
        }

        $table = array();
        // $table[] = array('Customer List', $this->language->get('heading_title'));
        // $table[] = array();
        $table_header = array(
            'Customer ID',
            'FirstName',
            'LastName',
            'Gender',
            'DOB',
            'Customer IC',
            'Contact Number',
            'E-mail',
            'Member No',
            // 'Member Group',
            // 'Store',
            'Contact Number 2',
            'Contact Number(Home)',
            'Nationality',
            'Marital Status',
            'Religion',
            'Race',
            'Allergic',
            'Diagnostic History',
            'Occupation',
            'Address ID',
            'Address 1',
            'Address 2',
            'Address 3',
            'City',
            'Postcode',
            'State',
            'Country',
            // 'Date Added',
            // 'Status'
        );
        $table[] = $table_header;
        $total_row = 0;
        $table_data = $table_collection;
        $row;
        foreach ($table_data as $key => $data) {
            $row = array();

            foreach ($data as $key => $value) {
                $row[] = $value;
            }
            $table[] = $row;

            $total_row++;
        }

        // Styling
        $autosize_column_index = 'A';
        foreach ($table_header as $header) {
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach ($table_header as $col) {
            $header_index_e_column++;
        }
        $header_index_row = 3;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font' => array(
                'bold' => false
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $general_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            // 'numberformat' => array(
            //     'code' => '00'
            // )
        );

        $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('G1:G' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('G1:G' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        
        $objPHPExcel->getActiveSheet()
        ->getStyle('H1:H' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('H1:H' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);



        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('J1:J' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('J1:J' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('K1:K' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1:K' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('L1:L' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1:L' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('M1:M' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('M1:M' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('N1:N' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('N1:N' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
         
        $objPHPExcel->getActiveSheet()
        ->getStyle('O1:O' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('O1:O' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);


        $objPHPExcel->getActiveSheet()
        ->getStyle('P1:P' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('P1:P' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('Q1:Q' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Q1:Q' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
    

        $objPHPExcel->getActiveSheet()
        ->getStyle('R1:R' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('R1:R' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('S1:S' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('S1:S' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('T1:T' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('T1:T' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('U1:U' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('U1:U' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('V1:V' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('V1:V' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('W1:W' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('W1:W' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('X1:X' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('X1:X' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
        
        $objPHPExcel->getActiveSheet()
        ->getStyle('Y1:Y' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Y1:Y' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
        ->getStyle('Z1:Z' . $lastrow)
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Z1:Z' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
    


        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:Z' . $lastrow)
            ->getAlignment()
            ->setWrapText(true);

        /* $objPHPExcel->getActiveSheet()
          ->getStyle('A1:I'.$lastrow)
          ->getAlignment()
          ->setWrapText(true); */
        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = 'Customer List';

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }
    
}
