<?php

class ControllerCustomerCustomer extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('customer/customer');

        $this->getList();
    }

    public function add() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('appointment/appointment');
        $this->load->model('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_customer_customer->addCustomer($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }


            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');
        $this->load->model('appointment/appointment');
        $this->load->model('user/user');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_customer_customer->editCustomer($this->request->get['customer_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $customer_id) {
                $this->model_customer_customer->deleteCustomer($customer_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function approve() {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');

        $customers = array();

        if (isset($this->request->post['selected'])) {
            $customers = $this->request->post['selected'];
        } elseif (isset($this->request->get['customer_id'])) {
            $customers[] = $this->request->get['customer_id'];
        }

        if ($customers && $this->validateApprove()) {
            $this->model_customer_customer->approve($this->request->get['customer_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function unlock() {
        $this->load->language('customer/customer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');

        if (isset($this->request->get['email']) && $this->validateUnlock()) {
            $this->model_customer_customer->deleteLoginAttempts($this->request->get['email']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }


    public function tickToTop() {
        $this->load->model('customer/customer');
        $json = [];
        if (!empty($this->request->post['herbal_id'])) {
            $top = $this->request->post['top'];
            $herbal_id = $this->request->post['herbal_id'];
            $this->model_customer_customer->tickToTop($herbal_id, $top);
            $json['success'] = 1;
        }

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function updateCustomerStatus() {
        $this->load->model('customer/customer');
        $json = [];
        if (!empty($this->request->post['customer_id'])) {
            $status = $this->request->post['status'];
            $customer_id = $this->request->post['customer_id'];
            $this->model_customer_customer->customerStatus($customer_id, $status);
            $json['success'] = 1;
        }

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function updateCustomer() {
        $this->load->model('customer/customer');
        $json = [];

        if ($this->validateUpdateCustomer($this->request->post)) {

            $old_customer_id = $this->request->post['old_customer_id'];
            $new_customer_id = $this->request->post['new_customer_id'];



            $this->model_customer_customer->updateOrderCustomerId($old_customer_id, $new_customer_id);

            $this->model_customer_customer->updateServiceCustomerId($old_customer_id, $new_customer_id);

            $this->model_customer_customer->updateClinicalCustomerId($old_customer_id, $new_customer_id);

            $this->model_customer_customer->updateAppointmentCustomerId($old_customer_id, $new_customer_id);

            $this->model_customer_customer->updateAddressCustomerId($old_customer_id, $new_customer_id);

            $this->model_customer_customer->updateCustomerStatus($old_customer_id);



            $json['success'] = 1;
        }

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    private function validateUpdateCustomer($data) {

        if (!empty($data['old_customer_id']) && !empty($data['new_customer_id'])) {
            $old_customer_id = $data['old_customer_id'];
            $new_customer_id = $data['new_customer_id'];

            //check phone
            $oldCustomerPhone = $this->model_customer_customer->oldCustomerExistByPhone($old_customer_id);
            $newCustomerPhone = $this->model_customer_customer->newCustomerExistByPhone($new_customer_id);

            //check customer ic
            $oldCustomerIc = $this->model_customer_customer->oldCustomerExistByIc($old_customer_id);
            $newCustomerIc = $this->model_customer_customer->newCustomerExistByIC($new_customer_id);

            if (($oldCustomerPhone == $newCustomerPhone) && ($oldCustomerIc == $newCustomerIc)) {
                return true;
            }




            return true;
        } else {
            return false;
        }
    }

    protected function getList() {
        $this->document->addStyle('view/stylesheet/customer.css?v=' . time());

        $this->load->model('appointment/appointment');
        $this->load->model('customer/customer');


        if (!empty($customer_id)) {
            $customer_info = $this->model_customer_customer->getCustomer($customer_id);


            if (!empty($customer_info)) {

                if ($customer_info['gender'] == 1) {
                    $gender = $this->language->get('text_male');
                } elseif ($customer_info['gender'] == 2) {
                    $gender = $this->language->get('text_female');
                } else {
                    $gender = '';
                }

                $data['customer_id'] = $customer_info['customer_id'];
                $data['telephone'] = $customer_info['telephone'];
                $data['name'] = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
                $data['customer_ic'] = $customer_info['customer_ic'];
                $data['gender'] = $gender;
            } else {
                $data['name'] = '';
                $data['customer_id'] = 0;
            }
        } else {
            $data['name'] = '';
            $data['customer_id'] = 0;
        }



        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_card'])) {
            $filter_card = $this->request->get['filter_card'];
        } else {
            $filter_card = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $filter_customer_group_id = $this->request->get['filter_customer_group_id'];
        } else {
            $filter_customer_group_id = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '1';
        }

        if (isset($this->request->get['filter_approved'])) {
            $filter_approved = $this->request->get['filter_approved'];
        } else {
            $filter_approved = '';
        }

        if (isset($this->request->get['filter_ip'])) {
            $filter_ip = $this->request->get['filter_ip'];
        } else {
            $filter_ip = null;
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }


        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = '';
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = '';
        }



        if (isset($this->request->get['filter_age_from'])) {
            $filter_age_from = $this->request->get['filter_age_from'];
        } else {
            $filter_age_from = null;
        }
        if (isset($this->request->get['filter_age_to'])) {
            $filter_age_to = $this->request->get['filter_age_to'];
        } else {
            $filter_age_to = null;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = '';
        }


        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'c.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_card'])) {
            $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_ip'])) {
            $url .= '&filter_ip=' . $this->request->get['filter_ip'];
        }

        if (isset($this->request->get['filter_age_from'])) {
            $url .= '&filter_age_from=' . $this->request->get['filter_age_from'];
        }
        if (isset($this->request->get['filter_age_to'])) {
            $url .= '&filter_age_to=' . $this->request->get['filter_age_to'];
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        // if (isset($this->request->get['filter_date_type'])) {
        //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        // }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        // $language = $this->session->data['language'];

        // if ($language == 'en-gb') {
        //     $data['date_types'][] = [
        //         'text' => 'All',
        //         'value' => 'all'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Today',
        //         'value' => 'today'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Yesterday',
        //         'value' => 'yesterday'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Last 7 Days',
        //         'value' => 'last7days'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Last 30 Days',
        //         'value' => 'last30days'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Year to Date',
        //         'value' => 'year'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Last Year',
        //         'value' => 'lastyear'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Last 3 Year',
        //         'value' => 'last3year'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Last 5 Year',
        //         'value' => 'last5year'
        //     ];

        // } elseif ($language == 'zh-cn') {
        //     $data['date_types'][] = [
        //         'text' => '所有',
        //         'value' => 'all'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '今天',
        //         'value' => 'today'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '星期',
        //         'value' => 'week'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '月',
        //         'value' => 'month'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '年',
        //         'value' => 'year'
        //     ];

        // }

        // $filter_date_added_from = null;
        // $filter_date_added_to = null;
        // $filter_date_type = 'all';
        // $this->request->get['filter_date_added_to'] = null;
        // $this->request->get['filter_date_added_from'] = null;



        // $date_now = date('Y-m-d');
        // $config_date_type = 'all';
        // $filter_date_type = isset($this->request->get['filter_date_type']) ? ($this->request->get['filter_date_type']) : $config_date_type;
        // $data['selected_date_type'] = $filter_date_type;

        // // Based on the date type to set the value for date_from and date to
        // switch ($filter_date_type) {
        //     case 'today':
        //         $filter_date_added_from = date('Y-m-d');
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'yesterday':
        //         $filter_date_added_from = date('Y-m-d',strtotime('-1 days'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'last7days':
        //         $filter_date_added_from = date('Y-m-d',strtotime('-7 days'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'last30days':
        //         $filter_date_added_from = date('Y-m-d',strtotime('-30 days'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'month':
        //         $filter_date_added_from = date('Y-m-01', strtotime($date_now));
        //         $filter_date_added_to = date('Y-m-t');
        //         break;
        //     case 'year':
        //         $filter_date_added_from = date('Y-m-d', strtotime('first day of january this year'));
        //         $filter_date_added_to = date('Y-m-d', strtotime('last day of december this year'));
        //         break;
        //     case 'lastyear':
        //         $filter_date_added_from = date('Y', strtotime('-1 year'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'last3year':
        //         $filter_date_added_from = date('Y', strtotime('-3 year'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'last5year':
        //         $filter_date_added_from = date('Y', strtotime('-5 year'));
        //         $filter_date_added_to = date('Y-m-d');
        //         break;
        //     case 'all':
        //         $filter_date_added_from = null;
        //         $filter_date_added_to = null;
        //         break;
        //     default:
        //         $filter_date_added_from = $filter_date_added_from;
        //         $filter_date_added_to = $filter_date_added_to;
        // }

        // $this->request->get['filter_date_added_from'] = $filter_date_added_from;
        // $this->request->get['filter_date_added_to'] = $filter_date_added_to;

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_card'])) {
            $filter_card = $this->request->get['filter_card'];
        } else {
            $filter_card = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $filter_customer_group_id = $this->request->get['filter_customer_group_id'];
        } else {
            $filter_customer_group_id = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '1';
        }

        if (isset($this->request->get['filter_approved'])) {
            $filter_approved = $this->request->get['filter_approved'];
        } else {
            $filter_approved = '';
        }

        if (isset($this->request->get['filter_ip'])) {
            $filter_ip = $this->request->get['filter_ip'];
        } else {
            $filter_ip = null;
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }


        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = '';
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = '';
        }


        if (isset($this->request->get['filter_age_from'])) {
            $filter_age_from = $this->request->get['filter_age_from'];
        } else {
            $filter_age_from = null;
        }

        if (isset($this->request->get['filter_age_to'])) {
            $filter_age_to = $this->request->get['filter_age_to'];
        } else {
            $filter_age_to = null;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = '';
        }


        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'c.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }




        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_card'])) {
            $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_ip'])) {
            $url .= '&filter_ip=' . $this->request->get['filter_ip'];
        }

        if (isset($this->request->get['filter_age_from'])) {
            $url .= '&filter_age_from=' . $this->request->get['filter_age_from'];
        }
        if (isset($this->request->get['filter_age_to'])) {
            $url .= '&filter_age_to=' . $this->request->get['filter_age_to'];
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        // if (isset($this->request->get['filter_date_type'])) {
        //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        // }

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }



        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('customer/customer/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('customer/customer/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['export_excel'] = $this->url->link('customer/customer/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['export_customer_excel'] = $this->url->link('customer/customer/exportCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);


        $data['import_excel'] = $this->url->link('customer/customer/getImportExcelForm', 'user_token=' . $this->session->data['user_token'] . $url, true);


        // $data['delete_btn'] = false;
        $data['btn_login'] = false;
        $data['btn_appointment'] = false;
        $data['btn_service'] = false;
        $data['btn_medical'] = false;
        $data['btn_edit'] = false;
        $data['btn_import'] = false;
        $data['btn_export'] = false;
        $data['btn_customer_export'] = false;
        $data['btn_delete'] = false;


        if ($this->user->hasPermission('delete', 'customer/customer')) {
            $data['btn_delete'] = true;
        }

        if ($this->user->hasPermission('modify', 'customer/customer')) {
            $data['btn_login'] = true;
        }

        if ($this->user->hasPermission('modify', 'appointment/appointment')) {
            $data['btn_appointment'] = true;
        }


        if ($this->user->hasPermission('modify', 'service/service_form')) {
            $data['btn_service'] = true;
        }


        if ($this->user->hasPermission('modify', 'herbal/new_herbal')) {
            $data['btn_medical'] = true;
        }

        if ($this->user->hasPermission('modify', 'customer/customer')) {
            $data['btn_edit'] = true;
        }

        if ($this->user->hasPermission('modify', 'customer/customer')) {
            $data['btn_import'] = true;
        }

        if ($this->user->hasPermission('modify', 'customer/customer_export')) {
            $data['btn_export'] = true;
        }

        if ($this->user->hasPermission('modify', 'customer/customer_export')) {
            $data['btn_customer_export'] = true;
        }


        //filter memory
        $data['filter_add_by'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";


        $data['customers'] = array();

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_card' => $filter_card,
            'filter_ic' => $filter_ic,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer_group_id' => $filter_customer_group_id,
            'filter_customer_group'    => $filter_customer_group,
            'filter_gender' => $filter_gender,
            'filter_status' => $filter_status,
            'filter_approved' => $filter_approved,
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_store_id' => $filter_store_id,
            'filter_ip' => $filter_ip,
            'filter_add_by' => $filter_add_by,
            'filter_age_from' => $filter_age_from,
            'filter_age_to' => $filter_age_to,
            // 'filter_date_type' => $filter_date_type,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin'),
            'user_view' => $this->user->user_view
        );



        $customer_total = $this->model_customer_customer->getTotalCustomers($filter_data);


        $results = $this->model_customer_customer->getCustomers($filter_data);
        // $data['user_view'] = $this->user->user_view;

        // if ($this->user->user_position == 2 && $this->user->user_view == 0) {
        //     $data['user_view'] = 0;
        // } else {
        //     $data['user_view'] = 1;
        // }

        // $data['user_position'] = $this->user->user_position;


        $data['user_view'] = $this->user->user_view;
        $data['user_position'] = $this->user->user_position;

        $data['staffs'] = $this->model_customer_customer->getStaffs();

        foreach ($results as $result) {

            if (!$result['approved']) {
                $approve = $this->url->link('customer/customer/approve', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true);
            } else {
                $approve = '';
            }

            $login_info = $this->model_customer_customer->getTotalLoginAttempts($result['email']);

            if ($login_info && $login_info['total'] > $this->config->get('config_login_attempts')) {
                $unlock = $this->url->link('customer/customer/unlock', 'user_token=' . $this->session->data['user_token'] . '&email=' . $result['email'] . $url, true);
            } else {
                $unlock = '';
            }

            if ($result['gender'] == '1') {
                $gen = $this->language->get('text_male');
            } elseif ($result['gender'] == '2') {
                $gen = $this->language->get('text_female');
            } else {
                $gen = '';
            }

            $add_by_info    = !empty($result['add_by']) ? $this->model_customer_customer->getUserInfo($result['add_by']) : [];
            $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';
            $modify_by_info = !empty($result['modify_by']) ? $this->model_customer_customer->getUserInfo($result['modify_by']) : [];
            $modify_by      = !empty($modify_by_info['name']) ? $modify_by_info['name'] : '';

            $this->load->model('setting/store');
            $data['stores'] = array();

            $sname = $this->config->get('config_name');

            $data['stores'][] = array(
                'store_id' => 0,
                'name' => $sname
            );

            $stores = $this->model_setting_store->getStores();

            foreach ($stores as $store) {
                $data['stores'][] = array(
                    'store_id' => $store['store_id'],
                    'name' => $store['name']
                );
            }

            $user_store_id = $this->model_customer_customer->getUserStore($this->session->data['user_id']);

            $user_store = array_column($user_store_id, 'store_id');
            // var_dump($user_store);
            // die();

            $data['customers'][] = array(
                'top' => $result['top'],
                'customer_id' => $result['customer_id'],
                'name' => $result['name'],
                'email' => $result['email'],
                'telephone' => $result['telephone'],
                'telephone2' => $result['telephone2'],
                'home' => $result['home'],
                'customer_card' => $result['customer_card'],
                'customer_ic' => $result['customer_ic'],
                'customer_group' => $result['customer_group'],
                'gender' => $gen,
                'dob' => $result['dob'],
                'age' => $this->calculateAge($result['dob']),
                'store_name' => $sname,
                'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
                'status_int' => $result['status'],
                'disable_status' => $this->url->link('customer/customer/changeStatus', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . '&status=0' . $url, true),
                'enable_status' => $this->url->link('customer/customer/changeStatus', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . '&status=1' . $url, true),
                'user_store_id' => $user_store,
                'status_color' => $this->getCustomerStatusColor($result['status']),
                'ip' => $result['ip'],
                'add_by' => $add_by,
                'modify_by' => $modify_by,
                'date_added' => date("Y/m/d H:i:s", strtotime($result['date_added'])),
                'date_modified' => date("Y/m/d H:i:s", strtotime($result['date_modified'])),
                'approve' => $approve,
                'unlock' => $unlock,
                'appointment' => $this->url->link('appointment/appointment/add', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true),
                'service_form' => $this->url->link('service/service_form/addCustomer', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true),
                'herbal' => $this->url->link('customer/customer/addMedicalRecord', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true),
                'edit' => $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true)
            );
        }


        // $this->updateProductIdColumn();

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_card'])) {
            $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }


        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_ip'])) {
            $url .= '&filter_ip=' . $this->request->get['filter_ip'];
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_age_from'])) {
            $url .= '&filter_age_from=' . $this->request->get['filter_age_from'];
        }
        if (isset($this->request->get['filter_age_to'])) {
            $url .= '&filter_age_to=' . $this->request->get['filter_age_to'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        // if (isset($this->request->get['filter_date_type'])) {
        //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        // }
        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        $data['sort_email'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.email' . $url, true);
        $data['sort_customer_ic'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $url, true);
        $data['sort_status'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.status' . $url, true);
        $data['sort_customer_card'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_card' . $url, true);
        $data['sort_date_added'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.date_added' . $url, true);
        $data['sort_telephone'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.telephone' . $url, true);
        $data['sort_age'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=age' . $url, 'SSL');
        $data['sort_customer_group'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=age' . $url, 'SSL');
        $data['sort_date_modified'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.date_modified' . $url, true);
        $data['sort_store_id'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.store_id' . $url, true);
        $data['sort_add_by'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.add_by' . $url, true);
        $data['sort_modify_by'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.modify_by' . $url, true);
        $data['sort_gender'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&sort=c.gender' . $url, true);



        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_card'])) {
            $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }
        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }


        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_ip'])) {
            $url .= '&filter_ip=' . $this->request->get['filter_ip'];
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        // if (isset($this->request->get['filter_date_type'])) {
        //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        // }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $customer_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($customer_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($customer_total - $this->config->get('config_limit_admin'))) ? $customer_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $customer_total, ceil($customer_total / $this->config->get('config_limit_admin')));

        $data['filter_name'] = $filter_name;
        $data['filter_card'] = $filter_card;
        $data['filter_ic'] = $filter_ic;
        $data['filter_email'] = $filter_email;
        $data['filter_age_from'] = $filter_age_from;
        $data['filter_age_to'] = $filter_age_to;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer_group'] = $filter_customer_group;
        $data['filter_customer_group_id'] = $filter_customer_group_id;
        $data['filter_status'] = $filter_status;
        $data['filter_approved'] = $filter_approved;
        $data['filter_ip'] = $filter_ip;
        $data['filter_date_added_to'] = $filter_date_added_to;
        $data['filter_date_added_from'] = $filter_date_added_from;
        $data['filter_add_by'] = $filter_add_by;
        $data['filter_gender'] = $filter_gender;
        $data['filter_store_id'] = $filter_store_id;
        // $data['filter_date_type'] = $filter_date_type;



        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        $this->load->model('setting/store');



        //get Doctors
        $doctors = $this->model_customer_customer->getDoctors();
        $data['current_date_added'] = $this->getCurrentDate();

        $store_id = $this->session->data['store_id'];

        $data["form_memory_doc_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $store_id));
        $data["form_memory_service_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $store_id));


        $this->load->model('tool/image');

        $this->load->model('setting/setting');

        foreach ($doctors as $doctor) {


            // $image = !empty($doctor['image']) ? HTTPS_IMAGE . $doctor['image'] : HTTPS_IMAGE . 'catalog/logo/etcm_logo30.png';

            if (!empty($doctor['image'])) {
                $image =  $this->model_tool_image->resize($doctor['image'], 100, 100);
            } else {
                $image = $this->model_tool_image->resize('catalog/logo/etcm_logo30.png', 100, 100);
            }

            $data['doctors'][] = array(
                'user_id'        => $doctor['user_id'],
                'doctor_name'    => $doctor['firstname'] . ' ' . $doctor['lastname'],
                'image'            => $image,
                'description'   => $doctor['description'],
                'other_professions'   => $doctor['other_professions'],
                // 'herbal' => $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] .'&doctor_id=' .$doctor['user_id']. $url, true),
            );
        }



        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');


        $this->response->setOutput($this->load->view('customer/customer_list', $data));
    }

    protected function getForm() {
        $this->load->language('customer/customer');

        $this->load->model('appointment/appointment');
        $this->load->model('herbal/herbal');
        $this->load->model('sale/order');
        $this->load->model('service/service_form');

        $data = [];
        $settings = $this->config->get('config_customer_form_settings');

        if (!empty($settings)) {
            foreach ($settings as $key => $value) {
                $data[$key] = $value;
            }
        }


        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->request->get['customer_id'])) {
            $data['customer_id'] = $this->request->get['customer_id'];
        } else {
            $data['customer_id'] = 0;
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['lastname'])) {
            $data['error_lastname'] = $this->error['lastname'];
        } else {
            $data['error_lastname'] = '';
        }

        if (isset($this->error['card'])) {
            $data['error_card'] = $this->error['card'];
        } else {
            $data['error_card'] = '';
        }

        if (isset($this->error['ic'])) {
            $data['error_ic'] = $this->error['ic'];
        } else {
            $data['error_ic'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['dob'])) {
            $data['error_dob'] = $this->error['dob'];
        } else {
            $data['error_dob'] = '';
        }

        if (isset($this->error['telephone'])) {
            $data['error_telephone'] = $this->error['telephone'];
        } else {
            $data['error_telephone'] = '';
        }

        if (isset($this->error['cheque'])) {
            $data['error_cheque'] = $this->error['cheque'];
        } else {
            $data['error_cheque'] = '';
        }

        if (isset($this->error['paypal'])) {
            $data['error_paypal'] = $this->error['paypal'];
        } else {
            $data['error_paypal'] = '';
        }

        if (isset($this->error['postcode'])) {
            $data['error_postcode'] = $this->error['postcode'];
        } else {
            $data['error_postcode'] = '';
        }


        if (isset($this->error['bank_account_name'])) {
            $data['error_bank_account_name'] = $this->error['bank_account_name'];
        } else {
            $data['error_bank_account_name'] = '';
        }

        if (isset($this->error['bank_account_number'])) {
            $data['error_bank_account_number'] = $this->error['bank_account_number'];
        } else {
            $data['error_bank_account_number'] = '';
        }

        if (isset($this->error['company'])) {
            $data['error_message'] = $this->error['company'];
        } else {
            $data['error_message'] = '';
        }


        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_card'])) {
            $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group_id'])) {
            $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        // if (isset($this->request->get['filter_date_type'])) {
        //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        // }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['customer_id'])) {
            $data['action'] = $this->url->link('customer/customer/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }



        if (isset($this->request->get['customer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
        }

        $data['text_form'] = isset($this->request->get['customer_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');


        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } elseif (!empty($customer_info)) {
            $data['customer_group_id'] = $customer_info['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } elseif (!empty($customer_info)) {
            $data['firstname'] = $customer_info['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } elseif (!empty($customer_info)) {
            $data['lastname'] = $customer_info['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } elseif (!empty($customer_info)) {
            $data['gender'] = $customer_info['gender'];
        } else {
            $data['gender'] = '';
        }

        // if (isset($this->request->post['customer_card'])) {
        //     $data['card'] = $this->request->post['customer_card'];
        // } elseif (!empty($customer_info)) {
        //     $data['card'] = $customer_info['customer_card'];
        // } else {
        //     $data['card'] = '';
        // }

        if (!empty($customer_info)) {
            $data['customer_card'] = $customer_info['customer_card'];
        } elseif (isset($this->request->post['customer_card']) && !empty($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $store_id));
        }

        // $data['customer_card'] = isset($this->request->post['customer_card']) ? $this->request->post['customer_card'] : '';

        // $data['placeholder_customer_card'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $store_id));

        if (isset($this->request->post['customer_ic'])) {
            $data['ic'] = $this->request->post['customer_ic'];
        } elseif (!empty($customer_info)) {
            $data['ic'] = $customer_info['customer_ic'];
        } else {
            $data['ic'] = '';
        }



        if (isset($this->request->post['hosting'])) {
            $data['hosting'] = $this->request->post['hosting'];
        } elseif (!empty($customer_info)) {
            $data['hosting'] = $customer_info['hosting'];
        } else {
            $data['hosting'] = '';
        }


        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } elseif (!empty($customer_info)) {
            $data['dob'] = $customer_info['dob'];
        } else {
            $data['dob'] = '';
        }


        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } elseif (!empty($customer_info)) {
            $data['email'] = $customer_info['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } elseif (!empty($customer_info)) {
            $data['telephone'] = $customer_info['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['telephone2'])) {
            $data['telephone2'] = $this->request->post['telephone2'];
        } elseif (!empty($customer_info)) {
            $data['telephone2'] = $customer_info['telephone2'];
        } else {
            $data['telephone2'] = '';
        }

        if (isset($this->request->post['fax'])) {
            $data['fax'] = $this->request->post['fax'];
        } elseif (!empty($customer_info)) {
            $data['fax'] = $customer_info['fax'];
        } else {
            $data['fax'] = '';
        }

        if (isset($this->request->post['home'])) {
            $data['home'] = $this->request->post['home'];
        } elseif (!empty($customer_info)) {
            $data['home'] = $customer_info['home'];
        } else {
            $data['home'] = '';
        }

        if (isset($this->request->post['religion'])) {
            $data['religion'] = $this->request->post['religion'];
        } elseif (!empty($customer_info)) {
            $data['religion'] = $customer_info['religion'];
        } else {
            $data['religion'] = '';
        }

        if (isset($this->request->post['race'])) {
            $data['race'] = $this->request->post['race'];
        } elseif (!empty($customer_info)) {
            $data['race'] = $customer_info['race'];
        } else {
            $data['race'] = '';
        }

        if (isset($this->request->post['allergic'])) {
            $data['allergic'] = $this->request->post['allergic'];
        } elseif (!empty($customer_info)) {
            $data['allergic'] = $customer_info['allergic'];
        } else {
            $data['allergic'] = '';
        }

        if (isset($this->request->post['diagnostic_history'])) {
            $data['diagnostic_history'] = $this->request->post['diagnostic_history'];
        } elseif (!empty($customer_info)) {
            $data['diagnostic_history'] = $customer_info['diagnostic_history'];
        } else {
            $data['diagnostic_history'] = '';
        }


        if (isset($this->request->post['occupation'])) {
            $data['occupation'] = $this->request->post['occupation'];
        } elseif (!empty($customer_info)) {
            $data['occupation'] = $customer_info['occupation'];
        } else {
            $data['occupation'] = '';
        }

        if (isset($this->request->post['marital_status'])) {
            $data['marital_status'] = $this->request->post['marital_status'];
        } elseif (!empty($customer_info)) {
            $data['marital_status'] = $customer_info['marital_status'];
        } else {
            $data['marital_status'] = 1;
        }

        //set default nationality,races and religion

        $data['nationality'] = 'MALAYSIANS';

        if (empty($data['marital_status'])) {
            $data['marital_status'] = 1;
        }

        $data['religion_id'] = $data['religion'];

        $data['race_id'] = $data['race'];

        //Build Races Data
        $data['races'][] = array(
            'race_id' => 1,
            'name' => $this->language->get('text_malay'),
        );
        $data['races'][] = array(
            'race_id' => 2,
            'name' => $this->language->get('text_chinese'),
        );
        $data['races'][] = array(
            'race_id' => 3,
            'name' => $this->language->get('text_indian'),
        );
        $data['races'][] = array(
            'race_id' => 4,
            'name' => $this->language->get('text_race_indigenous_ethic_group'),
        );
        $data['races'][] = array(
            'race_id' => 5,
            'name' => $this->language->get('text_race_foreigner'),
        );

        //Build Religion Data
        $data['religions'][] = array(
            'religion_id' => 1,
            'name' => $this->language->get('text_islam'),
        );
        $data['religions'][] = array(
            'religion_id' => 2,
            'name' => $this->language->get('text_buddhism'),
        );
        $data['religions'][] = array(
            'religion_id' => 3,
            'name' => $this->language->get('text_hinduism'),
        );
        $data['religions'][] = array(
            'religion_id' => 4,
            'name' => $this->language->get('text_christian'),
        );



        // Custom Fields
        $this->load->model('customer/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_customer_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        if (isset($this->request->post['custom_field'])) {
            $data['account_custom_field'] = $this->request->post['custom_field'];
        } elseif (!empty($customer_info)) {
            $data['account_custom_field'] = unserialize($customer_info['custom_field']);
        } else {
            $data['account_custom_field'] = array();
        }

        if (isset($this->request->post['newsletter'])) {
            $data['newsletter'] = $this->request->post['newsletter'];
        } elseif (!empty($customer_info)) {
            $data['newsletter'] = $customer_info['newsletter'];
        } else {
            $data['newsletter'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($customer_info)) {
            $data['status'] = $customer_info['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['approved'])) {
            $data['approved'] = $this->request->post['approved'];
        } elseif (!empty($customer_info)) {
            $data['approved'] = $customer_info['approved'];
        } else {
            $data['approved'] = true;
        }

        if (isset($this->request->post['safe'])) {
            $data['safe'] = $this->request->post['safe'];
        } elseif (!empty($customer_info)) {
            $data['safe'] = $customer_info['safe'];
        } else {
            $data['safe'] = 0;
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        $product_data = array();


        // if (isset($this->request->post['country_id'])) {
        //     $data['country_id'] = $this->request->post['country_id'];
        // } elseif (!empty($customer_info)) {
        //     $data['country_id'] = $customer_info['country_id'];
        // } else {
        //     $data['country_id'] = '';
        // }

        // $this->load->model('localisation/zone');

        // $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);

        if (isset($this->request->post['config_country_id'])) {
            $data['config_country_id'] = $this->request->post['config_country_id'];
        } else {
            $data['config_country_id'] = $this->config->get('config_country_id');
        }

        // if (isset($this->request->post['config_zone_id'])) {
        //     $data['config_zone_id'] = $this->request->post['config_zone_id'];
        // } else {
        //     $data['config_zone_id'] = $this->config->get('config_zone_id');
        // }

        if (isset($this->request->post['address'])) {
            $data['addresses'] = $this->request->post['address'];
        } elseif (isset($this->request->get['customer_id'])) {
            $data['addresses'] = $this->model_customer_customer->getAddresses($this->request->get['customer_id']);
        } else {
            $data['addresses'] = array();
        }

        if (isset($this->request->post['address_id'])) {
            $data['address_id'] = $this->request->post['address_id'];
        } elseif (!empty($customer_info)) {
            $data['address_id'] = $customer_info['address_id'];
        } else {
            $data['address_id'] = '';
        }



        // get status name
        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->load->model('localisation/order_status');

        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $filter_keys = array('1', '2', '5', '7', '10', '11', '15', '17');
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $filter_keys)) {
                $data['order_statuses'][] = [
                    'order_status_id' => $order_status['order_status_id'],
                    'name' => $order_status['name']
                ];
            }
        }


        //get affiliate
        if (isset($this->request->get['customer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $affiliate_info = $this->model_customer_customer->getAffiliate($this->request->get['customer_id']);
        }

        if (isset($this->request->post['affiliate'])) {
            $data['affiliate'] = $this->request->post['affiliate'];
        } elseif (!empty($affiliate_info)) {
            $data['affiliate'] = $affiliate_info['status'];
        } else {
            $data['affiliate'] = '';
        }

        if (isset($this->request->post['company'])) {
            $data['company'] = $this->request->post['company'];
        } elseif (!empty($affiliate_info)) {
            $data['company'] = $affiliate_info['company'];
        } else {
            $data['company'] = '';
        }

        if (isset($this->request->post['website'])) {
            $data['website'] = $this->request->post['website'];
        } elseif (!empty($affiliate_info)) {
            $data['website'] = $affiliate_info['website'];
        } else {
            $data['website'] = '';
        }

        if (isset($this->request->post['tracking'])) {
            $data['tracking'] = $this->request->post['tracking'];
        } elseif (!empty($affiliate_info)) {
            $data['tracking'] = $affiliate_info['tracking'];
        } else {
            $data['tracking'] = '';
        }

        if (isset($this->request->post['commission'])) {
            $data['commission'] = $this->request->post['commission'];
        } elseif (!empty($affiliate_info)) {
            $data['commission'] = $affiliate_info['commission'];
        } else {
            $data['commission'] = $this->config->get('config_affiliate_commission');
        }

        if (isset($this->request->post['tax'])) {
            $data['tax'] = $this->request->post['tax'];
        } elseif (!empty($affiliate_info)) {
            $data['tax'] = $affiliate_info['tax'];
        } else {
            $data['tax'] = '';
        }

        if (isset($this->request->post['payment'])) {
            $data['payment'] = $this->request->post['payment'];
        } elseif (!empty($affiliate_info)) {
            $data['payment'] = $affiliate_info['payment'];
        } else {
            $data['payment'] = 'cheque';
        }

        if (isset($this->request->post['cheque'])) {
            $data['cheque'] = $this->request->post['cheque'];
        } elseif (!empty($affiliate_info)) {
            $data['cheque'] = $affiliate_info['cheque'];
        } else {
            $data['cheque'] = '';
        }

        if (isset($this->request->post['paypal'])) {
            $data['paypal'] = $this->request->post['paypal'];
        } elseif (!empty($affiliate_info)) {
            $data['paypal'] = $affiliate_info['paypal'];
        } else {
            $data['paypal'] = '';
        }

        if (isset($this->request->post['bank_name'])) {
            $data['bank_name'] = $this->request->post['bank_name'];
        } elseif (!empty($affiliate_info)) {
            $data['bank_name'] = $affiliate_info['bank_name'];
        } else {
            $data['bank_name'] = '';
        }

        if (isset($this->request->post['bank_branch_number'])) {
            $data['bank_branch_number'] = $this->request->post['bank_branch_number'];
        } elseif (!empty($affiliate_info)) {
            $data['bank_branch_number'] = $affiliate_info['bank_branch_number'];
        } else {
            $data['bank_branch_number'] = '';
        }

        if (isset($this->request->post['bank_swift_code'])) {
            $data['bank_swift_code'] = $this->request->post['bank_swift_code'];
        } elseif (!empty($affiliate_info)) {
            $data['bank_swift_code'] = $affiliate_info['bank_swift_code'];
        } else {
            $data['bank_swift_code'] = '';
        }

        if (isset($this->request->post['bank_account_name'])) {
            $data['bank_account_name'] = $this->request->post['bank_account_name'];
        } elseif (!empty($affiliate_info)) {
            $data['bank_account_name'] = $affiliate_info['bank_account_name'];
        } else {
            $data['bank_account_name'] = '';
        }

        if (isset($this->request->post['bank_account_number'])) {
            $data['bank_account_number'] = $this->request->post['bank_account_number'];
        } elseif (!empty($affiliate_info)) {
            $data['bank_account_number'] = $affiliate_info['bank_account_number'];
        } else {
            $data['bank_account_number'] = '';
        }

        if (isset($this->request->post['custom_field'])) {
            $data['affiliate_custom_field'] = $this->request->post['custom_field'];
        } elseif (!empty($affiliate_info)) {
            $data['affiliate_custom_field'] = json_decode($affiliate_info['custom_field'], true);
        } else {
            $data['affiliate_custom_field'] = array();
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('customer/customer_form', $data));
    }

    protected function validateForm() {
        $settings = $this->config->get('config_customer_form_settings');
        foreach ($settings as $key => $value) {
            $data[$key] = $value;
        }

        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!empty($this->request->post['firstname'])) {
            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 100)) {
                $this->error['firstname'] = $this->language->get('error_message_required');
            }
        } else {
            if (!empty($data['config_customer_form_firstname_required'])) {
                $this->error['firstname'] = $this->language->get('error_message_required');
            }
        }

        if (!empty($this->request->post['lastname'])) {
            if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 100)) {
                $this->error['lastname'] = $this->language->get('error_message_required');
            }
        } else {
            if (!empty($data['config_customer_form_lastname_required'])) {
                $this->error['lastname'] = $this->language->get('error_message_required');
            }
        }

        if (!empty($this->request->post['telephone'])) {
            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if (isset($data['config_customer_form_telephone_duplicate_validation']) && $data['config_customer_form_telephone_duplicate_validation'] != 0) {
                if (!isset($this->request->get['customer_id']) && $this->model_customer_customer->customerExistsByPhone($this->request->post['telephone']) && empty($this->error['telephone'])) {
                    $this->error['telephone'] = $this->language->get('error_telephone_exists');
                }

                if (isset($this->request->get['customer_id']) && empty($this->error['telephone'])) {
                    $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
                    if ($this->request->post['telephone'] != $customer_info['telephone'] && $this->model_customer_customer->customerExistsByPhone($this->request->post['telephone'])) {
                        $this->error['telephone'] = $this->language->get('error_telephone_exists');
                    }
                }
            }
        } else {
            if (!empty($data['config_customer_form_telephone_required'])) {
                $this->error['telephone'] = $this->language->get('error_message_required');
            }
        }

        if (!empty($this->request->post['customer_ic'])) {
            if ((utf8_strlen($this->request->post['customer_ic']) < 1) || (utf8_strlen(trim($this->request->post['customer_ic'])) > 32)) {
                $this->error['ic'] = $this->language->get('error_message_required');
            }


            if (isset($data['config_customer_form_customer_ic_duplicate_validation']) && $data['config_customer_form_customer_ic_duplicate_validation'] != 0) {
                if (!isset($this->request->get['customer_id']) && $this->model_customer_customer->customerExistsByIc($this->request->post['customer_ic'])) {
                    $this->error['ic'] = $this->language->get('error_ic_exists');
                }

                if (isset($this->request->get['customer_id'])) {
                    $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
                    if ($this->request->post['customer_ic'] != $customer_info['customer_ic'] && $this->model_customer_customer->customerExistsByIc($this->request->post['customer_ic'])) {
                        $this->error['ic'] = $this->language->get('error_ic_exists');
                    }
                }
            }
        } else {
            if (!empty($data['config_customer_form_customer_ic_required'])) {
                $this->error['ic'] = $this->language->get('error_message_required');
            }
        }

        if (!empty($this->request->post['customer_card'])) {
            if ((utf8_strlen($this->request->post['customer_card']) < 1) || (utf8_strlen(trim($this->request->post['customer_card'])) > 32)) {
                $this->error['card'] = $this->language->get('error_message_required');
            }

            if (isset($data['config_customer_form_customer_card_duplicated_validation']) && $data['config_customer_form_customer_card_duplicated_validation'] != 0) {
                if (!isset($this->request->get['customer_id']) && $this->model_customer_customer->customerExistsByCard($this->request->post['customer_card']) && empty($this->error['card'])) {
                    $this->error['card'] = $this->language->get('error_card_exists');
                }

                if (isset($this->request->get['customer_id'])) {
                    $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
                    if ($this->request->post['customer_card'] != $customer_info['customer_card'] && $this->model_customer_customer->customerExistsByCard($this->request->post['customer_card'])) {
                        $this->error['card'] = $this->language->get('error_card_exists');
                    }
                }
            }
        } else {
            if (!empty($data['config_customer_form_customer_card_required'])) {
                $this->error['card'] = $this->language->get('error_message_required');
            }
        }

        // Load the library
        $this->load->library('validation/Email');

        $this->validation_email = new Validation\Email();
        if (!empty($this->request->post['email'])) {
            // Call the validateEmail method on the Email object
            if (!$this->validation_email->validateEmail($this->request->post['email'])) {
                $this->error['email'] = $this->language->get('error_message_invalid_email');
            }

            // Second validation
            if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
                $this->error['email'] = $this->language->get('error_message_invalid_email');
            }

            if (isset($data['config_customer_form_email_duplicate_validation']) && $data['config_customer_form_email_duplicate_validation'] != 0) {
                if (!isset($this->request->get['customer_id']) && $this->model_customer_customer->customerExistsByEmail($this->request->post['email']) && empty($this->error['email'])) {
                    $this->error['email'] = $this->language->get('error_email_exists');
                }

                if (isset($this->request->get['customer_id'])) {
                    $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
                    if ($this->request->post['email'] != $customer_info['email'] && $this->model_customer_customer->customerExistsByEmail($this->request->post['email'])) {
                        $this->error['email'] = $this->language->get('error_email_exists');
                    }
                }
            }
        } else {
            if (!empty($data['config_customer_form_email_required'])) {
                $this->error['email'] = $this->language->get('error_message_required');
            }
        }

        if (!empty($this->request->post['telephone'])) {
            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if (isset($data['config_customer_form_telephone_duplicate_validation']) && $data['config_customer_form_telephone_duplicate_validation'] != 0) {
                if (!isset($this->request->get['customer_id']) && $this->model_customer_customer->customerExistsByPhone($this->request->post['telephone']) && empty($this->error['telephone'])) {
                    $this->error['telephone'] = $this->language->get('error_telephone_exists');
                }
            }

            if (isset($this->request->get['customer_id']) && empty($this->error['telephone'])) {
                $customer_info = $this->model_customer_customer->getCustomer($this->request->get['customer_id']);
                if ($this->request->post['telephone'] != $customer_info['telephone'] && $this->model_customer_customer->customerExistsByPhone($this->request->post['telephone'])) {
                    $this->error['telephone'] = $this->language->get('error_telephone_exists');
                }
            }
        } else {
            if (!empty($data['config_customer_form_telephone_required'])) {
                $this->error['telephone'] = $this->language->get('error_message_required');
            }
        }


        // Custom field validation
        $this->load->model('customer/custom_field');

        $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

        foreach ($custom_fields as $custom_field) {
            if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
            } elseif (($custom_field['location'] == 'account') && ($custom_field['type'] == 'text') && !empty($custom_field['validation']) && !filter_var($this->request->post['custom_field'][$custom_field['custom_field_id']], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => $custom_field['validation'])))) {
                $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
            }
        }

        if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
            if ($this->request->post['password'] != $this->request->post['confirm']) {
                $this->error['confirm'] = $this->language->get('error_confirm');
            }
        }

        if (isset($this->request->post['address'])) {
            foreach ($this->request->post['address'] as $key => $value) {
                if (!empty($value['firstname'])) {
                    if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 100)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_message_required');
                    }
                } else {
                    if (!empty($data['config_address_form_firstname_required'])) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_message_required');
                    }
                }

                if (!empty($value['lastname'])) {
                    if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_message_required');
                    }
                } else {
                    if (!empty($data['config_address_form_lastname_required'])) {
                        $this->error['address'][$key]['lastname'] = $this->language->get('error_message_required');
                    }
                }

                // if (!empty($value['company'])) {
                //     if ((utf8_strlen($value['company']) < 1) || (utf8_strlen($value['company']) > 32)) {
                //         $this->error['address'][$key]['company'] = $this->language->get('error_message_required');
                //     }
                // } else {
                //     if (!empty($data['config_address_form_company_required'])) {
                //         $this->error['address'][$key]['company'] = $this->language->get('error_message_required');
                //     }
                // }

                if (!empty($data['config_address_form_company_required'])) {
                    if ((utf8_strlen($value['company']) < 1) || (utf8_strlen($value['company']) > 32)) {
                        $this->error['address'][$key]['company'] = $this->language->get('error_message_required');
                    }
                }

                if (!empty($value['address_1'])) {
                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_message_required');
                    }
                } else {
                    if (!empty($data['config_address_form_address_1_required'])) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_message_required');
                    }
                }

                if (!empty($value['city'])) {
                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_message_required');
                    }
                } else {
                    if (!empty($data['config_address_form_city_required'])) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_message_required');
                    }
                }


                $this->load->model('localisation/country');

                $country_info = $this->model_localisation_country->getCountry($value['country_id']);


                if (!empty($value['postcode'])) {
                    if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_message_required');
                    }
                } else {
                    if (!empty($data['config_address_form_postcode_required'])) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_message_required');
                    }
                }


                // if (!empty($value['country_id'])) {
                //     if (empty($data['config_address_form_country_required'])) {
                //         $this->error['address'][$key]['country'] = $this->language->get('error_country');
                //     }
                // }


                if (empty($value['zone_id'])) {
                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_complete_required');
                    }
                } else {
                    if (empty($data['config_address_form_country_required'])) {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_complete_required');
                    }
                }


                foreach ($custom_fields as $custom_field) {
                    if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                        $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                    } elseif (($custom_field['location'] == 'address') && ($custom_field['type'] == 'text') && !empty($custom_field['validation']) && !filter_var($value['custom_field'][$custom_field['custom_field_id']], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => $custom_field['validation'])))) {
                        $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                    }
                }
            }
        }

        if ($this->request->post['affiliate']) {
            if ($this->request->post['payment'] == 'cheque') {
                if ($this->request->post['cheque'] == '') {
                    $this->error['cheque'] = $this->language->get('error_cheque');
                }
            } elseif ($this->request->post['payment'] == 'paypal') {
                if ((utf8_strlen($this->request->post['paypal']) > 96) || !filter_var($this->request->post['paypal'], FILTER_VALIDATE_EMAIL)) {
                    $this->error['paypal'] = $this->language->get('error_paypal');
                }
            } elseif ($this->request->post['payment'] == 'bank') {
                if ($this->request->post['bank_account_name'] == '') {
                    $this->error['bank_account_name'] = $this->language->get('error_bank_account_name');
                }

                if ($this->request->post['bank_account_number'] == '') {
                    $this->error['bank_account_number'] = $this->language->get('error_bank_account_number');
                }
            }

            if (!$this->request->post['tracking']) {
                $this->error['tracking'] = $this->language->get('error_tracking');
            }

            $affiliate_info = $this->model_customer_customer->getAffliateByTracking($this->request->post['tracking']);

            if (!isset($this->request->get['customer_id'])) {
                if ($affiliate_info) {
                    $this->error['tracking'] = $this->language->get('error_tracking_exists');
                }
            } else {
                if ($affiliate_info && ($this->request->get['customer_id'] != $affiliate_info['customer_id'])) {
                    $this->error['tracking'] = $this->language->get('error_tracking_exists');
                }
            }

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'affiliate') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = $this->language->get('error_custom_field');
                    $custom_field['name'];
                } elseif (($custom_field['location'] == 'affiliate') && ($custom_field['type'] == 'text') && !empty($custom_field['validation']) && !filter_var($this->request->post['custom_field'][$custom_field['custom_field_id']], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => $custom_field['validation'])))) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = $this->language->get('error_custom_field');
                    $custom_field['name'];
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        //     echo '<pre>';
        // print_r($this->error);
        // echo '</pre>';

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function validateApprove() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function validateUnlock() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function validateHistory() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!isset($this->request->post['comment']) || utf8_strlen($this->request->post['comment']) < 1) {
            $this->error['warning'] = $this->language->get('error_comment');
        }

        return !$this->error;
    }

    public function login() {
        if (isset($this->request->get['customer_id'])) {
            $customer_id = $this->request->get['customer_id'];
        } else {
            $customer_id = 0;
        }

        $this->load->model('customer/customer');

        $customer_info = $this->model_customer_customer->getCustomer($customer_id);

        if ($customer_info) {
            // Create token to login with
            $token = token(64);

            $this->model_customer_customer->editToken($customer_id, $token);

            if (isset($this->request->get['store_id'])) {
                $store_id = $this->request->get['store_id'];
            } else {
                $store_id = 0;
            }

            $this->load->model('setting/store');

            $store_info = $this->model_setting_store->getStore($store_id);

            if ($store_info) {
                $this->response->redirect($store_info['url'] . 'index.php?route=account/login&token=' . $token);
            } else {
                $this->response->redirect(HTTP_CATALOG . 'index.php?route=account/login&token=' . $token);
            }
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function history() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateHistory()) {
            $this->model_customer_customer->addHistory($this->request->get['customer_id'], $this->request->post['comment']);

            $data['success'] = $this->language->get('text_success');
        } else {
            $data['success'] = '';
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['text_no_results'] = $this->language->get('text_no_results');

        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_comment'] = $this->language->get('column_comment');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['histories'] = array();

        $results = $this->model_customer_customer->getHistories($this->request->get['customer_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['histories'][] = array(
                'comment' => $result['comment'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $history_total = $this->model_customer_customer->getTotalHistories($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $history_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/history', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($history_total - 10)) ? $history_total : ((($page - 1) * 10) + 10), $history_total, ceil($history_total / 10));

        $this->response->setOutput($this->load->view('customer/customer_history', $data));
    }

    public function transaction() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['transactions'] = array();

        $results = $this->model_customer_customer->getTransactions($this->request->get['customer_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['transactions'][] = array(
                'amount' => $this->currency->format($result['amount'], $this->config->get('config_currency')),
                'description' => $result['description'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $data['balance'] = $this->currency->format($this->model_customer_customer->getTransactionTotal($this->request->get['customer_id']), $this->config->get('config_currency'));

        $transaction_total = $this->model_customer_customer->getTotalTransactions($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $transaction_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/transaction', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($transaction_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($transaction_total - 10)) ? $transaction_total : ((($page - 1) * 10) + 10), $transaction_total, ceil($transaction_total / 10));

        $this->response->setOutput($this->load->view('customer/customer_transaction', $data));
    }

    public function addTransaction() {
        $this->load->language('customer/customer');

        $json = array();

        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            $this->load->model('customer/customer');

            $this->model_customer_customer->addTransaction($this->request->get['customer_id'], $this->request->post['description'], $this->request->post['amount']);

            $json['success'] = $this->language->get('text_success');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function reward() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->user->hasPermission('modify', 'customer/customer')) {
            $this->model_customer_customer->addReward($this->request->get['customer_id'], $this->request->post['description'], $this->request->post['points']);

            $data['success'] = $this->language->get('text_success');
        } else {
            $data['success'] = '';
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && !$this->user->hasPermission('modify', 'customer/customer')) {
            $data['error_warning'] = $this->language->get('error_permission');
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['rewards'] = array();

        $results = $this->model_customer_customer->getRewards($this->request->get['customer_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['rewards'][] = array(
                'points' => $result['points'],
                'description' => $result['description'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $data['balance'] = $this->model_customer_customer->getRewardTotal($this->request->get['customer_id']);

        $reward_total = $this->model_customer_customer->getTotalRewards($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $reward_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/reward', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($reward_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($reward_total - 10)) ? $reward_total : ((($page - 1) * 10) + 10), $reward_total, ceil($reward_total / 10));

        $this->response->setOutput($this->load->view('customer/customer_reward', $data));
    }

    public function ip() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['ips'] = array();

        $results = $this->model_customer_customer->getIps($this->request->get['customer_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $ban_ip_total = $this->model_customer_customer->getTotalBanIpsByIp($result['ip']);

            $data['ips'][] = array(
                'ip' => $result['ip'],
                'total' => $this->model_customer_customer->getTotalCustomersByIp($result['ip']),
                'date_added' => date('d/m/y', strtotime($result['date_added'])),
                'filter_ip' => $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . '&filter_ip=' . $result['ip'], true),
                'ban_ip' => $ban_ip_total
            );
        }

        $ip_total = $this->model_customer_customer->getTotalIps($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $ip_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/ip', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($ip_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($ip_total - 10)) ? $ip_total : ((($page - 1) * 10) + 10), $ip_total, ceil($ip_total / 10));

        $this->response->setOutput($this->load->view('customer/customer_ip', $data));
    }

    public function appointment() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('user/user');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['customer_appointments'] = array();

        if (isset($this->request->get['customer_id'])) {
            $appointments = $this->model_customer_customer->getAppointmentsbyCustomerId($this->request->get['customer_id'], ($page - 1) * 10, 10);
            $url = '';
            if (!empty($appointments)) {
                foreach ($appointments as $appointment) {
                    if ($appointment['doctor_id'] > 0) {
                        $doctor_info = $this->model_user_user->getDoctor($appointment['doctor_id']);

                        if (!empty($doctor_info)) {
                            $doctor_name = $doctor_info['firstname'] . ' ' . $doctor_info['lastname'];
                        } else {
                            $doctor_name = '';
                        }
                    } else {
                        $doctor_name = '';
                    }

                    $this->load->model('setting/store');
                    $data['stores'] = array();

                    $sname = $this->config->get('config_name');

                    $data['stores'][] = array(
                        'store_id' => 0,
                        'name' => $sname
                    );


                    $add_by_info    = !empty($appointment['created_by']) ? $this->model_customer_customer->getUserInfo($appointment['created_by']) : [];
                    $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';

                    $data['customer_appointments'][] = [
                        'appointment_id' => $appointment['appointment_id'],
                        'date' => date("D, d M Y h:i A", strtotime($appointment['appointment_date'])),
                        'created_date' => date("D, d M Y h:i A", strtotime($appointment['created_date'])),
                        'time' => $appointment['appointment_time'],
                        'doctor_name' => $doctor_name,
                        'from_etcm' => $appointment['from_etcm'],
                        'serviceName' => $appointment['name'],
                        'store_name' => $sname,
                        'status' => $appointment['status'],
                        'created_by' => $add_by,
                        'view' => $this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $appointment['appointment_id'] . $url, true)
                    ];
                }
            }
        }

        $Total_Appointment = $this->model_customer_customer->getTotalAppointment($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $Total_Appointment;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/appointment', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($Total_Appointment) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($Total_Appointment - 10)) ? $Total_Appointment : ((($page - 1) * 10) + 10), $Total_Appointment, ceil($Total_Appointment / 3));

        $this->response->setOutput($this->load->view('customer/customer_appointment', $data));
    }

    public function medicalHistory() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('user/user');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['herbalremedies'] = array();
        $url = '';
        if (isset($this->request->get['customer_id'])) {
            $herbalremedies = $this->model_customer_customer->getHerbalbyCustomerId($this->request->get['customer_id'], ($page - 1) * 5, 5);
            if (!empty($herbalremedies)) {
                foreach ($herbalremedies as $herbal) {
                    if ($herbal['doctor_id'] > 0) {
                        $doctor_info = $this->model_user_user->getDoctor($herbal['doctor_id']);

                        if (!empty($doctor_info)) {
                            $doctor_name = $doctor_info['firstname'] . ' ' . $doctor_info['lastname'];
                        } else {
                            $doctor_name = '';
                        }
                    } else {
                        $doctor_name = '';
                    }

                    $this->load->model('setting/store');
                    $data['stores'] = array();

                    $sname = $this->config->get('config_name');

                    $data['stores'][] = array(
                        'store_id' => 0,
                        'name' => $sname
                    );

                    if ($herbal['collect_consultation_price'] > 0) {
                        $consultation_price = $herbal['clinicalsale_concultation'] * 1.06;
                    } else {
                        $consultation_price = $herbal['clinicalsale_concultation'] + $herbal['d_gst'];
                    }

                    $add_by_info    = !empty($herbal['add_by']) ? $this->model_customer_customer->getUserInfo($herbal['add_by']) : [];
                    $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';


                    $data['herbalremedies'][] = [
                        'clinical_sale_id' => $herbal['clinical_sale_id'],
                        'sales_date' => date("D, d M Y", strtotime($herbal['sales_date'])),
                        'invoice_prefix' => $herbal['invoice_prefix'],
                        'order_invoice_prefix' => $herbal['order_invoice_prefix'],
                        'order_action' => $herbal['order_action'],
                        'clinicalsale_action' => $herbal['clinicalsale_action'],
                        'clinicalsale_total' => $herbal['clinicalsale_total'],
                        'consultation_price' => sprintf('%.2f', $consultation_price),
                        'total_d_gst' => $herbal['total_d_gst'],
                        'doctor_name' => $doctor_name,
                        'store_name' => $sname,
                        'date_added' => date("D, d M Y h:i A", strtotime($herbal['date_added'])),
                        'add_by' => $add_by,
                        'edit' => $this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbal['clinical_sale_id'] . $url, true),
                        'info' => $this->url->link('herbal/new_herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbal['clinical_sale_id'] . $url, true),
                    ];
                }
            }
        }

        $total_medicalHistory = $this->model_customer_customer->getTotalMedicalHistory($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $total_medicalHistory;
        $pagination->page = $page;
        $pagination->limit = 5;
        $pagination->url = $this->url->link('customer/customer/medicalHistory', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_medicalHistory) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($total_medicalHistory - 5)) ? $total_medicalHistory : ((($page - 1) * 5) + 5), $total_medicalHistory, ceil($total_medicalHistory / 5));


        $this->response->setOutput($this->load->view('customer/customer_medicalHistory', $data));
    }

    public function serviceForm() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('user/user');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['serviceforms'] = array();
        $url = '';
        if (isset($this->request->get['customer_id'])) {
            $serviceforms = $this->model_customer_customer->getServiceformbyCustomerId($this->request->get['customer_id'], ($page - 1) * 10, 10);

            if (!empty($serviceforms)) {
                foreach ($serviceforms as $serviceform) {


                    $this->load->model('setting/store');
                    $data['stores'] = array();

                    $sname = $this->config->get('config_name');

                    $data['stores'][] = array(
                        'store_id' => 0,
                        'name' => $sname
                    );

                    $add_by_info    = !empty($serviceform['add_by']) ? $this->model_customer_customer->getUserInfo($serviceform['add_by']) : [];
                    $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';

                    $data['serviceforms'][] = array(
                        'serviceform_id' => $serviceform['service_form_id'],
                        'invoice_prefix' => $serviceform['invoice_prefix'],
                        'customer_ic' => $serviceform['customer_ic'],
                        'customer_card' => $serviceform['customer_card'],
                        'serviceform_action' => $serviceform['serviceform_action'],
                        'order_action' => $serviceform['order_action'],
                        'store_name' => $sname,
                        'total_price' => $serviceform['total_price'],
                        'service_date' => date("D, d M Y", strtotime($serviceform['service_date'])),
                        'date_added' => date("D, d M Y h:i A", strtotime($serviceform['date_added'])),
                        'add_by' => $add_by,
                        'payment_status_id' => $serviceform['order_action'],
                        'edit' => $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform['service_form_id'] . $url, true),
                        'info' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform['service_form_id'] . $url, true)
                    );
                }
            }
        }

        $total_serviceForm = $this->model_customer_customer->getTotalServiceForm($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $total_serviceForm;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/serviceForm', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_serviceForm) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($total_serviceForm - 10)) ? $total_serviceForm : ((($page - 1) * 10) + 10), $total_serviceForm, ceil($total_serviceForm / 10));

        $this->response->setOutput($this->load->view('customer/customer_serviceForm', $data));
    }

    public function serviceItem() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('user/user');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['serviceitems'] = array();
        $url = '';
        if (isset($this->request->get['customer_id'])) {
            $serviceitems = $this->model_customer_customer->getServiceItem($this->request->get['customer_id'], ($page - 1) * 10, 10);


            if (!empty($serviceitems)) {
                foreach ($serviceitems as $serviceitem) {

                    if ($serviceitem['user_id'] > 0) {
                        $doctor_info = $this->model_user_user->getDoctor($serviceitem['user_id']);

                        if (!empty($doctor_info)) {
                            $doctor_name = $doctor_info['firstname'] . ' ' . $doctor_info['lastname'];
                        } else {
                            $doctor_name = '';
                        }
                    } else {
                        $doctor_name = '';
                    }

                    $this->load->model('setting/store');
                    $data['stores'] = array();

                    $sname = $this->config->get('config_name');

                    $data['stores'][] = array(
                        'store_id' => 0,
                        'name' => $sname
                    );

                    $modifi_by_info    = !empty($serviceitem['modifi_by']) ? $this->model_customer_customer->getUserInfo($serviceitem['modifi_by']) : [];
                    $modifi_by         = !empty($modifi_by_info['name']) ? $modifi_by_info['name'] : '';

                    $data['serviceitems'][] = array(
                        'serviceform_id' => $serviceitem['service_form_id'],
                        'invoice_prefix' => $serviceitem['invoice_prefix'],
                        'serviceform_action' => $serviceitem['serviceform_action'],
                        'order_action' => $serviceitem['name1'],
                        'store_name' => $sname,
                        'total_price' => $serviceitem['total_price'],
                        'service_date' => date("D, d M Y", strtotime($serviceitem['service_date'])),
                        'date_modifed' => date("D, d M Y h:i A", strtotime($serviceitem['date_modified'])),
                        'modifi_by' => $modifi_by,
                        'serviceName' => $serviceitem['servicename'],
                        'serviceminutes' => $serviceitem['serviceminutes'],
                        'doctor_name' =>  $serviceitem['doctor_name'],
                        'payment_status_id' => $serviceitem['order_action'],
                        'edit' => $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceitem['service_form_id'] . $url, true),
                        'info' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceitem['service_form_id'] . $url, true)
                    );
                }
            }
        }

        $total_serviceItem = $this->model_customer_customer->getTotalServiceItem($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $total_serviceItem;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/serviceItem', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_serviceItem) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($total_serviceItem - 10)) ? $total_serviceItem : ((($page - 1) * 10) + 10), $total_serviceItem, ceil($total_serviceItem / 10));

        $this->response->setOutput($this->load->view('customer/customer_serviceItem', $data));
    }

    public function customer_sales() {
        $this->load->language('customer/customer');

        $this->load->model('customer/customer');
        $this->load->model('user/user');


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }



        $data['serviceitems'] = array();
        $url = '';
        if (isset($this->request->get['customer_id'])) {
            $orders = $this->model_customer_customer->getSaleOrderbyCustomerId($this->request->get['customer_id'], ($page - 1) * 10, 10);

            if (!empty($orders)) {
                foreach ($orders as $order) {

                    $add_by_info    = !empty($order['add_by']) ? $this->model_customer_customer->getUserInfo($order['add_by']) : [];
                    $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';

                    $status_color = $this->getOrderStatusColor($order['order_status_id']);


                    if (isset($this->request->get['order_id'])) {
                        $order_id = $this->request->get['order_id'];
                    } else {
                        $order_id = 0;
                    }

                    // $order_info = $this->model_customer_customer->getOrder($order_id);


                    $data['products'] = array();
                    $herbales = $this->model_customer_customer->getPaidHerbals($order['order_id']);
                    $services = $this->model_customer_customer->getServices($order['order_id']);
                    $products = $this->model_customer_customer->getOrderProducts($order['order_id']);


                    foreach ($herbales as $herbale) {
                        if ($herbale['collect_consultation_price'] == 1) {
                            // $consultation_total = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                            $data['products'][] = array(
                                'order_product_id' => $herbale['clinical_sale_id'],
                                'product_id' => $herbale['clinical_sale_id'],
                                'name' => $this->language->get('text_herbal'),
                                'model' => $herbale['invoice_prefix'],
                                'quantity' => 1,
                            );
                        } else {
                            $data['products'][] = array(
                                'order_product_id' => $herbale['clinical_sale_id'],
                                'product_id' => $herbale['clinical_sale_id'],
                                'name' => $this->language->get('text_free_consultation'),
                                'model' => $herbale['invoice_prefix'],
                                'quantity' => 1,
                            );
                        }
                    }

                    foreach ($services as $service) {
                        $data['products'][] = array(
                            'order_product_id' => $service['service_Item_id'],
                            'product_id' => $service['clinicalservice_id'],
                            'name' => $service['servicename'],
                            'model' => $service['invoice_prefix'],
                            'quantity' => 1
                        );
                    }

                    foreach ($products as $product) {
                        $data['products'][] = array(
                            'order_product_id' => $product['order_product_id'],
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'model' => $product['model'],
                            'quantity' => $product['quantity']
                        );
                    }

                    $total_item = count($data['products']);

                    $data['orders'][] = array(
                        'order_id' => $order['order_id'],
                        'invoice_prefix' => $order['invoice_prefix'],
                        'invoice_date' => $order['invoice_date'],
                        'order_status_id' => $order['order_status_id'],
                        'status_color' => $status_color,
                        'status' => $order['status'],
                        'store_name' => $order['store_name'],
                        'payment_method' => $order['payment_method'],
                        'comment' => $order['comment'],
                        'total_item' => $total_item,
                        'total' => $this->currency->format($order['total'], $order['currency_code'], $order['currency_value']),
                        'date_added' => date("D, d M Y h:i A", strtotime($order['date_added'])),
                        'add_by' => $add_by,
                        'print_invoice' => $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=' . $order['order_id'] . $url, true),
                        'print_receipt' => $this->url->link('sale/order/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=' . $order['order_id'] . $url, true),
                        'view' => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'] . $url, true),
                        'edit' => $this->url->link('sale/order/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'] . $url, true),
                        'info' => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'] . $url, true),
                        // 'hold' => $this->url->link('sale/order/hold_order', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'] . $url, true)
                    );
                }
            }
        }

        $total_customer_sales = $this->model_customer_customer->getTotalCustomerSales($this->request->get['customer_id']);

        $pagination = new Pagination();
        $pagination->total = $total_customer_sales;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('customer/customer/customer_sales', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customer_sales) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($total_customer_sales - 10)) ? $total_customer_sales : ((($page - 1) * 10) + 10), $total_customer_sales, ceil($total_customer_sales / 10));

        $this->response->setOutput($this->load->view('customer/customer_sales', $data));
    }


    public function addBanIp() {
        $this->load->language('customer/customer');

        $json = array();

        if (isset($this->request->post['ip'])) {
            if (!$this->user->hasPermission('modify', 'customer/customer')) {
                $json['error'] = $this->language->get('error_permission');
            } else {
                $this->load->model('customer/customer');

                $this->model_customer_customer->addBanIp($this->request->post['ip']);

                $json['success'] = $this->language->get('text_success');
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeBanIp() {
        $this->load->language('customer/customer');

        $json = array();

        if (isset($this->request->post['ip'])) {
            if (!$this->user->hasPermission('modify', 'customer/customer')) {
                $json['error'] = $this->language->get('error_permission');
            } else {
                $this->load->model('customer/customer');

                $this->model_customer_customer->removeBanIp($this->request->post['ip']);

                $json['success'] = $this->language->get('text_success');
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    //mlax wong
    public function autocomplete() {
        $json = array();

        if (
            isset($this->request->get['filter_name']) ||
            isset($this->request->get['filter_email']) ||
            isset($this->request->get['filter_telephone']) ||
            isset($this->request->get['filter_card']) ||
            isset($this->request->get['filter_ic']) ||
            isset($this->request->get['filter_customer_search']) ||
            isset($this->request->get['exactly_ic'])
            // isset($this->request->get['filter_gender'])||
            // isset($this->request->get['filter_add_by'])||
            // isset($this->request->get['filter_status'])||
            // isset($this->request->get['filter_approved'])

        ) {
            if (isset($this->request->get['filter_name'])) {
                $filter_name = $this->request->get['filter_name'];
            } else {
                $filter_name = '';
            }

            if (isset($this->request->get['filter_customer_search'])) {
                $filter_customer_search = $this->request->get['filter_customer_search'];
            } else {
                $filter_customer_search = '';
            }

            if (isset($this->request->get['filter_email'])) {
                $filter_email = $this->request->get['filter_email'];
            } else {
                $filter_email = '';
            }

            if (isset($this->request->get['filter_affiliate'])) {
                $filter_affiliate = $this->request->get['filter_affiliate'];
            } else {
                $filter_affiliate = '';
            }

            if (isset($this->request->get['filter_ic'])) {
                $filter_ic = $this->request->get['filter_ic'];
            } else {
                $filter_ic = '';
            }


            if (isset($this->request->get['exactly_ic'])) {
                $exactly_ic = $this->request->get['exactly_ic'];
            } else {
                $exactly_ic = '';
            }

            if (isset($this->request->get['filter_telephone'])) {
                $filter_telephone = $this->request->get['filter_telephone'];
            } else {
                $filter_telephone = '';
            }

            if (isset($this->request->get['filter_card'])) {
                $filter_card = $this->request->get['filter_card'];
            } else {
                $filter_card = '';
            }


            // if (isset($this->request->get['filter_gender'])) {
            //     $filter_gender = $this->request->get['filter_gender'];
            // } else {
            //     $filter_gender = '';
            // }

            // if (isset($this->request->get['filter_add_by'])) {
            //     $filter_add_by = $this->request->get['filter_add_by'];
            // } else {
            //     $filter_add_by = '';
            // }

            // if (isset($this->request->get['filter_status'])) {
            //     $filter_status = $this->request->get['filter_status'];
            // } else {
            //     $filter_status = '';
            // }

            // if (isset($this->request->get['filter_approved'])) {
            //     $filter_approved = $this->request->get['filter_approved'];
            // } else {
            //     $filter_approved = '';
            // }

            $this->load->model('customer/customer');

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_email' => $filter_email,
                'filter_ic' => $filter_ic,
                'exactly_ic' => $exactly_ic,
                'filter_affiliate' => $filter_affiliate,
                'filter_telephone' => $filter_telephone,
                'filter_card' => $filter_card,
                'filter_customer_search' => $filter_customer_search,
                // 'filter_gender'=> $filter_gender,
                // 'filter_add_by'=> $filter_add_by,
                // 'filter_approved'=> $filter_approved,
                // 'filter_status'=> $filter_status,
                'start' => 0,
                'limit' => 5
            );



            $results = $this->model_customer_customer->getCustomersAutocomplete($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'customer_id' => $result['customer_id'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_card' => $result['customer_card'],
                    'customer_group_id' => $result['customer_group_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'customer_group' => $result['customer_group'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    'gender' => $result['gender'],
                    'email' => $result['email'],
                    'telephone' => $result['telephone'],
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home'],
                    'fax' => $result['fax'],
                    'custom_field' => unserialize($result['custom_field']),
                    'address_id' => $result['address_id'],
                    'address' => $this->model_customer_customer->getAddresses($result['customer_id'])
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function customfield() {
        $json = array();

        $this->load->model('customer/custom_field');

        // Customer Group
        if (isset($this->request->get['customer_group_id'])) {
            $customer_group_id = $this->request->get['customer_group_id'];
        } else {
            $customer_group_id = $this->config->get('config_customer_group_id');
        }

        $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $customer_group_id));

        foreach ($custom_fields as $custom_field) {
            $json[] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'required' => empty($custom_field['required']) || $custom_field['required'] == 0 ? false : true
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function address() {
        $json = array();

        if (!empty($this->request->get['address_id'])) {
            $this->load->model('customer/customer');

            $json = $this->model_customer_customer->getAddress($this->request->get['address_id']);
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function country() {
        $json = array();

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);

        if ($country_info) {
            $this->load->model('localisation/zone');

            $json = array(
                'country_id' => $country_info['country_id'],
                'name' => $country_info['name'],
                'iso_code_2' => $country_info['iso_code_2'],
                'iso_code_3' => $country_info['iso_code_3'],
                'address_format' => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone' => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status' => $country_info['status']
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function setPassword() {
        $this->load->model('customer/customer');
        $this->model_customer_customer->setPassword();
    }

    public function getOrderStatusColor($order_status_id) {
        $color = '#000';
        switch ($order_status_id) {
            case '0':
                $color = '#000';
                break;
            case '1':
                $color = '#ff5722';
                break;
            case '2':
                $color = '#03a9f4';
                break;
            case '3':
                $color = '#8d6e63';
                break;
            case '5':
                $color = '#00c853';
                break;
            case '7':
                $color = '#ff1744';
                break;
            case '15':
                $color = '#283593';
                break;
            case '17':
                $color = '#9c27b0';
                break;
            default:
                $color = '#000';
                break;
        }
        return $color;
    }

    public function customerList() {
        $this->load->language('customer/customer');
        $this->load->model('customer/customer');

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = null;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . urlencode(html_entity_decode($this->request->get['filter_customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        $data['customers'] = array();

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_customer_ic' => $filter_name,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_customer_customer->getTotalCustomers($filter_data);

        $results = $this->model_customer_customer->getCustomers($filter_data);

        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['name'],
                'customer_ic' => $result['customer_ic']
            );
        }

        if (!empty($data['customers'])) {
            foreach ($data['customers'] as $index => $customers) {
                $data['customers'][$index]['select_data'] = htmlspecialchars(json_encode($customers));
            }
        }


        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('customer/customer/customerList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['filter_name'] = $filter_name;
        $data['filter_customer_ic'] = $filter_name;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/customer_list', $data));
    }

    public function exportExcel() {
        $this->load->model('customer/customer');
        $this->load->model('localisation/zone');
        $this->load->model('localisation/country');


        $this->load->language('customer/customer');

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_card'])) {
            $filter_card = $this->request->get['filter_card'];
        } else {
            $filter_card = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = null;
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        // if (isset($this->request->get['filter_approved'])) {
        //     $filter_approved = $this->request->get['filter_approved'];
        // } else {
        //     $filter_approved = null;
        // }


        if (isset($this->request->get['filter_customer_group_id'])) {
            $filter_customer_group_id = $this->request->get['filter_customer_group_id'];
        } else {
            $filter_customer_group_id = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'c.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_card' => $filter_card,
            'filter_ic' => $filter_ic,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_status' => $filter_status,
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_customer_group_id' => $filter_customer_group_id,
            'filter_customer_group'    => $filter_customer_group,
            'filter_gender' => $filter_gender,
        );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setTitle('Title')
            ->setSubject('Subject')
            ->setDescription('Description')
            ->setKeywords('report etcm.me')
            ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri')
            ->setSize(11);

        $table_collection = array();
        $results = $this->model_customer_customer->getCustomers($filter_data);



        if (!empty($results)) {
            foreach ($results as $result) {

                if ($result['gender'] == '1') {
                    $gen = $this->language->get('text_male');
                } elseif ($result['gender'] == '2') {
                    $gen = $this->language->get('text_female');
                } else {
                    $gen = '';
                }

                if ($result['marital_status'] == '1') {
                    $marital = $this->language->get('text_single');
                } elseif ($result['marital_status'] == '2') {
                    $marital = $this->language->get('text_married');
                } else {
                    $marital = '';
                }

                if ($result['religion'] == "1") {
                    $religion = $this->language->get('text_islam');
                } elseif ($result['religion'] == "2") {
                    $religion = $this->language->get('text_buddhism');
                } elseif ($result['religion'] == "3") {
                    $religion = $this->language->get('text_hinduism');
                } else {
                    $religion = $this->language->get('text_christian');
                }

                if ($result['race'] == "1") {
                    $race = $this->language->get('text_malay');
                } elseif ($result['race'] == "2") {
                    $race = $this->language->get('text_chinese');
                } elseif ($result['race'] == "3") {
                    $race = $this->language->get('text_indian');
                } elseif ($result['race'] == "4") {
                    $race = $this->language->get('text_race_indigenous_ethic_group');
                } else {
                    $race = $this->language->get('text_race_foreigner');
                }

                $address_id = $result['address_id'];

                if ($address_id > 0) {
                    $address_info = $this->model_customer_customer->getAddress($address_id);

                    $address_1 = !empty($address_info) ? $address_info['address_1'] : '';
                    $address_2 = !empty($address_info) ? $address_info['address_2'] : '';
                    $address_3 = !empty($address_info) ? $address_info['address_3'] : '';
                    $city = !empty($address_info) ? $address_info['city'] : '';
                    $postcode = !empty($address_info) ? $address_info['postcode'] : '';

                    $zone_id = !empty($address_info) ? $address_info['zone_id'] : 0;
                    $country_id = !empty($address_info) ? $address_info['country_id'] : 0;

                    $zone_info = ($zone_id > 0) ? $this->model_localisation_zone->getZone($zone_id) : [];
                    $zone_name = !empty($zone_info) ? $zone_info['name'] : '';

                    $country_info = ($country_id > 0) ? $this->model_localisation_country->getCountry($country_id) : [];
                    $country_name = !empty($country_info) ? $country_info['name'] : '';
                } else {
                    $address_1 = '';
                    $address_2 = '';
                    $address_3 = '';
                    $city = '';
                    $postcode = '';
                    $zone_name = '';
                    $country_name = '';
                }

                $this->load->model('setting/store');
                $data['stores'] = array();

                $sname = $this->config->get('config_name');

                $data['stores'][] = array(
                    'store_id' => 0,
                    'name' => $sname
                );

                $stores = $this->model_setting_store->getStores();

                foreach ($stores as $store) {
                    $data['stores'][] = array(
                        'store_id' => $store['store_id'],
                        'name' => $store['name']
                    );
                }

                $table_collection[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    // 'Age'=> $this->calculateAge($result['dob']),
                    'gender' => $gen,
                    'dob' => $result['dob'],
                    'customer_ic' => $result['customer_ic'],
                    'telephone' => $result['telephone'],
                    'email' => $result['email'],
                    'customer_card' => $result['customer_card'],
                    // 'customer_group' => $result['customer_group'],
                    // 'store_name' => $sname,
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home'],
                    'nationality' => $result['nationality'],
                    'marital_status' => $marital,
                    'relgion' => $religion,
                    'race' => $race,
                    'allergic' => $result['allergic'],
                    'diagnostic_history' => $result['diagnostic_history'],
                    'occupation' => $result['occupation'],
                    'address_id' => $result['address_id'],
                    'address_1' => $address_1,
                    'address_2' => $address_2,
                    'address_3' => $address_3,
                    'city'      => $city,
                    'postcode' => $postcode,
                    'zone_name' => $zone_name,
                    'country_name' => $country_name,
                    // 'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    // 'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'))
                ];
            }
        }

        $table = array();
        // $table[] = array('Customer List', $this->language->get('heading_title'));
        // $table[] = array();
        $table_header = array(
            'Customer ID',
            'FirstName',
            'LastName',
            'Gender',
            'DOB',
            'Customer IC',
            'Contact Number',
            'E-mail',
            'Member No',
            // 'Member Group',
            // 'Store',
            'Contact Number 2',
            'Contact Number(Home)',
            'Nationality',
            'Marital Status',
            'Religion',
            'Race',
            'Allergic',
            'Diagnostic History',
            'Occupation',
            'Address ID',
            'Address 1',
            'Address 2',
            'Address 3',
            'City',
            'Postcode',
            'State',
            'Country',
            // 'Date Added',
            // 'Status'
        );
        $table[] = $table_header;
        $total_row = 0;
        $table_data = $table_collection;
        $row;
        foreach ($table_data as $key => $data) {
            $row = array();

            foreach ($data as $key => $value) {
                $row[] = $value;
            }
            $table[] = $row;

            $total_row++;
        }

        // Styling
        $autosize_column_index = 'A';
        foreach ($table_header as $header) {
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach ($table_header as $col) {
            $header_index_e_column++;
        }
        $header_index_row = 3;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font' => array(
                'bold' => false
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $general_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            // 'numberformat' => array(
            //     'code' => '00'
            // )
        );

        $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('G1:G' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('G1:G' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);


        $objPHPExcel->getActiveSheet()
            ->getStyle('H1:H' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('H1:H' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);



        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('J1:J' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('J1:J' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('K1:K' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1:K' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('L1:L' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1:L' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('M1:M' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('M1:M' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('N1:N' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('N1:N' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('O1:O' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('O1:O' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);


        $objPHPExcel->getActiveSheet()
            ->getStyle('P1:P' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('P1:P' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('Q1:Q' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Q1:Q' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);


        $objPHPExcel->getActiveSheet()
            ->getStyle('R1:R' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('R1:R' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('S1:S' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('S1:S' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('T1:T' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('T1:T' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('U1:U' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('U1:U' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('V1:V' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('V1:V' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('W1:W' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('W1:W' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('X1:X' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('X1:X' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('Y1:Y' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Y1:Y' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('Z1:Z' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('Z1:Z' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);



        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:Z' . $lastrow)
            ->getAlignment()
            ->setWrapText(true);

        /* $objPHPExcel->getActiveSheet()
          ->getStyle('A1:I'.$lastrow)
          ->getAlignment()
          ->setWrapText(true); */
        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = 'Customer List';

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }

    public function exportCustomer() {
        $this->load->model('customer/customer');
        $this->load->model('localisation/zone');
        $this->load->model('localisation/country');


        $this->load->language('customer/customer');

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_card'])) {
            $filter_card = $this->request->get['filter_card'];
        } else {
            $filter_card = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = null;
        }

        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        // if (isset($this->request->get['filter_approved'])) {
        //     $filter_approved = $this->request->get['filter_approved'];
        // } else {
        //     $filter_approved = null;
        // }


        if (isset($this->request->get['filter_customer_group_id'])) {
            $filter_customer_group_id = $this->request->get['filter_customer_group_id'];
        } else {
            $filter_customer_group_id = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'c.date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_card' => $filter_card,
            'filter_ic' => $filter_ic,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_status' => $filter_status,
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_customer_group_id' => $filter_customer_group_id,
            'filter_customer_group'    => $filter_customer_group,
            'filter_gender' => $filter_gender,
        );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);


        $table_collection = array();
        $results = $this->model_customer_customer->getCustomers($filter_data);



        if (!empty($results)) {
            foreach ($results as $result) {

                if ($result['gender'] == '1') {
                    $gen = $this->language->get('text_male');
                } elseif ($result['gender'] == '2') {
                    $gen = $this->language->get('text_female');
                } else {
                    $gen = '';
                }

                if ($result['marital_status'] == '1') {
                    $marital = $this->language->get('text_single');
                } elseif ($result['marital_status'] == '2') {
                    $marital = $this->language->get('text_married');
                } else {
                    $marital = '';
                }

                if ($result['religion'] == "1") {
                    $religion = $this->language->get('text_islam');
                } elseif ($result['religion'] == "2") {
                    $religion = $this->language->get('text_buddhism');
                } elseif ($result['religion'] == "3") {
                    $religion = $this->language->get('text_hinduism');
                } else {
                    $religion = $this->language->get('text_christian');
                }

                if ($result['race'] == "1") {
                    $race = $this->language->get('text_malay');
                } elseif ($result['race'] == "2") {
                    $race = $this->language->get('text_chinese');
                } elseif ($result['race'] == "3") {
                    $race = $this->language->get('text_indian');
                } elseif ($result['race'] == "4") {
                    $race = $this->language->get('text_race_indigenous_ethic_group');
                } else {
                    $race = $this->language->get('text_race_foreigner');
                }

                $address_id = $result['address_id'];

                if ($address_id > 0) {
                    $address_info = $this->model_customer_customer->getAddress($address_id);

                    $address_1 = !empty($address_info) ? $address_info['address_1'] : '';
                    $address_2 = !empty($address_info) ? $address_info['address_2'] : '';
                    $address_3 = !empty($address_info) ? $address_info['address_3'] : '';
                    $city = !empty($address_info) ? $address_info['city'] : '';
                    $postcode = !empty($address_info) ? $address_info['postcode'] : '';

                    $zone_id = !empty($address_info) ? $address_info['zone_id'] : 0;
                    $country_id = !empty($address_info) ? $address_info['country_id'] : 0;

                    $zone_info = ($zone_id > 0) ? $this->model_localisation_zone->getZone($zone_id) : [];
                    $zone_name = !empty($zone_info) ? $zone_info['name'] : '';

                    $country_info = ($country_id > 0) ? $this->model_localisation_country->getCountry($country_id) : [];
                    $country_name = !empty($country_info) ? $country_info['name'] : '';
                } else {
                    $address_1 = '';
                    $address_2 = '';
                    $address_3 = '';
                    $city = '';
                    $postcode = '';
                    $zone_name = '';
                    $country_name = '';
                }

                $this->load->model('setting/store');
                $data['stores'] = array();

                $sname = $this->config->get('config_name');

                $data['stores'][] = array(
                    'store_id' => 0,
                    'name' => $sname
                );

                $stores = $this->model_setting_store->getStores();

                foreach ($stores as $store) {
                    $data['stores'][] = array(
                        'store_id' => $store['store_id'],
                        'name' => $store['name']
                    );
                }

                $table_collection[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    // 'Age'=> $this->calculateAge($result['dob']),
                    'gender' => $gen,
                    'dob' => $result['dob'],
                    'customer_ic' => $result['customer_ic'],
                    'telephone' => $result['telephone'],
                    'email' => $result['email'],
                    'customer_card' => $result['customer_card'],
                    // 'customer_group' => $result['customer_group'],
                    // 'store_name' => $sname,
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home'],
                    'nationality' => $result['nationality'],
                    'marital_status' => $marital,
                    'relgion' => $religion,
                    'race' => $race,
                    'allergic' => $result['allergic'],
                    'diagnostic_history' => $result['diagnostic_history'],
                    'occupation' => $result['occupation'],
                    'address_id' => $result['address_id'],
                    'address_1' => $address_1,
                    'address_2' => $address_2,
                    'address_3' => $address_3,
                    'city'      => $city,
                    'postcode' => $postcode,
                    'zone_name' => $zone_name,
                    'country_name' => $country_name,
                    // 'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    // 'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'))
                ];
            }
        }


        $table_header = array(
            'Customer ID',
            'FirstName',
            'LastName',
            'Gender',
            'DOB',
            'Customer IC',
            'Contact Number',
            'E-mail',
            'Member No',
            // 'Member Group',
            // 'Store',
            'Contact Number 2',
            'Contact Number(Home)',
            'Nationality',
            'Marital Status',
            'Religion',
            'Race',
            'Allergic',
            'Diagnostic History',
            'Occupation',
            'Address ID',
            'Address 1',
            'Address 2',
            'Address 3',
            'City',
            'Postcode',
            'State',
            'Country',
            // 'Date Added',
            // 'Status'
        );

        $csv_data = array();
        $csv_data[] = $table_header;

        $table_data = $table_collection;

        foreach ($table_data as $data) {
            $row = array();
            foreach ($data as $value) {
                $row[] = $value;
            }
            $csv_data[] = $row;
        }

        $filename = 'customer_data.csv';

        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=' . $filename);

        $output = fopen('php://output', 'w');
        foreach ($csv_data as $row) {
            fputcsv($output, $row);
        }
        fclose($output);
    }

    public function getImportExcelForm() {

        $this->load->model('customer/customer');
        $this->load->language('customer/customer');
        $this->load->model('setting/store');
        $this->load->model('localisation/country');

        $this->document->setTitle($this->language->get('heading_title'));

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['cancel'] = $this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['sample_excel'] = HTTPS_SERVER . 'sample/sample_customer_import_excel.xlsx';

        $data['error_text_warning'] = $this->language->get('error_warning');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateFormImport()) {
            if (isset($this->request->post['customers'])) {
                $store_id = $this->session->data['store_id'];
                $store_info = $this->model_setting_store->getStore($store_id);

                foreach ($this->request->post['customers'] as $customer) {
                    $address = [];

                    $customer_json = base64_decode($customer);
                    $customer_arr = json_decode($customer_json, true);

                    $customer_info = $this->model_customer_customer->get_customer_by_id($customer_arr['customer_id']);

                    if (empty($customer_info)) {
                        if (!empty($customer_arr['customer_address'])) {
                            $address[] = [
                                'firstname' => $customer_arr['firstname'],
                                'lastname' => !empty($customer_arr['lastname']) ? $customer_arr['lastname'] : '',
                                'company' => '',
                                'address_1' => $customer_arr['customer_address']['address_1'],
                                'address_2' => '',
                                'address_3' => '',
                                'city' => $customer_arr['customer_address']['city'],
                                'postcode' => $customer_arr['customer_address']['postcode'],
                                'zone_id' => $customer_arr['customer_address']['zone_id'],
                                'country_id' => $customer_arr['customer_address']['country_id'],
                                'default' => 1
                            ];
                        } else {
                            $address = [];
                        }

                        $insert_customer_data = [
                            'customer_id' => $customer_arr['customer_id'],
                            'firstname' => $customer_arr['firstname'],
                            'lastname' => !empty($customer_arr['lastname']) ? $customer_arr['lastname'] : '',
                            'customer_ic' => $customer_arr['customer_ic'],
                            'customer_card' => '',
                            'dob' => date("Y-m-d", strtotime($customer_arr['dob'])),
                            'gender' => $customer_arr['gender'],
                            'customer_group_id' => '1',
                            'email' => !empty($customer_arr['email']) ? $customer_arr['email'] : '',
                            'telephone' => !empty($customer_arr['telephone']) ? $customer_arr['telephone'] : '',
                            'customer_card' => !empty($customer_arr['customer_card']) ? $customer_arr['customer_card'] : '',
                            'telephone2' => !empty($customer_arr['telephone2']) ? $customer_arr['telephone2'] : '',
                            'home' => !empty($customer_arr['home']) ? $customer_arr['home'] : '',
                            'nationality' => !empty($customer_arr['nationality']) ? $customer_arr['nationality'] : '',
                            'marital_status' => !empty($customer_arr['marital_status']) ? $customer_arr['marital_status'] : '',
                            'religion' => !empty($customer_arr['religion']) ? $customer_arr['religion'] : '',
                            'race' => !empty($customer_arr['race']) ? $customer_arr['race'] : '',
                            'allergic' => !empty($customer_arr['allergic']) ? $customer_arr['allergic'] : '',
                            'diagnostic_history' => !empty($customer_arr['diagnostic_history']) ? $customer_arr['diagnostic_history'] : '',
                            'occupation' => !empty($customer_arr['occupation']) ? $customer_arr['occupation'] : '',
                            'address_id' => !empty($customer_arr['address_id']) ? $customer_arr['address_id'] : '',
                            'fax' => '',
                            'newsletter' => '0',
                            'status' => '1',
                            'password' => '',
                            'approved' => '1',
                            'safe' => '1'
                        ];

                        if (!empty($address)) {
                            $insert_customer_data['address'] = $address;
                        }

                        $this->model_customer_customer->addCustomerByImport($insert_customer_data);
                    } else {

                        $customer_id = $customer_info['customer_id'];

                        if (!empty($customer_arr['customer_address'])) {
                            $address[] = [
                                'address_id' => $customer_arr['address_id'],
                                'firstname' => $customer_arr['firstname'],
                                'lastname' => !empty($customer_arr['lastname']) ? $customer_arr['lastname'] : '',
                                'company' => '',
                                'address_1' => $customer_arr['customer_address']['address_1'],
                                'address_2' => '',
                                'address_3' => '',
                                'city' => $customer_arr['customer_address']['city'],
                                'postcode' => $customer_arr['customer_address']['postcode'],
                                'zone_id' => $customer_arr['customer_address']['zone_id'],
                                'country_id' => $customer_arr['customer_address']['country_id'],
                                'default' => 1
                            ];
                        } else {
                            $address = [];
                        }

                        $insert_customer_data2 = [
                            'firstname' => $customer_arr['firstname'],
                            'lastname' => !empty($customer_arr['lastname']) ? $customer_arr['lastname'] : '',
                            'customer_ic' => $customer_arr['customer_ic'],
                            'customer_card' => '',
                            'dob' => date("Y-m-d", strtotime($customer_arr['dob'])),
                            'gender' => $customer_arr['gender'],
                            'customer_group_id' => '1',
                            'email' => !empty($customer_arr['email']) ? $customer_arr['email'] : '',
                            'telephone' => !empty($customer_arr['telephone']) ? $customer_arr['telephone'] : '',
                            'customer_card' => !empty($customer_arr['customer_card']) ? $customer_arr['customer_card'] : '',
                            'telephone2' => !empty($customer_arr['telephone2']) ? $customer_arr['telephone2'] : '',
                            'home' => !empty($customer_arr['home']) ? $customer_arr['home'] : '',
                            'nationality' => !empty($customer_arr['nationality']) ? $customer_arr['nationality'] : '',
                            'marital_status' => !empty($customer_arr['marital_status']) ? $customer_arr['marital_status'] : '',
                            'religion' => !empty($customer_arr['religion']) ? $customer_arr['religion'] : '',
                            'race' => !empty($customer_arr['race']) ? $customer_arr['race'] : '',
                            'allergic' => !empty($customer_arr['allergic']) ? $customer_arr['allergic'] : '',
                            'diagnostic_history' => !empty($customer_arr['diagnostic_history']) ? $customer_arr['diagnostic_history'] : '',
                            'occupation' => !empty($customer_arr['occupation']) ? $customer_arr['occupation'] : '',
                            'address_id' => !empty($customer_arr['address_id']) ? $customer_arr['address_id'] : '',
                            'fax' => '',
                            'newsletter' => '0',
                            'status' => '1',
                            'password' => '',
                            'approved' => '1',
                            'safe' => '1'
                        ];

                        if (!empty($address)) {
                            $insert_customer_data2['address'] = $address;
                        }

                        $this->model_customer_customer->updateImportedCustomer($insert_customer_data2, $customer_id);
                    }
                }
                // var_dump($this->request->post['customers']);
                // die();
                $this->session->data['success'] = $this->language->get('text_success');
            }


            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['action'] = $this->url->link('customer/customer/getImportExcelForm', 'user_token=' . $this->session->data['user_token'], true);
        $data['import_excel_action'] = $this->url->link('customer/customer/ImportExcel', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');



        $this->response->setOutput($this->load->view('customer/import_excel_customer_form', $data));
    }



    public function ImportExcel() {
        $json = [];

        $this->load->model('customer/customer');
        $this->load->model('localisation/country');

        $excel_filename = $this->request->files['excel_file']['name'];

        $ext = pathinfo($excel_filename, PATHINFO_EXTENSION);

        if (strtolower($ext) != 'xlsx') {
            $json = [
                'success' => false
            ];
        } else {
            $this->load->library('PHPExcel');
            $this->excel = new PHPExcel();

            $obj_reader = PHPExcel_IOFactory::createReader('Excel2007');
            $obj_php_excel = $obj_reader->load($this->request->files['excel_file']['tmp_name']);

            $sheet = $obj_php_excel->getActiveSheet();
            $highest_row = $sheet->getHighestRow();
            $highest_column = $sheet->getHighestColumn();

            $sheets = [];

            for ($row = 1; $row <= $highest_row; $row++) {
                $sheets[$row] = $sheet->rangeToArray('A' . $row . ':' . $highest_column . $highest_row, null, true, false)[0];
            }

            $customer_imported = [];

            $headers = array_shift($sheets);
            $header = array_filter($headers);

            foreach ($sheets as $d => $dt) {
                if (is_array($dt)) {
                    $customer_imported[$d] = [];
                    foreach ($dt as $rd => $row) {
                        if (in_array($rd, array_keys($header))) {
                            $customer_imported[$d][$header[$rd]] = $row;
                        }
                    }
                }
            }

            if (!empty($customer_imported)) {
                foreach ($customer_imported as $customer) {
                    $got_customer_id = array_key_exists('Customer ID', $customer) ? true : false;
                    $got_customer_ic = array_key_exists('Customer IC', $customer) ? true : false;
                    $got_firstname = array_key_exists('FirstName', $customer) ? true : false;
                    $got_lastname = array_key_exists('LastName', $customer) ? true : false;
                    $got_email = array_key_exists('E-Mail', $customer) ? true : false;
                    $got_telephone = array_key_exists('Contact Number', $customer) ? true : false;
                    $got_address_1 = array_key_exists('Address 1', $customer) ? true : false;
                    $got_city = array_key_exists('City', $customer) ? true : false;
                    $got_postcode = array_key_exists('Postcode', $customer) ? true : false;
                    $got_state = array_key_exists('State', $customer) ? true : false;

                    if ($got_customer_id && $got_customer_ic && $got_firstname && $got_lastname && $got_email && $got_telephone && $got_address_1 && $got_city && $got_postcode && $got_state) {
                        $customer_id = $customer['Customer ID'];

                        $customer_info = $this->model_customer_customer->get_customer_by_id($customer_id);

                        $db_customer_id = !empty($customer_info) ? $customer_info['customer_id'] : '';

                        $customer_url = !empty($customer_info) ? $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $customer_info['customer_id'], true) : '';

                        $zone_name = $customer['State'];
                        $zone_info = $this->model_customer_customer->get_zone_by_name($zone_name);

                        $country_info = !empty($zone_info) ? $this->model_localisation_country->getCountry($zone_info['country_id']) : [];


                        $gender_info = $customer['Gender'];
                        if ($gender_info == 'Male') {
                            $gen = '1';
                        } elseif ($gender_info == 'Female') {
                            $gen = '2';
                        } else {
                            $gen = '';
                        }

                        $marital_info = $customer['Marital Status'];
                        if ($marital_info == 'Unmarried') {
                            $marital = '1';
                        } elseif ($marital_info == 'Married') {
                            $marital = '2';
                        } else {
                            $marital = '';
                        }

                        $religion_info = $customer['Religion'];
                        if ($religion_info == 'Islam') {
                            $religion = '1';
                        } elseif ($religion_info == 'Buddhism') {
                            $religion = '2';
                        } elseif ($religion_info == 'Hinduism') {
                            $religion = '3';
                        } elseif ($religion_info == 'Christian') {
                            $religion = '4';
                        } else {
                            $religion = '';
                        }

                        $race_info = $customer['Race'];
                        if ($race_info == 'Malay') {
                            $race = '1';
                        } elseif ($race_info == 'Chinese') {
                            $race = '2';
                        } elseif ($race_info == 'Indian') {
                            $race = '3';
                        } elseif ($race_info == 'Indigenous Ethic Group') {
                            $race = '4';
                        } elseif ($race_info == 'Foreigner') {
                            $race = '5';
                        } else {
                            $race = '';
                        }

                        $address = [
                            'address_1' => ucwords(strtolower($customer['Address 1'])),
                            'postcode' => $customer['Postcode'],
                            'city' => ucwords(strtolower($customer['City'])),
                            'zone_id' => !empty($zone_info) ? $zone_info['zone_id'] : 0,
                            'zone_name' => !empty($zone_info) ? $zone_info['name'] : '',
                            'country_id' => !empty($zone_info) ? $zone_info['country_id'] : 0,
                            'country_name' => !empty($country_info) ? $country_info['name'] : ''
                        ];

                        $return_customer[] = [
                            'customer_id' => $customer['Customer ID'],
                            'customer_ic' => $customer['Customer IC'],
                            'db_customer_id' => $db_customer_id,
                            'firstname' => $customer['FirstName'],
                            'lastname' => $customer['LastName'],
                            'email' => !empty($customer['E-Mail']) ? $customer['E-Mail'] : '-',
                            'telephone' => $customer['Contact Number'],
                            'dob' => date("Y-m-d", strtotime($customer['DOB'])),
                            'customer_card' => $customer['Member No'],
                            'telephone2' => $customer['Contact Number 2'],
                            'home' => $customer['Contact Number(Home)'],
                            'nationality' => $customer['Nationality'],
                            'marital_status' => $marital,
                            'religion' => $religion,
                            'race' => $race,
                            'gender' =>   $gen,
                            'allergic' => $customer['Allergic'],
                            'diagnostic_history' => $customer['Diagnostic History'],
                            'occupation' => $customer['Occupation'],
                            'address_id' => $customer['Address ID'],
                            'customer_address' => !empty($address['address_1']) ? $address : [],
                            'customer_url' => $customer_url,
                        ];
                    }
                }
            }

            if (!empty($return_customer)) {
                $customer_ic_column = array_column($return_customer, 'customer_ic');
                $customer_ic_column = array_map('strtotime', $customer_ic_column);

                array_multisort($return_customer, SORT_NUMERIC, $return_customer, SORT_ASC);

                foreach ($return_customer as $customer) {
                    $full_return_customer[] = [
                        'data' => $customer,
                        'encrypted_data' => base64_encode(json_encode($customer))
                    ];
                }

                $json = array(
                    'success' => true,
                    'total_customer' => count($full_return_customer),
                    'respond' => $full_return_customer
                );
            } else {
                $json = [
                    'success' => false
                ];
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validateFormImport() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['customers'])) {
            $this->error['warning'] = $this->language->get('error_import_transaction');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    private function calculateAge($dob) {
        $date_of_birth = date('m/d/Y', strtotime($dob));

        $birthDate = explode("/", $date_of_birth);

        $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

        return $age;
    }

    private function getCurrentDate() {
        date_default_timezone_set('Asia/Kuala_Lumpur');
        $date = date('d-m-y h:i:s');
        return $date;
    }


    public function addMedicalRecord() {
        $this->document->addStyle('view/stylesheet/new_herbal_add.css?v=' . time());

        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('herbal/new_herbal');
        $this->load->model('user/user');
        $this->load->model('customer/customer');

        $user_id = $this->session->data['user_id'];
        $user_position = !empty($this->getUserPosition($user_id)) ? $this->getUserPosition($user_id) : 1;

        //Check if Get the customer_id from the GET request url 
        if (!empty($this->request->get['customer_id'])) {
            $customer_info = $this->model_herbal_new_herbal->getCustomerbyid($this->request->get['customer_id']);
            $data['customer_id'] = $customer_info['customer_id'];

            // $data['doctor_id'] = !empty($this->config->get('config_doctor_id')) ? $this->config->get('config_doctor_id') : 138;

            $data['doctor_id'] = !empty($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : (!empty($this->config->get('config_doctor_id')) ? $this->config->get('config_doctor_id') : 138);

            $doctor_info = $this->model_user_user->getUser($data['doctor_id']);

            $data['enable_consultation_price'] = $doctor_info['enable_consultation_price'];
            $data['consultationprice'] = $doctor_info['consultationprice'];

            $checkLastestMedicalRecord = $this->getLatestHerbalByCustomerId($data['customer_id']);
            //This function to avoid duplication of same customer have create two medical record
            if (!empty($checkLastestMedicalRecord)) {
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $passed_time = $checkLastestMedicalRecord;
                $current_time = date('Y-m-d H:i:s');

                $date_added = strtotime($passed_time);
                $date_now = strtotime($current_time);
                $diff = $date_now - $date_added;

                //Check the latest add new medical record time not less than 10 seconds
                //If less then 10 seconds redirect medical record list page
                //Else then add new medical record
                //This checking is to avoid duplication of add new medical record 
                if ($diff < 10) {
                    $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
                } else {
                    //Add new medical record
                    $herbal_id = $this->model_customer_customer->addHerbal($data);
                }
            } else {
                // Add new medical record
                $herbal_id = $this->model_customer_customer->addHerbal($data);
            }

            $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
            $invoice_prefix = $herbal_info['invoice_prefix'];
            $customer_name = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
            $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);
            //Check if not empty the doctor, will send notification to the doctor

            if ($data['doctor_id'] != 0  && $herbal_id > 0) {
                $notification_template = $this->config->get('config_gcm_new_herbal');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    // $customer_data = $this->model_herbal_new_herbal->getHerbal($data['customer_id']);
                    $customer_name = $herbal_info['firstname'] . ' ' . $herbal_info['lastname'];

                    $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
                    $invoice_prefix = $herbal_info['invoice_prefix'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_name
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $data['doctor_id'],
                        'type' => 2      // New herbal remedies type
                    );

                    $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($data['doctor_id']))
                            ->setData($data_gcm)
                            ->send();
                    }
                }
            }


            $url = '';
            if (isset($herbal_id) && $herbal_id != 0) {
                $this->session->data['success'] = $this->language->get('text_success');
                $url .= '&herbal_id=' . $herbal_id;
            }

            //Check if role as doctor will auto redirect to medical record edit page else then redirect back to medical record list page
            if ($user_position == 1) {
                $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true));
            } else {
                $this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $customer_ic = !empty($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : '';
            $telephone = !empty($this->request->post['telephone']) ? $this->request->post['telephone'] : '';

            if (!empty($customer_ic)) {
                $customer_info = $this->model_herbal_new_herbal->customerExistsByIc($this->request->post['customer_ic']);
            }

            if (!empty($telephone)) {
                if (empty($customer_info)) {
                    $customer_info = $this->model_herbal_new_herbal->customerExistsByTelephone($this->request->post['telephone']);
                }
            }

            // Check if is new customer then add customer to database
            // Else check the existing customer have duplication add medical record frequently
            if (empty($customer_info)) {
                $data['customer_id'] = $this->model_herbal_new_herbal->addCustomer($this->request->post);
            } else {
                $data['customer_id'] = $customer_info['customer_id'];
                $checkLastestMedicalRecord = $this->getLatestHerbalByCustomerId($data['customer_id']);
                if (!empty($this->$checkLastestMedicalRecord)) {
                    date_default_timezone_set("Asia/Kuala_Lumpur");
                    $passed_time = $this->$checkLastestMedicalRecord;
                    $current_time = date('Y-m-d H:i:s');

                    $date_added = strtotime($passed_time);
                    $date_now = strtotime($current_time);
                    $diff = $date_now - $date_added;

                    if ($diff < 10) {
                        $this->response->redirect($this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'], true));
                    }
                }
            }

            $data['doctor_id'] = $this->request->post['doctor_id'];
            $doctor_info = $this->model_user_user->getUser($data['doctor_id']);

            $data['enable_consultation_price'] = $doctor_info['enable_consultation_price'];
            $data['consultationprice'] = $doctor_info['consultationprice'];

            $herbal_id = $this->model_customer_customer->addHerbal($data);

            if ($data['doctor_id'] != 0) {
                $notification_template = $this->config->get('config_gcm_new_herbal');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $customer_data = $this->model_customer_customer->getCustomer($data['customer_id']);
                    $customer_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

                    $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
                    $invoice_prefix = $herbal_info['invoice_prefix'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_name
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $data['doctor_id'],
                        'type' => 2      // New herbal remedies type
                    );

                    $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($data['doctor_id']))
                            ->setData($data_gcm)
                            ->send();
                    }
                }
            }

            $notification = new Notification($this->registry);
            $notification_data = [
                'herbal_id' => $herbal_id,
                'invoice_prefix' => $invoice_prefix,
                'customer_name' => $customer_name
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('new_clinical_sale_notification', $notification_data);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_transaction_from'])) {
                $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
            }

            if (isset($this->request->get['filter_transaction_to'])) {
                $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_firstname'])) {
                $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
            }


            if (isset($this->request->get['filter_payment_status'])) {
                $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($herbal_id) && $herbal_id != 0) {
                $url .= '&herbal_id=' . $herbal_id;
            }

            if ($user_position == 1) {
                $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
            } else {
                $this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
            }
            //$this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
        }

        $this->customer();
    }

    public function customer() {
        //Get the lastest medical number from transaction number module
        //$text_invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        //Get latest customer card number from transaction number module
        //$placeholder_customer_card = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        //Get the latest invoice prefix number
        $data['new_customer_form_javascript_link'] = 'view/javascript/herbal/new_customer_form.js?v=' . time();

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }


        $data['placeholder_customer_card'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $store_id));
        $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/new_herbal', 'store' => $store_id));
        $data['doctors'] = $this->model_user_user->getUserByPostion(2);

        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['user_token'] = $this->session->data['user_token'];

        $this->load->model('localisation/country');
        $data['countries'] = $this->model_localisation_country->getCountries();

        $this->load->model('customer/customer_group');
        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        //Set default nationality, marital status, race, religion
        $data['nationality'] = 'MALAYSIANS';
        $data['marital_status'] = 1;
        $data['religion_id'] = 2;
        $data['race_id'] = 2;
        //Build Races Data 
        $data['races'][] = array(
            'race_id' => 1,
            'name' => $this->language->get('text_malay'),
        );
        $data['races'][] = array(
            'race_id' => 2,
            'name' => $this->language->get('text_chinese'),
        );
        $data['races'][] = array(
            'race_id' => 3,
            'name' => $this->language->get('text_indian'),
        );
        $data['races'][] = array(
            'race_id' => 4,
            'name' => $this->language->get('text_race_indigenous_ethic_group'),
        );
        $data['races'][] = array(
            'race_id' => 5,
            'name' => $this->language->get('text_race_foreigner'),
        );

        //Build Religion Data
        $data['religions'][] = array(
            'religion_id' => 1,
            'name' => $this->language->get('text_islam'),
        );
        $data['religions'][] = array(
            'religion_id' => 2,
            'name' => $this->language->get('text_buddhism'),
        );
        $data['religions'][] = array(
            'religion_id' => 3,
            'name' => $this->language->get('text_hinduism'),
        );
        $data['religions'][] = array(
            'religion_id' => 4,
            'name' => $this->language->get('text_christian'),
        );

        //Set the error message
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_customer_ic'] = isset($this->error['customer_ic']) ? $this->error['customer_ic'] : '';
        $data['error_firstname'] = isset($this->error['firstname']) ? $this->error['firstname'] : '';
        $data['error_lastname'] = isset($this->error['lastname']) ? $this->error['lastname'] : '';
        $data['error_dob'] = isset($this->error['dob']) ? $this->error['dob'] : '';
        $data['error_telephone'] = isset($this->error['telephone']) ? $this->error['telephone'] : '';
        $data['error_password'] = isset($this->error['password']) ? $this->error['password'] : '';
        $data['error_confirm'] = isset($this->error['confirm']) ? $this->error['confirm'] : '';
        $data['error_address'] = isset($this->error['address']) ? $this->error['address'] : '';
        $data['error_doctor'] = isset($this->error['doctor_id']) ? $this->error['doctor_id'] : '';

        //Build the query link
        $url = '';
        isset($this->request->get['filter_date_from']) ? $url .= '&filter_date_from=' . $this->request->get['filter_date_from'] : '';
        isset($this->request->get['filter_date_to']) ? $url .= '&filter_date_to=' . $this->request->get['filter_date_to'] : '';
        isset($this->request->get['filter_transaction_from']) ? $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'] : '';
        isset($this->request->get['filter_transaction_to']) ? $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'] : '';
        isset($this->request->get['filter_customer_ic']) ? $url .= '&filter_customer_ic=' . urlencode(html_entity_decode($this->request->get['filter_customer_ic'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_customer_card']) ? $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_customer_firstname']) ? $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_payment_status']) ? $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'] : '';
        isset($this->request->get['filter_status']) ? $url .= '&filter_status=' . $this->request->get['filter_status'] : '';
        isset($this->request->get['sort']) ? $url .= '&sort=' . $this->request->get['sort'] : '';
        isset($this->request->get['order']) ? $url .= '&order=' . $this->request->get['order'] : '';
        isset($this->request->get['page']) ? $url .= '&page=' . $this->request->get['page'] : '';

        //Build breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        //Set the action link
        $data['action'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['cancel'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);

        //Build Custom Fields Data
        $this->load->model('customer/custom_field');
        $data['custom_fields'] = array();
        $custom_fields = $this->model_customer_custom_field->getCustomFields();
        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        //Set the POST request data
        $data['customer_group_id'] = isset($this->request->post['customer_group_id']) ? $this->request->post['customer_group_id'] : $this->config->get('config_customer_group_id');
        $data['firstname'] = isset($this->request->post['firstname']) ? $this->request->post['firstname'] : '';
        $data['lastname'] = isset($this->request->post['lastname']) ? $this->request->post['lastname'] : '';
        $data['home'] = isset($this->request->post['home']) ? $this->request->post['home'] : '';
        $data['gender'] = isset($this->request->post['gender']) ? $this->request->post['gender'] : 1;
        $data['customer_card'] = isset($this->request->post['customer_card']) ? $this->request->post['customer_card'] : '';
        $data['customer_ic'] = isset($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : '';
        $data['customer_id'] = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : 0;
        $data['dob'] = isset($this->request->post['dob']) ? $this->request->post['dob'] : '';
        $data['email'] = isset($this->request->post['email']) ? $this->request->post['email'] : '';
        $data['telephone'] = isset($this->request->post['telephone']) ? $this->request->post['telephone'] : '';
        $data['telephone2'] = isset($this->request->post['telephone2']) ? $this->request->post['telephone2'] : '';
        $data['occupation'] = isset($this->request->post['occupation']) ? $this->request->post['occupation'] : '';
        $data['nationality'] = isset($this->request->post['nationality']) ? $this->request->post['nationality'] : 'MALAYSIANS';
        $data['allergic'] = isset($this->request->post['allergic']) ? $this->request->post['allergic'] : '';
        $data['diagnostic_history'] = isset($this->request->post['diagnostic_history']) ? $this->request->post['diagnostic_history'] : '';
        $data['fax'] = isset($this->request->post['fax']) ? $this->request->post['fax'] : '';
        $data['doctor_id'] = isset($this->request->post['doctor_id']) ? $this->request->post['doctor_id'] : '';

        // var_dump($this->request->post);
        // die();
        $data['account_custom_field'] = isset($this->request->post['custom_field']) ? $this->request->post['custom_field'] : [];
        $data['newsletter'] = isset($this->request->post['newsletter']) ? $this->request->post['newsletter'] : '';
        $data['status'] = isset($this->request->post['status']) ? $this->request->post['status'] : true;
        $data['approved'] = isset($this->request->post['approved']) ? $this->request->post['approved'] : true;
        $data['safe'] = isset($this->request->post['safe']) ? $this->request->post['safe'] : 0;
        $data['password'] = isset($this->request->post['password']) ? $this->request->post['password'] : '';
        $data['confirm'] = isset($this->request->post['confirm']) ? $this->request->post['confirm'] : '';
        $data['addresses'] = isset($this->request->post['address']) ? $this->request->post['address'] : [];
        $data['address_id'] = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : 0;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/new_customer_form', $data));
    }

    public function getUserPosition($user_id) {
        $query = $this->db->query("
			SELECT
					position
				FROM `oc_user`
				WHERE 1
					AND user_id = '" . (int) $user_id . "'
		");
        return !empty($query->row['position']) ? $query->row['position'] : 1;
    }

    public function getLatestHerbalByCustomerId($customer_id) {
        $query = $this->db->query(" 
            SELECT 
                    date_added
                FROM `oc_clinical_sale`
                WHERE 1
                    AND customer_id = '" . (int) $customer_id . "'
                ORDER BY date_added DESC
                LIMIT 1
        ");
        return !empty($query->row['date_added']) ? $query->row['date_added'] : '';
    }


    public function addServiceCustomer() {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');
        $this->load->model('service/service_form');



        $customer_id = isset($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;

        $data['customer_id'] = $customer_id ? $this->request->get['customer_id'] : 0;

        if (isset($this->request->get['customer_id'])) {
            $customer = $this->model_service_service_form->getCustomerbyid($this->request->get['customer_id']);
            if (!empty($customer)) {
                $data['customer_id'] = $customer['customer_id'];
                $data['email'] = $customer['email'];
                $data['telephone'] = $customer['telephone'];

                // echo'<pre>';
                // print_r($customer);
                // echo'</pre>';

                $serviceform_id = $this->model_service_service_form->addServiceForm($data);

                $this->session->data['success'] = $this->language->get('text_success');

                if ($serviceform_id > 0) {
                    $this->response->redirect($this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id . '&admin_add=1', true));
                } else {
                    $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true));
                }
            }
        }


        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerForm()) {
            $customer_info = $this->model_service_service_form->customerExistsByIc($this->request->post['customer_ic']);

            if (count($customer_info) == 0) {
                $customer_info['customer_id'] = $this->model_service_service_form->addCustomer($this->request->post);
            }

            $data['customer_id'] = $customer_info['customer_id'];

            $serviceform_id = $this->model_service_service_form->addServiceForm($data);

            $customer_row = $this->model_service_service_form->getCustomer($data['customer_id']);
            $customer_name = !empty($customer_row) ? $customer_row['firstname'] . ' ' . $customer_row['lastname'] : '';

            $serviceform_row = $this->model_service_service_form->getServiceForm($serviceform_id);
            $invoice_prefix = !empty($serviceform_row) ? $serviceform_row['info']['invoice_prefix'] : '';

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_transaction_from'])) {
                $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
            }

            if (isset($this->request->get['filter_transaction_to'])) {
                $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_firstname'])) {
                $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_payment_status'])) {
                $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($serviceform_id) && $serviceform_id != 0) {
                $url .= '&serviceform_id=' . $serviceform_id;
            }

            $this->response->redirect($this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->customerService();
    }

    protected function customerService() {
        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['filed_male'] = $this->language->get('text_male');
        $data['filed_female'] = $this->language->get('text_female');

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['dob'])) {
            $data['error_dob'] = $this->error['dob'];
        } else {
            $data['error_dob'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['lastname'])) {
            $data['error_lastname'] = $this->error['lastname'];
        } else {
            $data['error_lastname'] = '';
        }

        if (isset($this->error['telephone'])) {
            $data['error_telephone'] = $this->error['telephone'];
        } else {
            $data['error_telephone'] = '';
        }

        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('service/service_form/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['cancel'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true);


        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['home'])) {
            $data['home'] = $this->request->post['home'];
        } else {
            $data['home'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = 0;
        }

        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } else {
            $data['dob'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['telephone2'])) {
            $data['telephone2'] = $this->request->post['telephone2'];
        } else {
            $data['telephone2'] = '';
        }

        if (isset($this->request->post['fax'])) {
            $data['fax'] = $this->request->post['fax'];
        } else {
            $data['fax'] = '';
        }

        // Custom Fields
        $this->load->model('customer/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_customer_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        if (isset($this->request->post['custom_field'])) {
            $data['account_custom_field'] = $this->request->post['custom_field'];
        } else {
            $data['account_custom_field'] = array();
        }

        if (isset($this->request->post['newsletter'])) {
            $data['newsletter'] = $this->request->post['newsletter'];
        } else {
            $data['newsletter'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['approved'])) {
            $data['approved'] = $this->request->post['approved'];
        } else {
            $data['approved'] = true;
        }

        if (isset($this->request->post['safe'])) {
            $data['safe'] = $this->request->post['safe'];
        } else {
            $data['safe'] = 0;
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        if (isset($this->request->post['address'])) {
            $data['addresses'] = $this->request->post['address'];
        } else {
            $data['addresses'] = array();
        }

        if (isset($this->request->post['address_id'])) {
            $data['address_id'] = $this->request->post['address_id'];
        } else {
            $data['address_id'] = '';
        }

        $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

        $this->load->model('localisation/country');
        $data['countries'] = $this->model_localisation_country->getCountries();

        $this->load->model('customer/customer_group');
        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/customer_form', $data));
    }

    protected function validateCustomerForm() {
        if (!$this->user->hasPermission('modify', 'customer/customer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }


        if ($this->request->post['customer_id'] == 0) {
            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
                $this->error['firstname'] = $this->language->get('error_firstname');
            }

            if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
                $this->error['lastname'] = $this->language->get('error_lastname');
            }

            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
                $this->error['customer_ic'] = $this->language->get('error_customer_ic');
            }

            if (!empty($this->request->post['email'])) {
                if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
                    $this->error['email'] = $this->language->get('error_email');
                }

                $customer_info = $this->model_service_service_form->getCustomerByEmail($this->request->post['email']);

                if (!isset($this->request->get['customer_id'])) {
                    if ($customer_info) {
                        $this->error['warning'] = $this->language->get('error_exists');
                    }
                } else {
                    if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
                        $this->error['warning'] = $this->language->get('error_exists');
                    }
                }
            }

            $this->load->model('customer/custom_field');

            $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }

            if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
                if ($this->request->post['password'] != $this->request->post['confirm']) {
                    $this->error['confirm'] = $this->language->get('error_confirm');
                }
            }

            if (isset($this->request->post['address'])) {
                foreach ($this->request->post['address'] as $key => $value) {
                    if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_firstname');
                    }

                    if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                        $this->error['address'][$key]['lastname'] = $this->language->get('error_lastname');
                    }

                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_address_1');
                    }

                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_city');
                    }

                    $this->load->model('localisation/country');

                    $country_info = $this->model_localisation_country->getCountry($value['country_id']);

                    if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                    }

                    if ($value['country_id'] == '') {
                        $this->error['address'][$key]['country'] = $this->language->get('error_country');
                    }

                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_zone');
                    }

                    foreach ($custom_fields as $custom_field) {
                        if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                            $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                        }
                    }
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function getCustomerStatusColor($status) {
        $color = '#000';
        switch ($status) {
            case '0':
                $color = '#ff1744';
                break;
            case '1':
                $color = '#00c853';
                break;
            default:
                $color = '#000';
                break;
        }
        return $color;
    }
    // public function updateProductIdColumn(){
    //      $this->db->query("ALTER TABLE `oc_customer` ADD `code` VARCHAR(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER `language_id`;");

    // }

    public function changeStatus() {
        $this->load->model('customer/customer');

        $customer_id = $this->request->get['customer_id'];
        $status = $this->request->get['status'];

        $change_status = $this->model_customer_customer->customerStatus($customer_id, $status);

        if ($change_status > 0) {
            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_card'])) {
                $url .= '&filter_card=' . urlencode(html_entity_decode($this->request->get['filter_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_email'])) {
                $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_telephone'])) {
                $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group'])) {
                $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
            }

            if (isset($this->request->get['filter_customer_group_id'])) {
                $url .= '&filter_customer_group_id=' . $this->request->get['filter_customer_group_id'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['filter_approved'])) {
                $url .= '&filter_approved=' . $this->request->get['filter_approved'];
            }

            if (isset($this->request->get['filter_ip'])) {
                $url .= '&filter_ip=' . $this->request->get['filter_ip'];
            }

            if (isset($this->request->get['filter_age_from'])) {
                $url .= '&filter_age_from=' . $this->request->get['filter_age_from'];
            }
            if (isset($this->request->get['filter_age_to'])) {
                $url .= '&filter_age_to=' . $this->request->get['filter_age_to'];
            }

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }

            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }

            if (isset($this->request->get['filter_gender'])) {
                $url .= '&filter_gender=' . $this->request->get['filter_gender'];
            }

            if (isset($this->request->get['filter_add_by'])) {
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            // if (isset($this->request->get['filter_date_type'])) {
            //     $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
            // }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }


            $this->response->redirect($this->url->link('customer/customer', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
    }
}
