<?php
class ControllerCommonPopupNotification extends Controller{
    public function index(){
        $this->notification = new Notification($this->registry);

        $data['notifications'] = [];

        $settings_arr = ['notification_status', 'notification_type', 'notification_placement_from', 'notification_placement_align', 'notification_allow_dismiss', 'notification_show_progressbar', 'notification_animate_enter', 'notification_animate_exit', 'notification_delay', 'notification_zindex'];

        foreach($settings_arr as $setting){
            $setting_value = $this->notification->$setting;

            if($setting == 'notification_delay'){
                $data[$setting] = $setting_value * 1000;
            } else{
                $data[$setting] = $setting_value;
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        return $this->load->view('common/popup_notification', $data);
    }

    public function get_notifications(){
        $json = [];
        $notification_results = [];

        $this->notification = new Notification($this->registry);

        $this->load->model('notification/notification');

        if(isset($this->request->post['current_time'])){
            $current_time = $this->request->post['current_time'];
            $current_time_formatted = date('Y-m-d H:i:s', strtotime($current_time));
            $five_seconds_ago = date('Y-m-d H:i:s', strtotime('-5 seconds', strtotime($current_time_formatted)));

            $notifications = $this->model_notification_notification->get_notifications($current_time_formatted, $five_seconds_ago);

            if(!empty($notifications)){
                $json['error_code'] = 0;
                $json['message'] = 'Notifications found';

                foreach($notifications as $notification){
                    $had_read = ($notification['had_read'] > 0) ? true : false;
                    $notification_details = $this->notification->get_notification_details($notification['notification_id']);

                    $notification_title = !empty($notification_details) ? $notification_details['title'] : '';
                    $notification_message = !empty($notification_details) ? $notification_details['message'] : '';
                    $notification_url = !empty($notification_details) ? $notification_details['url'] : '';

                    $notification_results[] = [
                        'module'        => $notification['module'],
                        'title'         => $notification_title,
                        'message'       => $notification_message,
                        'url'           => $notification_url,
                        'had_read'      => $had_read
                    ];
                }

                $json['data'] = $notification_results;
            } else{
                $json['error_code'] = 1;
                $json['message'] = 'No notification found';
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}
?>