<?php
class ControllerCommonMenu extends Controller {
    public function index() {
        $this->load->language('common/column_left');

        $this->load->model('setting/admin_menu');
        $this->load->model('tool/image');

        $data['menus'] = array();

        $menus = $this->model_setting_admin_menu->getAdminMenu(0);

        foreach ($menus as $menu) {
            // Level 2
            if(!$this->user->hasPermission('access', $menu['path'])) continue;

            $children_data = array();

            $children = $this->model_setting_admin_menu->getAdminMenu($menu['menu_id']);

            foreach ($children as $child) {
                // Level 3
                if(!$this->user->hasPermission('access', $child['path'])) continue;

                $leval3_data = array();

                $leval3 = $this->model_setting_admin_menu->getAdminMenu($child['menu_id']);

                foreach($leval3 as $leval){
                    //Level 4
                    if(!$this->user->hasPermission('access', $leval['path'])) continue;
                    $leval4_data = array();

                    $leval4 = $this->model_setting_admin_menu->getAdminMenu($leval['menu_id']);

                    foreach($leval4 as $leval_4){
                        if(!$this->user->hasPermission('access', $leval_4['path'])) continue;

                        $leval4_data[] = array(
                            'id'    => $leval_4['menu_id'],
                            'name'  => $leval_4['name'],
                            'href'  => $this->url->link($leval_4['path'],'user_token=' . $this->session->data['user_token'], true)
                        );
                    }

                    $leval4_href = !empty($leval4_data) ? '' : $this->url->link($leval['path'], 'user_token=' . $this->session->data['user_token'], true);

                    $leval3_data[] = array(
                        'id'        => $leval['menu_id'],
                        'name'      => $leval['name'],
                        'children'  => $leval4_data,
                        'href'      => $leval4_href
                    );
                }

                $level3_href = !empty($leval3_data) ? '' : $this->url->link($child['path'], 'user_token=' . $this->session->data['user_token'], true);

                $children_data[] = array(
                    'id'        => $child['menu_id'],
                    'name'      => $child['name'],
                    'children'  => $leval3_data,
                    'href'      => $level3_href
                );
            }

            $level1_href = !empty($children_data) ? '' : $this->url->link($menu['path'], 'user_token=' . $this->session->data['user_token'], true);

            // Level 1
            $data['menus'][] = array(
                'id'        => $menu['menu_id'],
                'name'      => $menu['name'],
                'children'  => $children_data,
                'icon'      => $menu['icon'],
                'href'      => $level1_href
            );
        }

        // echo '<pre>';
        // print_r($data['menus']);
        // echo '</pre>';

        $data['home'] = $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true);

        return $this->load->view('common/menu', $data);
    }    
}
?>