<?php

class ControllerCatalogStockTransfer extends Controller
{

    private $error = array();

    public function index()
    {
        $this->load->language('catalog/stock_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('catalog/stock_transfer');
        $this->load->model('setting/store');

        $this->getList();
    }

    public function add()
    {
        if ($this->session->data['store_id'] == 0) {
            $this->response->redirect($this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->load->language('catalog/stock_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_transfer');

        //post form
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormAdd()) {
            $this->load->model('setting/setting');
            $transaction_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_transfer', 'store' => $this->session->data['store_id']));
            $this->model_catalog_stock_transfer->addStockTransfer($this->request->post, $transaction_no);
            $this->model_catalog_stock_transfer->updateTransactionNo();

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm($type = 1);
    }

    public function edit()
    {
        $this->load->language('catalog/stock_transfer');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addStyle('view/stylesheet/catalog-stock-transfer-edit.css');

        $this->load->model('catalog/stock_transfer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormEdit()) {
            $this->model_catalog_stock_transfer->updateStockTransfer($this->request->post, $this->request->get['stock_transfer_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm($type = 2);
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_date'])) {
            $filter_date = $this->request->get['filter_date'];
        } else {
            $filter_date = null;
        }

        if (isset($this->request->get['filter_trans_no'])) {
            $filter_trans_no = $this->request->get['filter_trans_no'];
        } else {
            $filter_trans_no = null;
        }

        if (isset($this->request->get['filter_from'])) {
            $filter_from = $this->request->get['filter_from'];
        } else {
            $filter_from = null;
        }

        if (isset($this->request->get['filter_approved'])) {
            $filter_approved = $this->request->get['filter_approved'];
        } else {
            $filter_approved = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'a.transfer_date, a.transfer_no';
        }


        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        //page
        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        //url
        $url = '';

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_trans_no'])) {
            $url .= '&filter_trans_no=' . $this->request->get['filter_trans_no'];
        }

        if (isset($this->request->get['filter_from'])) {
            $url .= '&filter_from=' . $this->request->get['filter_from'];
        }

        if (isset($this->request->get['filter_approved'])) {
            $url .= '&filter_approved=' . $this->request->get['filter_approved'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        //breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        //model
        $this->load->model('catalog/stock_transfer');
        $this->load->model('setting/store');

        $data['transfers'] = array();

        $filter_data = array(
            'filter_date' => $filter_date,
            'filter_trans_no' => $filter_trans_no,
            'filter_from' => $filter_from,
            'filter_approved' => $filter_approved,
            'filter_status' => $filter_status,
            'filter_store_id' => $this->session->data['store_id'],
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin'),
            'sort' => $sort,
            'order' => $order
        );

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_trans_no'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.transfer_no' . $url, true);
        $data['sort_date'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.transfer_date' . $url, true);
        $data['sort_from'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.from_store' . $url, true);
        $data['sort_to'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.to_store' . $url, true);
        $data['sort_approved'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.approved_date' . $url, true);
        $data['sort_accepted'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.accepted_date' . $url, true);
        $data['sort_delivered'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.delivered_date' . $url, true);
        $data['sort_received'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.received_date' . $url, true);
        $data['sort_status'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=a.status' . $url, true);

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $order_total = $this->model_catalog_stock_transfer->getTotalTransfers($filter_data);

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['user_token'] = $this->session->data['user_token'];

        $results = $this->model_catalog_stock_transfer->getTransfers($filter_data);

        foreach ($results as $result) {
            $from_store = $this->model_setting_store->getStore($result['from_store']);

            if (empty($result['approved_date'])) {
                $approved_date = '-';
            } else {
                $approved_date = date($this->language->get('date_format_short'), strtotime($result['approved_date']));
            }

            if (empty($result['accepted_date'])) {
                $accepted_date = '-';
            } else {
                $accepted_date = date($this->language->get('date_format_short'), strtotime($result['accepted_date']));
            }

            if (empty($result['delivered_date'])) {
                $delivered_date = '-';
            } else {
                $delivered_date = date($this->language->get('date_format_short'), strtotime($result['delivered_date']));
            }

            if (empty($result['received_date'])) {
                $received_date = '-';
            } else {
                $received_date = date($this->language->get('date_format_short'), strtotime($result['received_date']));
            }

            $data['transfers'][] = array(
                'transfer_date' => date($this->language->get('date_format_short'), strtotime($result['transfer_date'])),
                'transfer_no' => $result['transfer_no'],
                'from_store' => $from_store['name'],
                'to_store' => $this->config->get('config_name'),
                'approved_date' => $approved_date,
                'accepted_date' => $accepted_date,
                'delivered_date' => $delivered_date,
                'received_date' => $received_date,
                'status' => $result['transfer_status'],
                'action' => $this->url->link('catalog/stock_transfer/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_transfer_id=' . $result['stock_transfer_id'], true)
            );
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['transfer_status'] = array(
            'text_pending' => $this->language->get('text_pending'),
            'text_approved' => $this->language->get('text_approved'),
            'text_accepted' => $this->language->get('text_accepted'),
            'text_delivered' => $this->language->get('text_delivered'),
            'text_received' => $this->language->get('text_received'),
            'text_canceled' => $this->language->get('text_canceled'),
        );

        //variable
        $data['filter_date'] = $filter_date;
        $data['filter_trans_no'] = $filter_trans_no;
        $data['filter_from'] = $filter_from;
        $data['filter_approved'] = $filter_approved;
        $data['filter_status'] = $filter_status;

        $data['store_id'] = $this->session->data['store_id'];
        $data['sort'] = $sort;
        $data['order'] = $order;

        //url
        $data['add'] = $this->url->link('catalog/stock_transfer/add', 'user_token=' . $this->session->data['user_token'] . $url, true);

        //template
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        //view
        $this->response->setOutput($this->load->view('catalog/stock_transfer_list', $data));
    }

    protected function getForm($type)
    {
        $stock_transfer_id = isset($this->request->get['stock_transfer_id']) ? $this->request->get['stock_transfer_id'] : 0;

        $data['stock_transfer_id'] = !empty($stock_transfer_id) ? $this->request->get['stock_transfer_id'] : 0;

        //action
        $data['user_token'] = $this->session->data['user_token'];

        // $action = isset($this->request->post['action']) ? $this->request->post['action'] : false;
        //         if ($action && $action == 'update_status') {
        //             $this->model_catalog_stock_transfer->updateStockTransfer($stock_transfer_id, $this->request->post);
        //             $this->session->data['success'] = $this->language->get('text_success');
        //             $url = '';
        //         }

        if (!isset($this->request->get['stock_transfer_id'])) {
            $data['action'] = $this->url->link('catalog/stock_transfer/add', 'user_token=' . $this->session->data['user_token'], true);
        } else {
            $data['action'] = $this->url->link('catalog/stock_transfer/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_transfer_id=' . $this->request->get['stock_transfer_id'], true);
        }

        $data['text_form'] = !isset($this->request->get['filter_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['prioritys'] = array(
            'low' => $this->language->get('text_low'),
            'high' => $this->language->get('text_high')
        );

        //link
        $data['cancel'] = $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'], true);

        //variable
        $data['user_token'] = $this->session->data['user_token'];

        //breadcrumb
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_transfer', 'user_token=' . $this->session->data['user_token'], true)
        );

        //error
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['transfer_date'])) {
            $data['error_transfer_date'] = $this->error['transfer_date'];
        } else {
            $data['error_transfer_date'] = '';
        }

        if (isset($this->error['product_id'])) {
            $data['error_product_id'] = $this->error['product_id'];
        } else {
            $data['error_product_id'] = [];
        }

        if (isset($this->error['product_qty'])) {
            $data['error_product_qty'] = $this->error['product_qty'];
        } else {
            $data['error_product_qty'] = [];
        }

        if (isset($this->error['transfer_qty'])) {
            $data['error_transfer_qty'] = $this->error['transfer_qty'];
        } else {
            $data['error_transfer_qty'] = [];
        }

        if (isset($this->error['received_qty'])) {
            $data['error_received_qty'] = $this->error['received_qty'];
        } else {
            $data['error_received_qty'] = [];
        }

        //model
        $this->load->model('catalog/stock_transfer');

        if (isset($this->request->get['stock_transfer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $stock_transfer_info = $this->model_catalog_stock_transfer->getStockTransfer($this->request->get['stock_transfer_id']);
        }

        $store_name = $this->model_catalog_stock_transfer->getStore($this->session->data['store_id']);

        $data['to_branch'] = array(
            'name' => $this->config->get('config_name'),
            'id' => 0
        );

        if (isset($this->request->post['from_branch'])) {
            $data['from_branch'] = array(
                'name' => $this->request->post['from'],
                'id' => $this->request->post['from_branch']
            );
        } else if (!empty($stock_transfer_info)) {
            $store_name2 = $this->model_catalog_stock_transfer->getStore($stock_transfer_info['from_store']);

            $data['from_branch'] = array(
                'name' => $store_name2['name'],
                'id' => $stock_transfer_info['from_store']
            );
        } else {
            $data['from_branch'] = array(
                'name' => $store_name['name'],
                'id' => $this->session->data['store_id']
            );
        }

        $data['store_id'] = $this->session->data['store_id'];

        //transfers
        if (isset($this->request->post['transfer'])) {
            $data['transfers'] = $this->request->post['transfer'];
        } else if (!empty($stock_transfer_info)) {
            $data['transfers'] = $this->model_catalog_stock_transfer->getStockTransferDetails($this->request->get['stock_transfer_id']);
        } else {
            $data['transfers'] = array();
        }

        //data
        if (isset($this->request->post['trans_no'])) {
            $data['trans_no'] = $this->request->post['trans_no'];
        } else if (!empty($stock_transfer_info)) {
            $data['trans_no'] = $stock_transfer_info['transfer_no'];
        } else {
            $this->load->model('setting/setting');
            $data['trans_no'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_transfer', 'store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['transfer_date'])) {
            $data['transfer_date'] = $this->request->post['transfer_date'];
        } else if (!empty($stock_transfer_info)) {
            $data['transfer_date'] = $stock_transfer_info['transfer_date'];
        } else {
            $data['transfer_date'] = '';
        }

        if (isset($this->request->post['product_total'])) {
            $data['product_total'] = $this->request->post['product_total'];
        } else if (!empty($stock_transfer_info)) {
            $data['product_total'] = $stock_transfer_info['total'];
        } else {
            $data['product_total'] = '';
        }

        if (isset($this->request->post['priority'])) {
            $data['priority'] = $this->request->post['priority'];
        } else if (!empty($stock_transfer_info)) {
            $data['priority'] = $stock_transfer_info['priority'];
        } else {
            $data['priority'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } else if (!empty($stock_transfer_info)) {
            $data['remark'] = $stock_transfer_info['remark'];
        } else {
            $data['remark'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else if (!empty($stock_transfer_info)) {
            $data['status'] = $stock_transfer_info['status'];
        } else {
            $data['status'] = '';
        }

        //template
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        //view
        if ($type == 1) {
            $this->response->setOutput($this->load->view('catalog/stock_transfer_form', $data));
        } else if ($type == 2) {
            if ($data['status'] != 6) {
                $this->response->setOutput($this->load->view('catalog/stock_transfer_form_disable', $data));
            } else {
                $this->response->setOutput($this->load->view('catalog/stock_transfer_form', $data));
            }
        }
    }

    protected function validateFormAdd()
    {
        if (!$this->user->hasPermission('modify', 'catalog/stock_transfer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['transfer_date'])) {
            $this->error['transfer_date'] = $this->language->get('error_transfer_date');
        }

        $stock_transfer_item = isset($this->request->post['transfer']) ? $this->request->post['transfer'] : false;

        if ($stock_transfer_item) {
            $products_id_list = array();

            foreach ($stock_transfer_item as $row_id => $product) {
                $product_id = $product['product_id'];

                $product_id = trim($product_id);

                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    if (in_array($product_id, $products_id_list)) {
                        $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    }

                    $products_id_list[] = $product_id;
                }

                $qty = $product['product_quantity'];

                $qty = trim($qty);

                if (!is_numeric($qty)) {
                    $this->error['product_qty'][$row_id] = $this->language->get('error_product_quantity');
                } else {
                    if ($qty <= 0) {
                        $this->error['product_qty'][$row_id] = $this->language->get('error_product_quantity');
                    }
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_stock_transfer');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateFormEdit()
    {
        if (!$this->user->hasPermission('modify', 'catalog/stock_transfer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['transfer_date'])) {
            $this->error['transfer_date'] = $this->language->get('error_transfer_date');
        }

        $stock_transfer_item = isset($this->request->post['transfer']) ? $this->request->post['transfer'] : false;

        if (!empty($stock_transfer_item)) {
            foreach ($stock_transfer_item as $row_id => $product) {
                $transfer_qty = !empty($product['transfer_quantity']) ? $product['transfer_quantity'] : '';
                $received_qty = !empty($product['received_quantity']) ? $product['received_quantity'] : '';

                $transfer_qty = trim($transfer_qty);
                $received_qty = trim($received_qty);

                if ($this->request->post['status'] == '1') {
                    if (!is_numeric($transfer_qty)) {
                        $this->error['transfer_qty'][$row_id] = $this->language->get('error_product_transfer_quantity');
                    } else {
                        if ($transfer_qty <= 0) {
                            $this->error['transfer_qty'][$row_id] = $this->language->get('error_product_transfer_quantity');
                        }
                    }
                }

                if ($this->request->post['status'] == '4') {
                    if (!is_numeric($received_qty)) {
                        $this->error['received_qty'][$row_id] = $this->language->get('error_product_received_quantity');
                    } else {
                        if ($transfer_qty <= 0) {
                            $this->error['received_qty'][$row_id] = $this->language->get('error_product_received_quantity');
                        }
                    }
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['product_code'])) {
            $this->load->model('catalog/stock_transfer');

            if (isset($this->request->get['product_code'])) {
                $product_code = $this->request->get['product_code'];
            } else {
                $product_code = '';
            }

            $results = $this->model_catalog_stock_transfer->getProductByCode($product_code);

            foreach ($results as $result) {
                $json[] = array(
                    'product_id' => $result['product_id'],
                    'product_code' => $result['code'],
                    'product_name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'product_selling_price' => $result['price']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function calculateProduct()
    {
        $this->load->model('catalog/stock_transfer');

        if (isset($this->request->get['products'])) {
            $products = $this->request->get['products'];

            $total = 0;
            $json = array();

            foreach ($products as $product) {
                $results = $this->model_catalog_stock_transfer->calculateProduct($product['code'], $product['quantity']);

                $total += $results['row_total'];
                $json[] = array(
                    'code' => $product['code'],
                    'quantity' => $product['quantity'],
                    'row_total' => $results['row_total'],
                    'total' => $total
                );
            }

            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));
        } else {
            $json[] = array(
                'total' => 0
            );
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));
        }
    }
}
