<?php

class ControllerCatalogStockTake extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('catalog/stock_take');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
        $this->document->addStyle('view/stylesheet/css/stock_adjustment_list.css');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_take');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('catalog/stock_take');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_take');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && isset($this->request->post['add_product'])) {
            $stock_take_id = $this->model_catalog_stock_take->addStockTake($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/stock_take/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $stock_take_id . $querystring, true));
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_take->addStockTake($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/stock_take');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_take');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && isset($this->request->post['add_product'])) {
            $stock_take_id = $this->request->get['stock_take_id'];

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/stock_take/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $stock_take_id . $querystring, true));
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $stock_take_info = $this->model_catalog_stock_take->getStockTake($this->request->get['stock_take_id']);
            if ($stock_take_info['status'] == 5) {
                $this->response->redirect($this->url->link('catalog/stock_take/info', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $this->request->get['stock_take_id'], true));
            } else {
                /*$result = array();
                foreach ($this->request->post['stock_take_item'] as $info) {
                    $product_id = $info['product_id'];
                    $store_id =  $this->session->data['store_id'];

                    $datetime = date('Y-m-d') . "  23:59:59";
                    $location_id = $info['location'];
                    $batch_date = !empty($info['batch_date']) ? $info['batch_date'] : "0000-00-00";
                    $close_qty = $this->model_catalog_stock_take->getStock($datetime, $product_id, $store_id, $location_id, $batch_date);
                    $result[] = array(
                        "product_id" => $product_id,
                        "location_id" => $location_id,
                        "store_id" => $store_id,
                        "batch_date" => $batch_date,
                        "onhand_quantity" => $info['onhand_quantity'],
                        "close_qty" => $close_qty,
                        "modify_by" => $this->session->data['user_id']
                    );

                    // $result['success'] = true;
                }
                $this->model_catalog_stock_take->updateProductQuantity($result);*/

                $this->model_catalog_stock_take->editStockTake($this->request->get['stock_take_id'], $this->request->post);
                $this->session->data['success'] = $this->language->get('text_success');

                $querystring = '';

                if (isset($this->request->get['sort']))
                    $querystring .= '&sort=' . $this->request->get['sort'];

                if (isset($this->request->get['order']))
                    $querystring .= '&order=' . $this->request->get['order'];

                if (isset($this->request->get['page']))
                    $querystring .= '&page=' . $this->request->get['page'];

                if (isset($this->request->get['filter_doc_no']))
                    $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

                if (isset($this->request->get['filter_add_by']))
                    $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

                if (isset($this->request->get['filter_date_from']))
                    $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

                if (isset($this->request->get['filter_date_to']))
                    $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

                if (isset($this->request->get['filter_store_id']))
                    $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

                $this->response->redirect($this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true));
            }
        }

        $this->getForm();
    }

    public function info()
    {
        $this->load->language('catalog/stock_take');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_take');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateInfoDesc()) {
            $this->model_catalog_stock_take->editStockTakeInfo(
                $this->request->get['stock_take_id'],
                $this->request->post
            );


            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true));
        }

        $store_id = $this->session->data['store_id'];

        $stock_take_id = isset($this->request->get['stock_take_id']) ? $this->request->get['stock_take_id'] : 0;

        $stock_take_info = [];
        $stock_take_info = $this->model_catalog_stock_take->getStockTake($stock_take_id);

        $stock_take_product = $this->model_catalog_stock_take->getStockTakeProducts($stock_take_id);
        if ($stock_take_product) {
            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_form'] = $this->language->get('heading_title');

            //**sitemap data
            $data['breadcrumbs'] = array();
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true)
            );

            // $stock_take_item = $stock_take_info['stock_take_item'];

            $data['doc_no'] = $stock_take_info['doc_no'];
            $data['doc_date'] = date('d/m/Y H:iA', strtotime($stock_take_info['doc_date']));
            $data['staff'] = $stock_take_info['staff'];
            // $data['stock_take_item'] = $stock_take_item;

            foreach ($stock_take_product as $product) {

                $data['stock_take_item'][] = array(
                    'stock_take_product_id' => $product['stock_take_product_id'],
                    'stock_adjustment_id' => $product['stock_adjustment_id'],
                    'sname' => $product['sname'],
                    'name' => $product['product_name'],
                    'product_name2' => $product['product_name2'],
                    'product_id' => $product['product_id'],
                    'code' => $product['code'],
                    'batch_date' => $product['batch_date'],
                    'onhand_quantity' => $product['stock_onhand'],
                    'stock_balance' => $product['stock_balance'],
                    'qty' => $product['qty'],
                    'unit' => $product['unit'],
                    'category' => $product['category'],
                    'weight_class_id' => $product['weight_class_id'],
                    'location_text' => ($product['location_id'] > 0) ? $product['location'] : 'Default Location',
                    'location' => $product['location_id'],
                    'remark' => $product['remark'],
                    'date_modified' => date('d/m/Y H:iA', strtotime($product['date_modified'])),
                    'modify_by' => $product['modified_by'],
                    'description' => $product['description'],
                    'print' => $this->url->link('catalog/stock_take/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_take_id=' . $product['stock_take_id'], true),
                );
            }

            //**query string
            $querystring = '';

            if (isset($this->request->get['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $querystring .= '&page=' . $this->request->get['page'];
            }

            if (isset($this->request->get['filter_doc_no'])) {
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
            }

            if (isset($this->request->get['filter_add_by'])) {
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            if (isset($this->request->get['filter_date_from'])) {
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }


            //**urls
            $data['barcode_link'] = $this->url->link('catalog/stock_take/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $querystring, true);
            $data['cancel'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->get['stock_take_id']))
                $querystring .= '&stock_take_id=' . $this->request->get['stock_take_id'];
            // $action_mode = !(isset($this->request->get['stock_take_id'])) ? 'add' : 'edit';
            // $data['action'] = $this->url->link("catalog/stock_take/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->post['description'])) {
                $data['description'] = $this->request->post['description'];
            } else if (isset($this->request->get['stock_take_id'])) {
                $data['description'] = $stock_take_info['description'];
            } else {
                $data['description'] = '';
            }

            //**error
            $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
            $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

            $data['user_token'] = $this->session->data['user_token'];

            //**load template module
            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/stock_take_info_form', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function getList()
    {

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $filter_doc_no = $this->request->get['filter_doc_no'];
        } else {
            $filter_doc_no = '';
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }

        if (isset($this->request->get['filter_location'])) {
            $filter_location = $this->request->get['filter_location'];
        } else {
            $filter_location = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = '';
        }


        if (isset($this->request->get['filter_batch_date_from'])) {
            $filter_batch_date_from = $this->request->get['filter_batch_date_from'];
        } else {
            $filter_batch_date_from = '';
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $filter_batch_date_to = $this->request->get['filter_batch_date_to'];
        } else {
            $filter_batch_date_to = '';
        }

        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = '';
        }

        

        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'date_modified';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location'])) {
            $url .= '&filter_location=' . $this->request->get['filter_location'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }
        

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_doc_no_memory'] = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : "";
        $data['filter_remark_memory'] = isset($this->request->get['filter_remark']) ? $this->request->get['filter_remark'] : "";
        $data['filter_add_by'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";
        $data['filter_date_from_memory'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : "";
        $data['filter_date_to_memory'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : "";

        $data['filter_batch_date_from_memory'] = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : "";
        $data['filter_batch_date_to_memory'] = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : "";


        $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";
        $data['filter_product_id_memory'] = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : "";
        $data['filter_product_code_memory'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : "";
    
        $data['filter_location'] = isset($this->request->get['filter_location']) ? explode(',', $this->request->get['filter_location']) : NULL;
        $data['filter_store_id'] = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id']) : $this->session->data['store_id'];
        $data['filter_status'] = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : NULL;
        $data['filter_category'] = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : NULL;

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_remark']))
            $querystring .= '&filter_remark=' . $this->request->get['filter_remark'];

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location']))
            $querystring .= '&filter_location=' . $this->request->get['filter_location'];

        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_batch_date']))
            $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_doc_no'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_no' . $querystring, true);
        $data['sort_product_name'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $querystring, true);
        $data['sort_product_code'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $querystring, true);
        $data['sort_location'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=location' . $querystring, true);
        $data['sort_category'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystring, true);
        $data['sort_stock_movement'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_stock_movement' . $querystring, true);
        $data['sort_qty'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $querystring, true);
        $data['sort_batch_date'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystring, true);
        $data['sort_add_by'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $querystring, true);
        // $data['sort_qty'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $querystring, true);
        $data['sort_doc_date'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_date' . $querystring, true);
        $data['sort_description'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $querystring, true);
        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location'])) {
            $url .= '&filter_location=' . $this->request->get['filter_location'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        // $data['filter'] = $this->url->link('catalog/stock_take/filter', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['add'] = $this->url->link('catalog/stock_take/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link("catalog/stock_take/delete", 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['barcode_link'] = $this->url->link('catalog/stock_take/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $url, true);
        $data['export_all'] = $this->url->link('catalog/stock_take/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_search'] = $this->url->link('catalog/stock_take/export_excel_searched', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_doc_no' => $filter_doc_no,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_location' => $filter_location,
            'filter_store_id' => $filter_store_id,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_remark' => $filter_remark,
            'filter_status' =>$filter_status,
            'filter_category' =>$filter_category,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_take->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_take->getStatus();


        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['staffs'] = $this->model_catalog_stock_take->getStaffs();


        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_take->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_take->getLocations();
        }

        $data['batch_dates'] = $this->model_catalog_stock_take->getAllStockReceivedBatchDates();


        $data['stockTakes'] = array();

        $stockTakeList = $this->model_catalog_stock_take->getStockTakeList($filter_data);

        foreach ($stockTakeList as $stockTake) {
            if($stockTake['store_id'] == 0){
                $store = $this->config->get('config_name');
            }else{
                $store = $stockTake['store_name'];
            }
            $data['stockTakes'][] = array(
                'stock_take_id' => $stockTake['stock_take_id'],
                'stock_take_product_id' => $stockTake['stock_take_product_id'],
                // 'date_added' => date('d/m/Y h:i A', strtotime($stockTake['date_added'])),
                'doc_date' => date('Y-m-d', strtotime($stockTake['date_added'])),
                'doc_no' => $stockTake['doc_no'],
                'location' => $stockTake['location'],
                'qty' => $stockTake['qty'],
                'batch_date' => $stockTake['batch_date'],
                'location_id' => $stockTake['location_id'],
                'product_name' => $stockTake['product_name'],
                'product_code' => $stockTake['product_code'],
                'product_id' => $stockTake['product_id'],
                'status' => $stockTake['status'],
                'onhand' => $stockTake['onhand'],
                'balance' => $stockTake['balance'],
                'description' => $stockTake['description'],
                'add_by' => $stockTake['add_by'],
                'date_modified' => date('Y-m-d H:iA', strtotime($stockTake['date_modified'])),
                'modified_by' => $stockTake['modified_by'],
                'unit' => $stockTake['unit'],
                'zerolise' => $stockTake['zerolise'],
                'category' => $stockTake['category'],
                'remark' => $stockTake['remark'],
                'store_name' => $store,
                'store_id' => $stockTake['store_id'],
                'info' => $this->url->link('catalog/stock_take/info', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $stockTake['stock_take_id'] . $url, true),
                'print' => $this->url->link('catalog/stock_take/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_take_id=' . $stockTake['stock_take_id'], true),
                'edit' => $this->url->link('catalog/stock_take/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $stockTake['stock_take_id'] . '&product_id=' . $stockTake['product_id'] . '&store_id=' . $stockTake['store_id'] . $url, true),
                'export' => $this->url->link('catalog/stock_take/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $stockTake['stock_take_id'], true)
            );
        }

        $total_stock_take = $this->model_catalog_stock_take->totalStockTake($filter_data);

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location'])) {
            $url .= '&filter_location=' . $this->request->get['filter_location'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_stock_take;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_stock_take) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_stock_take - $this->config->get('config_limit_admin'))) ? $total_stock_take : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_stock_take, ceil($total_stock_take / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_take_list', $data));
    }

    public function printForm()
    {

        $this->load->language('catalog/stock_take');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_take');

        if (isset($this->request->get['stock_take_id'])) {
            $stock_take_id = $this->request->get['stock_take_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_take_info = [];
            $stock_take_info = $this->model_catalog_stock_take->getStockTake($stock_take_id);

            $data['stock_take_item'] = [];

            if (!empty($stock_take_info)) {
                $stock_take_products = $this->model_catalog_stock_take->getStockTakeProducts($stock_take_id);
                //load default language
                $this->load->language('catalog/stock_take');

                //set document title
                $this->document->setTitle($this->language->get('heading_title'));

                $data['heading_title'] = $this->language->get('heading_title');

                $data['doc_no'] = $stock_take_info['doc_no'];
                $data['date_added'] = $stock_take_info['date_added'];
                $data['staff'] = $stock_take_info['staff'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_take_info['description'])) {
                    $data['description'] = $stock_take_info['description'];
                } else {
                    $data['description'] = '';
                }

                if (!empty($stock_take_products)) {
                    foreach ($stock_take_products as $product) {
                        $data['stock_take_item'][] = [
                            'product_name' => $product['product_name'],
                            'product_name2' => $product['product_name2'],
                            'product_code' => $product['code'],
                            'qty' => $product['qty'],
                            'category' => $product['category'],
                            'batch_date' => $product['batch_date'],
                            'location' => $product['location'],
                            'unit' => $product['unit'],
                            'stock_onhand' => $product['stock_onhand'],
                            'stock_balance' => $product['stock_balance'],
                            'date_modified' => date('d/m/Y', strtotime($product['date_modified'])),
                            'sname' => $product['sname'],
                            'modified_by' => $product['modified_by'],
                            'description' => $product['description']
                        ];
                    }
                }
            }

            if (isset($this->request->get['pdf'])) {
                $pdf = new PDF();
                $page_size = 'a4';
                $pdf_file_name = $stock_take_info['doc_no'] . '.pdf';

                $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_take_print', $data), $pdf_file_name, $page_size));
            } else {
                $this->response->setOutput($this->load->view('catalog/stock_take_print', $data));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true));
        }
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');


        $take_info = $this->model_catalog_stock_take->getStockTakeItemAll();

        if (!empty($take_info)) {
            // get user detail
            $this->load->model('user/user');
            $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

            // load php Excel
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();

            // Set document properties
            $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setTitle('Title')
                ->setSubject('Subject')
                ->setDescription('Description')
                ->setKeywords('report qiangyitang.com')
                ->setCategory('report excel');

            // Set default font
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                ->setSize(10);

            $take_item = $this->model_catalog_stock_take->getStockTakeItemAll();

            $table_collection = array();

            if (!empty($take_item)) {
                foreach ($take_item as $item) {
                    $table_collection[] = [
                        'stock_take_id' => $item['stock_take_id'],
                        'doc_no' => $item['doc_no'],
                        'product_name' => ($item['product_name2'] == $item['product_name']) ? $item['product_name'] : $item['product_name'] . " " . $item['product_name2'],
                        'product_code' => $item['product_code'],
                        'store_name' => empty($item['batch_date']) ? $item['store_name'] . " (Batch Date: 0000-00-00)" : $item['store_name'] . " (Batch Date: " . $item['batch_date'] . ") ",
                        'qty' => $item['qty'] . " " . $item['unit'],
                        'status_name' => $item['status_name'],
                        'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                        'date_added' => $item['date_added'],
                        'add_by' => $item['add_by']
                    ];
                }
            }


            $table = array();

            $table[] = array('Report Name : ', $this->language->get('heading_title'));
            date_default_timezone_set("Asia/Kuala_Lumpur");
            $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

            $table[] = array();

            $table_header = array(
                $this->language->get('column_stock_id'),
                $this->language->get('column_doc'),
                $this->language->get('column_product'),
                $this->language->get('sort_product_code'),
                $this->language->get('entry_store'),
                $this->language->get('column_qty'),
                $this->language->get('column_status'),
                $this->language->get('column_stock_movement'),
                $this->language->get('column_date_added'),
                $this->language->get('row_add_by')
            );

            $table[] = $table_header;

            $total_row = 0;

            $table_data = $table_collection;
            // $row;

            foreach ($table_data as $key => $data) {
                $row = array();

                foreach ($data as $key => $value) {
                    $row[] = $value;
                }
                $table[] = $row;

                $total_row++;
            }

            // Styling
            $autosize_column_index = 'A';
            foreach ($table_header as $header) {
                $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                $autosize_column_index++;
            }

            $header_index_s_column = 'A';
            $header_index_e_column = $header_index_s_column;
            foreach ($table_header as $col)
                $header_index_e_column++;
            $header_index_row = 4;
            $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

            $header_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                ),
                'font' => array(
                    'bold' => true
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

            $currency_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                ),
                'numberformat' => array(
                    'code' => "0.00"
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

            // Add Array To Excel
            $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

            // Rename worksheet
            $sheettitle = $this->language->get('heading_title');
            $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
            $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            $filename = $this->language->get('heading_title') . '_All';

            // Save Excel 2007 file
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            //ob_end_clean();
            // We'll be outputting an excel file
            header('Content-type: application/vnd.ms-excel');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
            $objWriter->save('php://output');
        }
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : NULL;
        $filter_remark = isset($this->request->get['filter_remark']) ? $this->request->get['filter_remark'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;

        $filter_add_by = isset($this->request->get['filter_add_by']) ? explode(',', $this->request->get['filter_add_by']) : NULL;

        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_location = isset($this->request->get['filter_location']) ? explode(',', $this->request->get['filter_location']) : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : Null;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : Null;

        $filter_batch_date = isset($this->request->get['filter_batch_date']) ? $this->request->get['filter_batch_date'] : NULL;

        $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id'])  : NULL;

        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;

        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_remark']))
            $querystring .= '&filter_remark=' . $this->request->get['filter_remark'];

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location']))
            $querystring .= '&filter_location=' . $this->request->get['filter_location'];

        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        $filter_data = array(
            'filter_doc_no' => $filter_doc_no,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_product_id' => $filter_product_id,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_location' => $filter_location,
            'filter_category' => $filter_category,
            'filter_status' => $filter_status,
            'filter_store_id' => $filter_store_id,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_remark' => $filter_remark
        );

        $take_info = $this->model_catalog_stock_take->getStockTakeItemAll();

        if (!empty($take_info)) {
            // get user detail
            $this->load->model('user/user');
            $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

            // load php Excel
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();

            // Set document properties
            $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setTitle('Title')
                ->setSubject('Subject')
                ->setDescription('Description')
                ->setKeywords('report qiangyitang.com')
                ->setCategory('report excel');

            // Set default font
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                ->setSize(10);

            $take_item = $this->model_catalog_stock_take->getStockTakeItemSearched($filter_data);

            $table_collection = array();

            if (!empty($take_item)) {
                foreach ($take_item as $item) {
                    $table_collection[] = [
                        'stock_take_id' => $item['stock_take_id'],
                        'doc_no' => $item['doc_no'],
                        'product_name' => ($item['product_name2'] == $item['product_name']) ? $item['product_name'] : $item['product_name'] . " " . $item['product_name2'],
                        'product_code' => $item['product_code'],
                        'store_name' => empty($item['batch_date']) ? $item['store_name'] . " (Batch Date: 0000-00-00)" : $item['store_name'] . " (Batch Date: " . $item['batch_date'] . ") ",
                        'qty' => $item['qty'] . " " . $item['unit'],
                        'status_name' => $item['status_name'],
                        'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                        'date_added' => $item['date_added'],
                        'add_by' => $item['add_by']
                    ];
                }
            }


            $table = array();

            $table[] = array('Report Name : ', $this->language->get('heading_title'));
            date_default_timezone_set("Asia/Kuala_Lumpur");
            $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

            $table[] = array();

            $table_header = array(
                $this->language->get('column_stock_id'),
                $this->language->get('column_doc'),
                $this->language->get('column_product'),
                $this->language->get('sort_product_code'),
                $this->language->get('entry_store'),
                $this->language->get('column_qty'),
                $this->language->get('column_status'),
                $this->language->get('column_stock_movement'),
                $this->language->get('column_date_added'),
                $this->language->get('row_add_by')
            );

            $table[] = $table_header;

            $total_row = 0;

            $table_data = $table_collection;
            // $row;

            foreach ($table_data as $key => $data) {
                $row = array();

                foreach ($data as $key => $value) {
                    $row[] = $value;
                }
                $table[] = $row;

                $total_row++;
            }

            // Styling
            $autosize_column_index = 'A';
            foreach ($table_header as $header) {
                $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                $autosize_column_index++;
            }

            $header_index_s_column = 'A';
            $header_index_e_column = $header_index_s_column;
            foreach ($table_header as $col)
                $header_index_e_column++;
            $header_index_row = 4;
            $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

            $header_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                ),
                'font' => array(
                    'bold' => true
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

            $currency_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                ),
                'numberformat' => array(
                    'code' => "0.00"
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

            // Add Array To Excel
            $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

            // Rename worksheet
            $sheettitle = $this->language->get('heading_title');
            $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
            $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            $filename = $this->language->get('heading_title') . '_Searched';

            // Save Excel 2007 file
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            //ob_end_clean();
            // We'll be outputting an excel file
            header('Content-type: application/vnd.ms-excel');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
            $objWriter->save('php://output');
        }
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        if (isset($this->request->get['takes'])) {
            $take_ids = explode(",", $this->request->get['takes']);

            $take_info = $this->model_catalog_stock_take->getStockTakeItemAll();

            if (!empty($take_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $table_collection = array();

                foreach ($take_ids as $take_id) {

                    $take_item = $this->model_catalog_stock_take->getStockTakeItemSelected($take_id);


                    if (!empty($take_item)) {
                        foreach ($take_item as $item) {
                            $table_collection[] = [
                                'stock_take_id' => $item['stock_take_id'],
                                'doc_no' => $item['doc_no'],
                                'product_name' => ($item['product_name2'] == $item['product_name']) ? $item['product_name'] : $item['product_name'] . " " . $item['product_name2'],
                                'product_code' => $item['product_code'],
                                'store_name' => empty($item['batch_date']) ? $item['store_name'] . " (Batch Date: 0000-00-00)" : $item['store_name'] . " (Batch Date: " . $item['batch_date'] . ") ",
                                'qty' => $item['qty'] . " " . $item['unit'],
                                'status_name' => $item['status_name'],
                                'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                                'date_added' => $item['date_added'],
                                'add_by' => $item['add_by']
                            ];
                        }
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_doc'),
                    $this->language->get('column_product'),
                    $this->language->get('sort_product_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function export_excel()
    {
        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        if (isset($this->request->get['stock_take_id'])) {
            $stock_take_id = $this->request->get['stock_take_id'];

            $sa_info = $this->model_catalog_stock_take->getStockTake($stock_take_id);

            if (!empty($sa_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_take_item = $sa_info['stock_take_item'];

                $table_collection = array();

                if (!empty($stock_take_item)) {
                    foreach ($stock_take_item as $product_id => $item) {

                        $table_collection[] = [
                            'product_id' => $product_id,
                            'product_name' => $item['name'],
                            'product_code' => $item['code'],
                            'qty' => $item['qty']
                        ];
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Invoice Prefix : ', $sa_info['doc_no']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $sa_info['description']);
                $table[] = array('Date : ', $sa_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_action'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $sa_info['doc_no'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function insertProductToDatabase()
    {
        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        $json = [];
        $error = false;

        $stock_take_id = !empty($this->request->post['stock_take_id']) ? $this->request->post['stock_take_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_take_id)) {
            $error = true;
        }

        if (empty($product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $result = $this->model_catalog_stock_take->addStockTakeProduct($this->request->post);
            $json['stock_take_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateProductToDatabase()
    {

        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        $json = [];
        $error = false;

        $stock_take_product_id = !empty($this->request->post['stock_take_product_id']) ? $this->request->post['stock_take_product_id'] : 0;
        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_take_product_id)) {
            $error = true;
        }

        if (empty($product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $result = $this->model_catalog_stock_take->editStockTakeProduct($this->request->post);
            $json['stock_take_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function deleteProductFromDatabase()
    {

        $this->load->language('catalog/stock_take');
        $this->load->model('catalog/stock_take');

        $json = [];
        $error = false;

        $stock_take_product_id = !empty($this->request->post['stock_take_product_id']) ? $this->request->post['stock_take_product_id'] : 0;



        if (empty($stock_take_product_id)) {
            $error = true;
        }

        if (empty($error)) {

            $this->model_catalog_stock_take->deleteStockTakeProduct($stock_take_product_id);

            $json['stock_take_product_id'] = !empty($stock_take_product_id) ? $stock_take_product_id : 0;

            $json['success'] = !empty($stock_take_product_id) ? true : false;
        } else {

            $json['errors'][] = [

                'error' => 'missing_product_data',

                'msg'   => $this->language->get('error_missing_product_data')

            ];
        }



        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }


    public function deductItem()
    {
        $json = array('success' => false);

        $stock_take_product_id = (isset($this->request->post['stock_take_product_id'])) ? $this->request->post['stock_take_product_id'] : false;
        $remark = (isset($this->request->post['remark'])) ? $this->request->post['remark'] : false;

        if ($stock_take_product_id) {
            $this->load->model('catalog/stock_take');
            $this->model_catalog_stock_take->deductItem($stock_take_product_id, $remark);
            $json = array(
                'success' => true,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    // public function getDefaultLocation()
    // {
    //     $json = array('success' => false);

    //     $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

    //     if ($product_id) {
    //         $this->load->model('catalog/stock_take');
    //         $def_location = $this->model_catalog_stock_take->getDefaultLocation($product_id);
    //         $json = array(
    //             'success' => true,
    //             'def_location' => $def_location,
    //         );
    //     }

    //     $this->response->addHeader('Content-Type: application/json');
    //     return $this->response->setOutput(json_encode($json));
    // }

    public function getDefaultLocationAndWeightClassId()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/stock_take');
            $def_location = $this->model_catalog_stock_take->getDefaultLocation($product_id);
            $def_wcid = $this->model_catalog_stock_take->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'def_location' => $def_location,
                'def_wcid' => $def_wcid,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getForm()
    {

        $data['user_token'] = $this->session->data['user_token'];

        $store_id = $this->session->data['store_id'];

        if (isset($this->request->get['stock_take_id'])) {
            $stock_take_info = $this->model_catalog_stock_take->getStockTake($this->request->get['stock_take_id']);
            if ($stock_take_info['status'] == 5) {
                $this->response->redirect($this->url->link('catalog/stock_take/info', 'user_token=' . $this->session->data['user_token'] . '&stock_take_id=' . $this->request->get['stock_take_id'], true));
            }
            $data['zerolize'] = $stock_take_info['zerolise'];
            $data["form_memory_doc_no"] = $stock_take_info['doc_no'];
            $data['stock_take_id'] = $this->request->get['stock_take_id'];
        } else {
            $data["form_memory_doc_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_take', 'store' => $store_id));
            $data['stock_take_id'] = 0;
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $data["form_memory_doc_date"] = isset($this->request->post['doc_date']) ? $this->request->post['doc_date'] : date('Y-m-d');
            $form_memory_stock_take_items = isset($this->request->post['stock_take_item']) ?
                $this->request->post['stock_take_item'] :
                array();
            $data["form_memory_stock_take_items"] = $form_memory_stock_take_items;
            $data['description'] = $this->request->post['description'];
        } elseif (!empty($stock_take_info)) {
            $empty_product = array(
                array(
                    'stock_take_product_id' => 0,
                    'stock_adjustment_id' => '',
                    'name' => '',
                    'product_id' => '',
                    'code' => '',
                    'onhand_quantity' => '',
                    'qty' => '',
                    'weight_class_id' => '',
                    'location_text' => '',
                    'location' => 0,
                    'remark' => ''
                )
            );
            $data["form_memory_doc_date"] = $stock_take_info['doc_date'];
            $data["form_memory_stock_take_items"] = isset($stock_take_info['stock_take_item']) ? $stock_take_info['stock_take_item'] : $empty_product;
            $data['description'] = $stock_take_info['description'];
        } else {
            $data["form_memory_doc_date"] = date('Y-m-d');
            $data["form_memory_stock_take_items"] = array();
            $data['description'] = '';
        }

        foreach ($data["form_memory_stock_take_items"] as $item) {
            if (!empty($item['product_id'])) {
                // $data['locations'][$item['product_id']] = $this->model_catalog_stock_take->getLocationList($item['product_id']);
                $data['batchDates'][$item['product_id']][$item['location']] = $this->model_catalog_stock_take->getBatchDateList($item['product_id'], $item['location']);
            }
        }

        $data['locations'] = $this->model_catalog_stock_take->getLocations();
        $data['weight_classes'] = $this->model_catalog_stock_take->getWeightClasses();

        //**text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['stock_take_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'], true)
        );

        //**query string
        $querystring = '';

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**urls
        $data['cancel'] = $this->url->link('catalog/stock_take', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['barcode_link'] = $this->url->link('catalog/stock_take/printProductStickers', true);

        if (isset($this->request->get['stock_take_id']))
            $querystring .= '&stock_take_id=' . $this->request->get['stock_take_id'];

        $action_mode = !(isset($this->request->get['stock_take_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/stock_take/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_product_id'] = isset($this->error['product_id']) ? $this->error['product_id'] : NULL;
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : NULL;
        $data['error_product_loc'] = isset($this->error['product_location']) ? $this->error['product_location'] : NULL;

        $data['user_token'] = $this->session->data['user_token'];

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['store_id'] = $this->session->data['store_id'];

        $this->response->setOutput($this->load->view('catalog/stock_take_form', $data));
    }

    protected function validateForm()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_take') && !$this->user->userpermission('modify', 'catalog/stock_take'))
            $this->error['warning'] = $this->language->get('error_permission');

        $stock_take_item = isset($this->request->post['stock_take_item']) ? $this->request->post['stock_take_item'] : false;

        if ($stock_take_item) {

            $products_id_list = array();

            foreach ($stock_take_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                $location_id = isset($product['location']) ? $product['location'] : null;
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    // if (in_array($product_id, $products_id_list)) {
                    //     $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    // }

                    $products_id_list[] = $product_id;
                }

                $qty = $product['qty'];
                $qty = trim($qty);
                if (!is_numeric($qty)) {
                    $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                } else {
                    if ($qty <= 0) {
                        $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                    }
                }
                if (!is_numeric($location_id)) {
                    $this->error['product_location'][$row_id] = $this->language->get('error_location');
                }

                // error_product_loc
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_stock_take');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
    protected function validateDraftForm()
    {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_take') && !$this->user->userpermission('modify', 'catalog/stock_take'))
            $this->error['warning'] = $this->language->get('error_permission');

        $stock_take_item = isset($this->request->post['stock_take_item']) ? $this->request->post['stock_take_item'] : false;

        if ($stock_take_item) {

            $products_id_list = array();

            foreach ($stock_take_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    // if (in_array($product_id, $products_id_list)) {
                    //     $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    // }

                    $products_id_list[] = $product_id;
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_stock_take');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function getLocationList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/stock_take');
            $locationList = $this->model_catalog_stock_take->getLocationList($product_id);
            $def_wcid = $this->model_catalog_stock_take->getweightClassProduct($product_id);

            if (!empty($locationList)) {
                $json = array(
                    'success'  => true,
                    'list'     => $locationList,
                    'def_wcid' => $def_wcid,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getBatchDateList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;

        if ($product_id) {
            $this->load->model('catalog/stock_take');
            $batchDateList = $this->model_catalog_stock_take->getBatchDateList($product_id, $location_id);

            if (!empty($batchDateList)) {
                $json = array(
                    'success' => true,
                    'list'    => $batchDateList,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
    protected function validateInfoDesc()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_take') && !$this->user->userpermission('modify', 'catalog/stock_take')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['description'])) {
            $this->error['description'] = $this->language->get('error_description');
        }





        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
}
