<?php

class ControllerCatalogStockReserved extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('catalog/stock_reserved');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_reserved');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('catalog/stock_reserved');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_reserved');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $stock_reserved_id = $this->model_catalog_stock_reserved->addStockReserved($this->request->post);

            if (!empty($stock_reserved_id)) {
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_reserved', 'store' => $this->session->data['store_id']));
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_add_by'])) {
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            if (isset($this->request->get['filter_batch_date_from'])) {
                $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
            }
            if (isset($this->request->get['filter_batch_date_to'])) {
                $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
            }

            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }

            if (isset($this->request->get['filter_location_id'])) {
                $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
            }

            if (isset($this->request->get['filter_product_code'])) {
                $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
            }

            if (isset($this->request->get['filter_product_name'])) {
                $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/stock_reserved/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $stock_reserved_id . $url, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/stock_reserved');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_reserved');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {

            $this->model_catalog_stock_reserved->editStockReserved($this->request->get['stock_reserved_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_add_by'])) {
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            if (isset($this->request->get['filter_batch_date_from'])) {
                $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
            }
            if (isset($this->request->get['filter_batch_date_to'])) {
                $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
            }

            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }

            if (isset($this->request->get['filter_location_id'])) {
                $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
            }

            if (isset($this->request->get['filter_product_code'])) {
                $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
            }

            if (isset($this->request->get['filter_product_name'])) {
                $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function info()
    {
        $this->load->language('catalog/stock_reserved');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_reserved');

        $url = '';

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateInfoDesc()) {
            $this->model_catalog_stock_reserved->editStockReservedInfo(
                $this->request->get['stock_reserved_id'],
                $this->request->post
            );

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $stock_reserved_id = isset($this->request->get['stock_reserved_id']) ? $this->request->get['stock_reserved_id'] : 0;

        $stock_reserved_info = $this->model_catalog_stock_reserved->getStockReserved($stock_reserved_id);
        if ($stock_reserved_info) {

            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_form'] = $this->language->get('heading_title');

            if (isset($this->request->get['stock_reserved_id'])) {
                $url .= '&stock_reserved_id=' . $this->request->get['stock_reserved_id'];
            }

            // Breadcrumbs
            $data['breadcrumbs'] = [];
            $data['breadcrumbs'][] = [
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            ];

            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'], true)
            ];

            $stock_reserved_item = $stock_reserved_info['stock_reserved_item'];

            $data['doc_no'] = $stock_reserved_info['doc_no'];
            $data['doc_date'] = date('m/d/Y h:i:s a', strtotime($stock_reserved_info['doc_date']));
            $data['staff'] = $stock_reserved_info['staff'];

            $data['stock_reserved_item'] = $stock_reserved_item;

            $data['cancel'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true);

            if (isset($this->request->post['description'])) {
                $data['description'] = $this->request->post['description'];
            } else if (isset($this->request->get['stock_reserved_id'])) {
                $data['description'] = $stock_reserved_info['description'];
            } else {
                $data['description'] = '';
            }

            $data['export'] = $this->url->link('catalog/stock_reserved/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $stock_reserved_id, true);
            $data['print'] = $this->url->link('catalog/stock_reserved/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_reserved_id=' . $stock_reserved_id, true);
            $data['barcode_link'] = $this->url->link('catalog/stock_reserved/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $url, true);
            // Error
            $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
            $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

            $data['user_token'] = $this->session->data['user_token'];

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/stock_reserved_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = [];

            $data['breadcrumbs'][] = [
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            ];

            $data['breadcrumbs'][] = [
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            ];

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function getList()
    {
        $filter_add_by = isset($this->request->get['filter_add_by']) ? explode(',', $this->request->get['filter_add_by']) : '';
        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : '';
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : '';
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : '';
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : '';
        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : '';
        $filter_location = isset($this->request->get['filter_location']) ? explode(',', $this->request->get['filter_location']) : '';
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : '';
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : '';
        // $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id'])  : $this->session->data['store_id'];
        $filter_remark = isset($this->request->get['filter_remark']) ? $this->request->get['filter_remark'] : '';

        // if(!empty($this->request->get['filter_store_id'])){
        //     $filter_store_id = explode(',', $this->request->get['filter_store_id']);
        // }else{
        //     if(isset($this->request->get['filter_store_id']) && $this->request->get['filter_store_id'] == NULL){
        //         $filter_store_id = NULL;
        //     }elseif(isset($this->request->get['filter_store_id']) && $this->request->get['filter_store_id'] == 0){
        //         $filter_store_id = ['0'];
        //     }else{
        //         $filter_store_id = [$this->session->data['store_id']];
        //     }
        // }

        if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}

        if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = '';
		}

        if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
        
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'doc_no';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';
        $url = '';

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_location'])) {
            $url .= '&filter_location=' . $this->request->get['filter_location'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }
        
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $querystring = $url;

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // Breadcrumbs
        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        $data['filter'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['add'] = $this->url->link('catalog/stock_reserved/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link("catalog/stock_reserved/delete", 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['stock_reserveds'] = [];

        $filter_data = [
            'filter_add_by' => $filter_add_by,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_doc_no' => $filter_doc_no,
            'filter_location' => $filter_location,
            'filter_product_code' => $filter_product_code,
            'filter_product_name' => $filter_product_name,
            'filter_store_id' => $filter_store_id,
            'filter_remark' => $filter_remark,
            'filter_category' => $filter_category,
            'filter_status' => $filter_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_reserved->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_reserved->getStatus();


        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $stock_reserved_total = $this->model_catalog_stock_reserved->getTotalStockReserveds($filter_data);

        $results = $this->model_catalog_stock_reserved->getStockReservedList($filter_data);

        foreach ($results as $result) {
            $data['stock_reserved'][] = [
                'stock_reserved_id' => $result['stock_reserved_id'],
                // 'date_added' => date('d/m/Y h:i A', strtotime($stockTake['date_added'])),
                'doc_date' => date('Y-m-d', strtotime($result['doc_date'])),
                'doc_no' => $result['doc_no'],
                'location' => $result['location'],
                'qty' => $result['qty'],
                'batch_date' => $result['batch_date'],
                'location_id' => $result['location_id'],
                'product_id' => $result['product_id'],
                'product_name' => $result['product_name'],
                'product_name2' => $result['product_name2'],
                'product_code' => $result['product_code'],
                'status' => $result['status'],
                'stock_onhand' => $result['stock_onhand'],
                'stock_balance' => $result['stock_balance'],
                'stock_reserved_onhand' => $result['stock_reserved_onhand'],
                'stock_reserved_balance' => $result['stock_reserved_balance'],
                'description' => $result['description'],
                'add_by' => $result['add_by'],
                'date_added' => date('Y-m-d',strtotime($result['date_added'])),
                'date_modified' => date('Y-m-d',strtotime($result['date_modified'])),
                'modified_by' => $result['modified_by'],
                'unit' => $result['unit'],
                'category' => $result['category'],
                'category_id' => $result['category_id'],
                'sname' => $result['sname'],
                'remark' => $result['remark'],
                'info' => $this->url->link('catalog/stock_reserved/info', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $result['stock_reserved_id'] . $url, true),
                'edit' => $this->url->link('catalog/stock_reserved/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $result['stock_reserved_id'] . $url, true),
                'export' => $this->url->link('catalog/stock_reserved/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $result['stock_reserved_id'], true),
                'print' => $this->url->link('catalog/stock_reserved/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_reserved_id=' . $result['stock_reserved_id'], true)
            ];
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        // Sort Data
        $data['sort_add_by'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $url, true);
        $data['sort_batch_date'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $url, true);
        $data['sort_description'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true);
        $data['sort_doc_date'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_date' . $url, true);
        $data['sort_doc_no'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_no' . $url, true);
        $data['sort_location'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=location' . $url, true);
        $data['sort_product_code'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $url, true);
        $data['sort_product_name'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $url, true);
        $data['sort_qty'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $url, true);

        // Pagination
        $pagination = new Pagination();
        $pagination->total = $stock_reserved_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($stock_reserved_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($stock_reserved_total - $this->config->get('config_limit_admin'))) ? $stock_reserved_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $stock_reserved_total, ceil($stock_reserved_total / $this->config->get('config_limit_admin')));

        //** Filter Data
        $data['filter_add_by'] = $filter_add_by;
        $data['filter_batch_date_from_memory'] = $filter_batch_date_from;
        $data['filter_batch_date_to_memory'] = $filter_batch_date_to;
        $data['filter_doc_no_memory'] = $filter_doc_no;
        $data['filter_date_from_memory'] = $filter_date_from;
        $data['filter_date_to_memory'] = $filter_date_to;
        $data['filter_location_memory'] = $filter_location;;
        $data['filter_product_name_memory'] = $filter_product_name;
        $data['filter_product_code_memory'] = $filter_product_code;
        $data['filter_store_id_memory'] = $filter_store_id;
        $data['filter_remark'] = $filter_remark;
        $data['filter_category'] = $filter_category;
        $data['filter_status'] = $filter_status;



        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['user_view'] = $this->user->user_view;

        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_reserved->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_reserved->getLocations();
        }

        $data['batch_dates'] = $this->model_catalog_stock_reserved->getAllStockReceivedBatchDates();
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

        $this->load->model('setting/store');

        $data['stores'] = [];

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();
        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['staffs'] = $this->model_catalog_stock_reserved->getStaffs();

        $data['barcode_link'] = $this->url->link('catalog/stock_reserved/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $url, true);
        $data['export_all'] = $this->url->link('catalog/stock_reserved/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_search'] = $this->url->link('catalog/stock_reserved/export_excel_searched', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_reserved_list', $data));
    }

    
    public function printForm(){
        
        $this->load->language('catalog/stock_reserved');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_reserved');

        if (isset($this->request->get['stock_reserved_id'])) {
            $stock_reserved_id = $this->request->get['stock_reserved_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_reserved_info = [];
            $stock_reserved_info = $this->model_catalog_stock_reserved->getStockReserved($stock_reserved_id);

            $data['stock_reserved_item'] = [];

            if (!empty($stock_reserved_info)) {
                $stock_reserved_products = $this->model_catalog_stock_reserved->getStockreservedProducts($stock_reserved_id);

                $data['doc_no'] = $stock_reserved_info['doc_no'];
                $data['date_added'] = date('d/m/Y H:iA', strtotime($stock_reserved_info['date_added']));
                $data['staff'] = $stock_reserved_info['staff'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_reserved_info['description'])) {
                    $data['description'] = $stock_reserved_info['description'];
                } else {
                    $data['description'] = '';
                }



                if (!empty($stock_reserved_products)) {
                    foreach ($stock_reserved_products as $product) {
                        $data['stock_reserved_item'][] = [
                            'title' => $product['doc_no'],
                            'product_name' => $product['product_name'],
                            'product_name2' => $product['product_name2'],
                            'product_code' => $product['product_code'],
                            'qty' => $product['qty'],
                            'category' => $product['category'],
                            'batch_date' => $product['batch_date'],
                            'location' => $product['location'],
                            'unit' => $product['unit'],
                            'sname' => $product['sname'],
                            'stock_onhand' => $product['stock_onhand'],
                            'stock_balance' => $product['stock_balance'],
                            'date_modified' => date('d/m/Y', strtotime($product['date_modified'])),
                            'modified_by' => $product['modified_by'],
                            'description' => $product['description']
                        ];
                    }
                }

                if (isset($this->request->get['pdf'])) {
                    $pdf = new PDF();
                    $page_size ='a4';
                    $pdf_file_name = $stock_reserved_info['doc_no'] . '.pdf';
    
                    $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_reserved_print', $data), $pdf_file_name, $page_size));
                }
                else {
                    $this->response->setOutput($this->load->view('catalog/stock_reserved_print', $data));
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'], true));
        }

       
    }

    public function export_excel()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        if (isset($this->request->get['stock_reserved_id'])) {
            $stock_reserved_id = $this->request->get['stock_reserved_id'];

            $stock_reserved_info = $this->model_catalog_stock_reserved->getStockReserved($stock_reserved_id);

            if (!empty($stock_reserved_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_reserved_items = $this->model_catalog_stock_reserved->getStockreservedProducts($stock_reserved_id);

                $table_collection = array();

                if (!empty($stock_reserved_items)) {
                    foreach ($stock_reserved_items as $item) {
                        $table_collection[] = [
                            'product_id' => $item['product_id'],
                            'product_name' => $item['product_name'],
                            'product_code' => $item['product_code'],
                            'quantity' => $item['qty']
                        ];
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Invoice Prefix : ', $stock_reserved_info['doc_no']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $stock_reserved_info['description']);
                $table[] = array('Date : ', $stock_reserved_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $stock_reserved_info['doc_no'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');


            $reserved_info = $this->model_catalog_stock_reserved->getStockReservedItemAll();

            if (!empty($reserved_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $reserved_item = $this->model_catalog_stock_reserved->getStockReservedItemAll();

                $table_collection = array();

                if (!empty($reserved_item)) {
                    foreach ($reserved_item as $item) {
                        $table_collection[] = [
                            'stock_reserved_id' => $item['stock_reserved_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_customer'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        $filter_add_by = isset($this->request->get['filter_add_by']) ? explode(',', $this->request->get['filter_add_by']) : NULL;
        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : NULL;
        $filter_location = isset($this->request->get['filter_location']) ? explode(',', $this->request->get['filter_location']) : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id'])  : $this->session->data['store_id'];

        $url = '';

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $querystring = $url;

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['stock_reserveds'] = [];

        $filter_data = [
            'filter_add_by' => $filter_add_by,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_doc_no' => $filter_doc_no,
            'filter_location' => $filter_location,
            'filter_product_code' => $filter_product_code,
            'filter_product_name' => $filter_product_name,
            'filter_store_id' => $filter_store_id
        ];


        $reserved_info = $this->model_catalog_stock_reserved->getStockReservedItemAll();

        if (!empty($reserved_info)) {
            // get user detail
            $this->load->model('user/user');
            $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

            // load php Excel
            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();

            // Set document properties
            $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                ->setTitle('Title')
                ->setSubject('Subject')
                ->setDescription('Description')
                ->setKeywords('report qiangyitang.com')
                ->setCategory('report excel');

            // Set default font
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                ->setSize(10);

            $reserved_item = $this->model_catalog_stock_reserved->getStockReservedItemSearched($filter_data);

            $table_collection = array();

            if (!empty($reserved_item)) {
                foreach ($reserved_item as $item) {
                    $table_collection[] = [
                        'stock_reserved_id' => $item['stock_reserved_id'],
                        'doc_no' => $item['doc_no'],
                        'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                        'product_code' => $item['product_code'],
                        'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                        'qty' => $item['qty']. " " .$item['unit'],
                        'status_name' => $item['status_name'],
                        'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                        'date_added' => $item['date_added'],
                        'add_by' => $item['add_by']
                    ];
                }
            }


            $table = array();

            $table[] = array('Report Name : ', $this->language->get('heading_title'));
            date_default_timezone_set("Asia/Kuala_Lumpur");
            $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

            $table[] = array();

            $table_header = array(
                $this->language->get('column_stock_id'),
                $this->language->get('column_customer'),
                $this->language->get('column_invoice_prefix'),
                $this->language->get('column_product_name'),
                $this->language->get('column_code'),
                $this->language->get('entry_store'),
                $this->language->get('column_product_qty'),
                $this->language->get('column_status'),
                $this->language->get('column_stock_movement'),
                $this->language->get('column_date_added'),
                $this->language->get('row_add_by')
            );

            $table[] = $table_header;

            $total_row = 0;

            $table_data = $table_collection;
            // $row;

            foreach ($table_data as $key => $data) {
                $row = array();

                foreach ($data as $key => $value) {
                    $row[] = $value;
                }
                $table[] = $row;

                $total_row++;
            }

            // Styling
            $autosize_column_index = 'A';
            foreach ($table_header as $header) {
                $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                $autosize_column_index++;
            }

            $header_index_s_column = 'A';
            $header_index_e_column = $header_index_s_column;
            foreach ($table_header as $col)
                $header_index_e_column++;
            $header_index_row = 4;
            $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

            $header_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                ),
                'font' => array(
                    'bold' => true
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

            $currency_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                ),
                'numberformat' => array(
                    'code' => "0.00"
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

            // Add Array To Excel
            $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

            // Rename worksheet
            $sheettitle = $this->language->get('heading_title');
            $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
            $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            $filename = $this->language->get('heading_title') . '_Searched';
    
            // Save Excel 2007 file
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            //ob_end_clean();
            // We'll be outputting an excel file
            header('Content-type: application/vnd.ms-excel');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
            $objWriter->save('php://output');
            }
        
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        if (isset($this->request->get['reserveds'])) {
            $reserved_ids = explode(",", $this->request->get['reserveds']);

            $reserved_info = $this->model_catalog_stock_reserved->getStockReservedItemAll();

            if (!empty($reserved_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                    $table_collection = array();
                foreach ($reserved_ids as $reserved_id) {

                $reserved_item = $this->model_catalog_stock_reserved->getStockReservedItemSelected($reserved_id);
                if (!empty($reserved_item)) {
                    foreach ($reserved_item as $item) {
                        $table_collection[] = [
                            'stock_reserved_id' => $item['stock_reserved_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }
            }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_customer'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function insertProductToDatabase()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        $json = [];
        $error = false;

        $stock_reserved_id = !empty($this->request->post['stock_reserved_id']) ? $this->request->post['stock_reserved_id'] : 0;
        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_reserved_id)) {
            $error = true;
        }

        if (empty($product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $result = $this->model_catalog_stock_reserved->addStockReservedProduct($this->request->post);

            $json['stock_reserved_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateProductToDatabase()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        $json = [];
        $error = false;

        $stock_reserved_product_id = !empty($this->request->post['stock_reserved_product_id']) ? $this->request->post['stock_reserved_product_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_reserved_product_id)) {
            $error = true;
        }

        if (empty($product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $result = $this->model_catalog_stock_reserved->editStockReservedProduct($this->request->post);

            $json['stock_reserved_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['reserve_onhand'] = !empty($result['reserve_onhand']) ? $result['reserve_onhand'] : 0;
            $json['available'] = $json['stock_onhand'] -  $json['reserve_onhand'];
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function deleteProductFromDatabase()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        $json = [];
        $error = false;

        $stock_reserved_product_id = !empty($this->request->post['stock_reserved_product_id']) ? $this->request->post['stock_reserved_product_id'] : 0;

        if (empty($stock_reserved_product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $this->model_catalog_stock_reserved->deleteStockReservedProduct($stock_reserved_product_id);
            $json['stock_reserved_product_id'] = !empty($stock_reserved_product_id) ? $stock_reserved_product_id : 0;
            $json['success'] = !empty($stock_reserved_product_id) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getDefaultLocationAndWeightClassId()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $stock_reserved_product_id = (isset($this->request->post['stock_reserved_product_id'])) ? $this->request->post['stock_reserved_product_id'] : false;

        
        if ($product_id) {
            $this->load->model('catalog/stock_reserved');
            $def_location = $this->model_catalog_stock_reserved->getLocationList($product_id);
             $def_batch_date = $this->model_catalog_stock_reserved->getBatchDateList($product_id,$def_location);
            // $def_stock_onhand = $this->model_catalog_stock_reserved->getStockOnhand($product_id);
            $def_stock_reserved = $this->model_catalog_stock_reserved->getStockReservedOnhand($product_id);
            $def_wcid = $this->model_catalog_stock_reserved->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'def_location' => $def_location,
                'def_batch_date' => $def_batch_date,
                // 'def_stock_onhand' => $def_stock_onhand,
                'def_stock_reserved' => $def_stock_reserved,
                'def_wcid' => $def_wcid,
            );
        }
        // if ($product_id) {
        //     $this->load->model('catalog/stock_reserved');
        //     $locationList = $this->model_catalog_stock_adjustment->getLocationList($product_id);
        //     $def_wcid = $this->model_catalog_stock_adjustment->getweightClassProduct($product_id);
        //     $json = array(
        //         'success' => true,
        //         'locationList' => $locationList,
        //         'def_wcid' => $def_wcid,
        //     );
        // }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getForm()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $stock_reserved_id =  empty($this->request->get['stock_reserved_id']) ? "" : $this->request->get['stock_reserved_id'];

        $data['text_form'] = !empty($brewing_form_id) ? $this->language->get('text_add') : sprintf($this->language->get('text_edit'), $stock_reserved_id);

        $data['user_token'] = $this->session->data['user_token'];

        $data['error_warning']     = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_customer_id'] = isset($this->error['customer_id']) ? $this->error['customer_id'] : '';
        $data['error_doc_no']      = isset($this->error['doc_no']) ? $this->error['doc_no'] : '';
        $data['error_doc_date']    = isset($this->error['doc_date']) ? $this->error['doc_date'] : '';
        $data['error_warning']     = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_product_id']  = isset($this->error['product_id']) ? $this->error['product_id'] : NULL;
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : NULL;
        $data['error_product_loc'] = isset($this->error['product_location']) ? $this->error['product_location'] : NULL;

        $url = '';

        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . urlencode(html_entity_decode($this->request->get['filter_doc_no'], ENT_QUOTES, 'UTF-8'));
        }
        if (isset($this->request->get['filter_doc_date'])) {
            $url .= '&filter_doc_date=' . urlencode(html_entity_decode($this->request->get['filter_doc_date'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . urlencode(html_entity_decode($this->request->get['filter_product_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . urlencode(html_entity_decode($this->request->get['filter_store_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['stock_reserved_id'])) {
            $url .= '&stock_reserved_id=' . $this->request->get['stock_reserved_id'];
        }

        if (isset($this->rquest->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->rquest->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->rquest->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true)
        ];

        if (!isset($this->request->get['stock_reserved_id'])) {
            $data['action'] = $this->url->link('catalog/stock_reserved/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('catalog/stock_reserved/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_reserved_id=' . $this->request->get['stock_reserved_id'] . $url, true);
        }

        $data['save_continue'] = $this->url->link('catalog/stock_reserved/edit', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['back'] = $this->url->link('catalog/stock_reserved', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $store_id = $this->session->data['store_id'];

        // $stock_reserved_info = [];
            if (isset($this->request->get['stock_reserved_id'])) {
                $stock_reserved_info = $this->model_catalog_stock_reserved->getStockReserved($this->request->get['stock_reserved_id']);
                $data['customer_id'] = $stock_reserved_info['customer_id'];
                $data['customer_name'] = $stock_reserved_info['customer_name'];
                $data["form_memory_doc_no"] = $stock_reserved_info['doc_no'];
                $data['stock_reserved_id'] = $this->request->get['stock_reserved_id'];
            } else {
                $data['customer_id'] = '';
                $data['customer_name'] = '';
                $data["form_memory_doc_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_reserved', 'store' => $store_id));
                $data['stock_reserved_id'] = 0;
            }
            // if (!empty($stock_reserved_info['status']) && $stock_reserved_info['status'] == 5) {
            //     $this->response->redirect($this->url->link('catalog/stock_reserved/info', 'user_token=' . $this->session->data['user_token'] . $url, true));
            // }
        

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $data["current_date"] = isset($this->request->post['date_added']) ? $this->request->post['date_added'] : date('Y-m-d');
            $form_memory_stock_reserved_product_ids = isset($this->request->post['stock_reserved_item']) ?
                $this->request->post['stock_reserved_item'] :
                array();
            $data["form_memory_stock_reserved_product_ids"] = $form_memory_stock_reserved_product_ids;
            $data['description'] = $this->request->post['description'];
      
        } elseif (!empty($stock_reserved_info)) {
            $empty_product = array(
                array(
                    'stock_reserved_product_id' => 0,
                    'name' => '',
                    'product_id' => '',
                    'code' => '',
                    'stock_onhand' => '',
                    'qty' => '',
                     'weight_class_id' => '',
                    'location_id' => '',
                    'location' => 0,
                    'reason' => '',
                    'batch_date' => '',
                )
            );
            $data["current_date"] = $stock_reserved_info['date_added'];
            $data["form_memory_stock_reserved_product_ids"] = isset($stock_reserved_info['stock_reserved_item']) ? $stock_reserved_info['stock_reserved_item'] : $empty_product;
            $data['description'] = $stock_reserved_info['description'];
            
        } else {
            $data["current_date"] = date('Y-m-d');
            $data["form_memory_stock_reserved_product_ids"] = array();
            $data['description'] = '';
        }
        
        // if (isset($this->request->get['stock_reserved_id'])) {
        //     $data['stock_reserved_id'] = $this->request->get['stock_reserved_id'];
        // } else if (!empty($stock_reserved_info['stock_reserved_id'])) {
        //     $data['stock_reserved_id'] = $stock_reserved_info['stock_reserved_id'];
        // } else {
        //     $data['stock_reserved_id'] = 0;
        // }

        // $doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_reserved', 'store' => $store_id));
        // if (isset($this->request->post['doc_no'])) {
        //     $data['doc_no'] = $this->request->post['doc_no'];
        // } else if (!empty($stock_reserved_info['doc_no'])) {
        //     $data['doc_no'] = $stock_reserved_info['doc_no'];
        // } else {
        //     $data['doc_no'] = $doc_no;
        // }

        // date_default_timezone_set("Asia/Kuala_Lumpur");
        // $doc_date  = date('Y-m-d');
        // if (isset($this->request->post['doc_date'])) {
        //     $data['doc_date'] = date('Y-m-d', strtotime($this->request->post['doc_date']));
        // } else if (!empty($stock_received_info['doc_date'])) {
        //     $data['doc_date'] = date('Y-m-d', strtotime($stock_received_info['doc_date']));
        // } else {
        //     $data['doc_date'] = $doc_date;
        // }

        // if (isset($this->request->get['customer_name'])) {
        //     $data['customer_name'] = $this->request->get['customer_name'];
        // } else if (!empty($stock_reserved_info['customer_name'])) {
        //     $data['customer_name'] = $stock_reserved_info['customer_name'];
        // } else {
        //     $data['customer_name'] = '';
        // }

        // if (isset($this->request->get['customer_id'])) {
        //     $data['customer_id'] = $this->request->get['customer_id'];
        // } else if (!empty($stock_reserved_info['customer_id'])) {
        //     $data['customer_id'] = $stock_reserved_info['customer_id'];
        // } else {
        //     $data['customer_id'] = '';
        // }

        // if (isset($this->request->post['description'])) {
        //     $data['description'] = $this->request->post['description'];
        // } else if (!empty($stock_reserved_info['description'])) {
        //     $data['description'] = $stock_reserved_info['description'];
        // } else {
        //     $data['description'] = '';
        // }

        // if (isset($this->request->post['stock_reserved_item'])) {
        //     $data['stock_reserved_item'] = $this->request->post['stock_reserved_item'];
        // } else if (!empty($stock_reserved_info['stock_reserved_item'])) {
        //     $data['stock_reserved_item'] = $stock_reserved_info['stock_reserved_item'];
        // } else {
        //     $data['stock_reserved_item'] = [];
        // }

        foreach ($data['form_memory_stock_reserved_product_ids'] as $item) {
            if (!empty($item['product_id'])) {
                $data['locations'][$item['product_id']] = $this->model_catalog_stock_reserved->getLocationList($item['product_id']);
                $data['batchDates'][$item['product_id']][$item['location_id']] = $this->model_catalog_stock_reserved->getBatchDateList($item['product_id'], $item['location_id']);
            }
        }

        $data["form_memory_current_date"] = date('Y-m-d');


        // $data['locations'] = $this->model_catalog_stock_reserved->getLocations();
        // $data['stock_leftover'] = $this->model_catalog_stock_reserved->getstock_leftover($this->request->get['']);
        $data['weight_classes'] = $this->model_catalog_stock_reserved->getWeightClasses();

        // Load Template
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_reserved_form', $data));
    }

    protected function validateForm()
    {

        // Permission
        if (!$this->user->hasPermission('modify', 'catalog/stock_reserved') && !$this->user->userpermission('modify', 'catalog/stock_reserved')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['doc_no'])) {
            $this->error['doc_no'] = $this->language->get('error_doc_no');
        } else {
            /*$doc_no_exists = $this->model_catalog_stock_reserved->checkDocNoExists($this->request->post['doc_no']);
            if (!empty($doc_no_exists)) {
                $this->error['doc_no'] = $this->language->get('error_doc_no');
            }*/
        }

        if (empty($this->request->post['doc_date'])) {
            $this->error['doc_date'] = $this->language->get('error_doc_date');
        }

        if (empty($this->request->post['customer_id'])) {
            $this->error['customer_id'] = $this->language->get('error_customer_id');
        }

        if (!empty($this->request->get['stock_reserved_id'])) {
            $stock_reserved_item = isset($this->request->post['stock_reserved_item']) ? $this->request->post['stock_reserved_item'] : false;

           

            if ($stock_reserved_item) {
           
                $products_id_list = array();
                $batch_date_list = array();
                $location_id_list = array();
               

                foreach ($stock_reserved_item as $row_id => $product) {
                    $product_id = !empty($product['product_id']) ? trim($product['product_id']) : 0;
                    $location_id = isset($product['location']) ? $product['location'] : null;
                    $batch_date = !empty($product['batch_date']) ? $product['batch_date'] : 0000-00-00 ;
                    $qty = !empty($product['qty']) ? trim($product['qty']) : 0;
                    $reserved_qty = $product['stock_reserved_onhand'];
                    $onhand_qty = $product['onhand_quantity'];
                    $available_qty = $onhand_qty - $reserved_qty;
                    // $available_qty = $product['stock_balance'];

                    if (empty($product_id)) {
                        $this->error['product_id'][$row_id] = $this->language->get('error_product');
                    } else {
                        if (in_array($product_id  , $products_id_list)) {
                            if(in_array($location_id , $location_id_list)){
                                if(in_array($batch_date , $batch_date_list)){
                                    $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                                }
                            }
                        }
                        $products_id_list[] = $product_id;
                        $batch_date_list[] = $batch_date;
                        $location_id_list[]= $location_id;
                    }

                    if (!empty($qty) && !is_numeric($qty)) {
                        $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                    }

                    

                        if ($qty <= 0) {
                            $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                        }
    
                        if ($qty > $available_qty) {
                            $this->error['product_qty'][$row_id] = $this->language->get('error_available_qty');
                        }

                    

                    

                    // if (!is_numeric($location_id)) {
                    //     $this->error['product_location'][$row_id] = $this->language->get('error_location');
                    // }
                }
            } else {
                $this->error['warning'] = $this->language->get('error_empty_stock_reserved');;
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }
        
        return !$this->error;
    }

    protected function validateDraftForm()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_reserved') && !$this->user->userpermission('modify', 'catalog/stock_reserved'))
            $this->error['warning'] = $this->language->get('error_permission');

        $stock_reserved_item = isset($this->request->post['stock_reserved_item']) ? $this->request->post['stock_reserved_item'] : false;

        if ($stock_reserved_item) {

            $products_id_list = array();

            foreach ($stock_reserved_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    // if (in_array($product_id, $products_id_list)) {
                    //     $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    // }

                    $products_id_list[] = $product_id;
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_stock_reserved');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function invoiceList()
    {
        $this->load->language('catalog/stock_reserved');
        $this->load->model('catalog/stock_reserved');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = NULL;
        }

        if (isset($this->request->get['code'])) {
            $code = $this->request->get['code'];
        } else {
            $code = NULL;
        }
        if (isset($this->request->get['product_type'])) {
            $product_type = $this->request->get['product_type'];
        } else {
            $product_type = 2;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['row_id'])) {
            $url .= '&row_id=' . $this->request->get['row_id'];
        }

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['code'])) {
            $url .= '&code=' . $this->request->get['code'];
        }

        if (isset($this->request->get['product_type'])) {
            $url .= '&product_type=' . $this->request->get['product_type'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['products'] = array();

        $filter_data = array(
            'name' => $name,
            'code' => $code,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $product_total = $this->model_catalog_stock_reserved->Totalopenperoducts($filter_data);

        $results = $this->model_catalog_stock_reserved->getopenperoducts_with_stock($filter_data);

        foreach ($results as $result) {
            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'product_name' => $result['product_name'],
                'code' => $result['code'],
                'invoice_no' => $result['invoice_prefix'],
                'order_id' => $result['order_id'],


            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $product_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('catalog/stock_reserved/invoiceList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['code'] = $code;
        $data['product_type'] = $product_type;
        $data['row_id'] = isset($this->request->get['row_id']) ? $this->request->get['row_id'] : false;
        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('sale/invoice_list', $data));
    }
    // public function printProductStickers()
    // {
    //     $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
    //     if (!empty($product_ids)) {
    //         $this->load->language('catalog/product');
    //         $this->load->model('catalog/product');
    //         $data = [];

    //         $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

    //         foreach ($product_ids as $id) {
    //             $product_info = $this->model_catalog_product->getProductByProductID($id);

    //             if (!empty($product_info)) {
    //                 $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
    //                 $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
    //                 $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

    //                 if ($type == 'qr_code') {
    //                     //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

    //                     //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
    //                     $qr_code_content = $product_info['code'];
    //                     $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
    //                 } else {
    //                     $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
    //                 }

    //                 //$content = urlencode($content);

    //                 $data['product_stickers'][] = [
    //                     'product_id' => $product_info['product_id'],
    //                     'code'         => $product_info['code'],
    //                     'model'      => $product_info['model'],
    //                     'chinese_name' => $product_info['chinese_name'],
    //                     'english_name' => $product_info['english_name'],
    //                     //'date_stock_in' => $date_stock_in,
    //                     //'date_expired' => $date_expired,
    //                     //'product_weight_sticker' => $product_weight,
    //                     'link' => $content,
    //                 ];
    //             }
    //         }

    //         $data['stickers_count'] = count($data['product_stickers']);

    //         include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

    //         $data['text_stickers'] = '';
    //         if ($type == 'qr_code') {
    //             $data['sticker_size'] = '100mm 110mm';
    //             $filename = 'barcode_sticker_' . time() . '.pdf';
    //             $data['sticker_display_size'] = 'width:60%;';
    //             $data['text_stickers'] = $this->language->get('text_barcode_sticker');
    //         } else {
    //             $filename = 'barcode_sticker_' . time() . '.pdf';
    //             $data['sticker_size'] = '100mm 80mm';
    //             $data['$sticker_display_size'] = 'width:50px;height:100px;';
    //             $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
    //         }

    //         //echo '<pre>';
    //         //print_r($data);
    //         //echo '</pre>';

    //         $mpdf = new mPDF('utf-8', 'A4');
    //         $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
    //         $mpdf->Output($filename, 'I');
    //     } else {
    //         echo "<h1>Barcode not found</h1>";
    //     }
    // }

    public function getLocationList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/stock_reserved');
            $locationList = $this->model_catalog_stock_reserved->getLocationList($product_id);
            $def_wcid = $this->model_catalog_stock_reserved->getweightClassProduct($product_id);

            if (!empty($locationList)) {
                $json = array(
                    'success'  => true,
                    'list'     => $locationList,
                    'def_wcid' => $def_wcid,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getBatchDateList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;

        if ($product_id) {
            $this->load->model('catalog/stock_reserved');
            $batchDateList = $this->model_catalog_stock_reserved->getBatchDateList($product_id, $location_id);

            if (!empty($batchDateList)) {
                $json = array(
                    'success' => true,
                    'list'    => $batchDateList,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
    protected function validateInfoDesc()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_reserved') && !$this->user->userpermission('modify', 'catalog/stock_reserved')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['description'])) {
            $this->error['description'] = $this->language->get('error_description');
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
    public function getStockOnhand()
    {
        $json = array('success' => false, 'qty' => '-', 'reserve_qty => '-' ');

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;
        $batch_date = (isset($this->request->post['batch_date'])) ? $this->request->post['batch_date'] : '0000-00-00';
        if ($product_id) {
            $this->load->model('catalog/stock_reserved');
            $stock = $this->model_catalog_stock_reserved->getStockOnhand($product_id, $location_id, $batch_date);
            $reserve = $this->model_catalog_stock_reserved->getReserveStock($product_id, $location_id, $batch_date);
            $available = $stock - $reserve;
            $json = array(
                'success' => true,
                'qty' => $stock,
                'reserve_qty' => $reserve,
                'available' => $available,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
}
