<?php

class ControllerCatalogStockReceived extends Controller
{

    private $error = array();

    public function index()
    {
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $stock_received_id = $this->model_catalog_stock_received->addStockReceived($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $url .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            if (isset($this->request->post['browser_action']))
                $url .= '&browser_action=' . $this->request->post['browser_action'];

            if (!empty($stock_received_id))
                $url .= '&stock_received_id=' . $stock_received_id;

            if (isset($this->request->post['browser_action']) && $this->request->post['browser_action'] == 'stay' && !empty($stock_received_id)) {
                $this->response->redirect($this->url->link('catalog/stock_received/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
            } else {
                $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_received->editStockReceived($this->request->get['stock_received_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $url .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            if (isset($this->request->get['stock_received_id']))
                $url .= '&stock_received_id=' . $this->request->get['stock_received_id'];

            if (isset($this->request->post['browser_action']))
                $url .= '&browser_action=' . $this->request->post['browser_action'];

            if (isset($this->request->post['browser_action']) && $this->request->post['browser_action'] == 'stay' && !empty($this->request->get['stock_received_id'])) {
                $this->response->redirect($this->url->link('catalog/stock_received/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
            } else {
                $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }

            $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function info()
    {
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateDetailForm()) {
            $this->model_catalog_stock_received->editStockReceivedDetail($this->request->get['stock_received_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $url .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            if (isset($this->request->get['stock_received_id']))
                $url .= '&stock_received_id=' . $this->request->get['stock_received_id'];

            if (isset($this->request->post['browser_action']))
                $url .= '&browser_action=' . $this->request->post['browser_action'];

            if (isset($this->request->post['browser_action']) && $this->request->post['browser_action'] == 'stay' && !empty($this->request->get['stock_received_id'])) {
                $this->response->redirect($this->url->link('catalog/stock_received/info', 'user_token=' . $this->session->data['user_token'] . $url, true));
            } else {
                $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }

            $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getInfo();
    }

    public function filter()
    {
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->post['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->post['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->post['filter_invoice_prefix'];

            if (isset($this->request->post['filter_add_by']))
                $querystring .= '&filter_add_by=' . implode(',', $this->request->post['filter_add_by']);


            if (isset($this->request->post['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->post['filter_date_from'];

            if (isset($this->request->post['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->post['filter_date_to'];

            if (isset($this->request->post['filter_status']))
                $querystring .= '&filter_status=' . implode(',', $this->request->post['filter_status']);

            if (isset($this->request->post['filter_category']))
                $querystring .= '&filter_category='  . implode(",", $this->request->post['filter_category']);

            if (isset($this->request->post['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . implode(',', $this->request->post['filter_store_id']);
            }
            if (isset($this->request->post['filter_product_id'])) {
                $querystring .= '&filter_product_id=' . $this->request->post['filter_product_id'];
            }
            if (isset($this->request->post['filter_product_name'])) {
                $querystring .= '&filter_product_name=' . $this->request->post['filter_product_name'];
            }
            if (isset($this->request->post['filter_product_code'])) {
                $querystring .= '&filter_product_code=' . $this->request->post['filter_product_code'];
            }
            if (isset($this->request->post['filter_location_id'])) {
                $querystring .= '&filter_location_id=' . implode(',', $this->request->post['filter_location_id']);
            }
            if (isset($this->request->post['filter_batch_date'])) {
                $querystring .= '&filter_batch_date=' . $this->request->post['filter_batch_date'];
            }

            $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getList();
    }

    public function getList_backup()
    {
        $filter_invoice_prefix = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $filter_batch_date = isset($this->request->get['filter_batch_date']) ? $this->request->get['filter_batch_date'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : NULL;

        $filter_store_id = isset($this->request->get['filter_store_id']) ?  explode(',', $this->request->get['filter_store_id']) : NULL;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'stock_received_product_id';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $url = '';
        $sort_url = '';

        if (isset($this->request->get['filter_invoice_prefix']))
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $url .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $url .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $url .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $url .= '&filter_category=' . $this->request->get['filter_category'];

        if (isset($this->request->get['sort']))
            $url .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['page']))
            $url .= '&page=' . $this->request->get['page'];

        $sort_url = $url;

        if (isset($this->request->get['order']))
            $url .= '&order=' . $this->request->get['order'];

        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        $data['filter'] = $this->url->link('catalog/stock_received/filter', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['add'] = $this->url->link('catalog/stock_received/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link("catalog/stock_received/delete", 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['barcode_link'] = $this->url->link('catalog/stock_received/printProductStickers', true);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $data['stock_received'] = [];

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_status' => $filter_status,
            'filter_store_id' => $filter_store_id,
            'filter_product_id' => $filter_product_id,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_location_id' => $filter_location_id,
            'filter_batch_date' => $filter_batch_date,
            'filter_status' => $filter_status,
            'filter_category' => $filter_category,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $stock_received_total = $this->model_catalog_stock_received->totalStockReceived($filter_data);

        $results = $this->model_catalog_stock_received->getStockReceivedList($filter_data);

        

        foreach ($results as $sr) {
            if ($sr['status'] == 1) {
                $label = 'warning';
            } else {
                $label = 'success';
            }

            $product_code = !empty($sr['product_code']) ? '[' . $sr['product_code'] . ']' : '';
            $product_name = !empty($sr['product_name']) ? $sr['product_name'] : $this->language->get('text_no_product');
            $product_location = !empty($sr['location']) ? $sr['location'] : $this->language->get('entry_location');

            $data['stock_received'][] = array(
                'stock_received_id' => $sr['stock_received_id'],
                'doc_no' => $sr['doc_no'],
                'product_id' => $sr['product_id'],
                'stock_adjustment_id' => $sr['stock_adjustment_id'],
                'product_name' => $product_name,
                'product_name2' => $sr['product_name2'],
                'product_description' => $sr['product_description'],
                'product_code' => $product_code,
                'quantity' => $sr['quantity'],
                'store_name' => $sr['store_name'],
                'uom' => $sr['uom'],
                'stock_onhand' => $sr['stock_onhand'],
                'stock_balance' => $sr['stock_balance'],
                'location' => $product_location,
                'description' => $sr['description'],
                'status' => $sr['status'],
                'status_label' => $label,
                'status_name' => $sr['status_name'],
                'batch_date' => $sr['batch_date'],
                'category' => $sr['category'],
                'info' => $this->url->link('catalog/stock_received/info', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'] . $url, true),
                'edit' => $this->url->link('catalog/stock_received/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'] . $url, true),
                'export' => $this->url->link('catalog/stock_received/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'], true),
                'print' => $this->url->link('catalog/stock_received/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_received_id=' . $sr['stock_received_id'], true),
                'add_by' => $sr['added_by'],
                'date_added' => date('d/m/Y', strtotime($sr['date_added'])),
                'modified_by' => $sr['modified_by'],
                'date_modified' => date('d/m/Y H:iA', strtotime($sr['date_modified'])),
            );
        }

        if ($order == 'ASC') {
            $sort_url .= '&order=DESC';
        } else {
            $sort_url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $sort_url .= '&page=' . $this->request->get['page'];
        }

        // $data['sort_invoice_prefix'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $sort_url, true);
        // $data['sort_add_by'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $sort_url, true);
        // $data['sort_date_added'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $sort_url, true);
        // $data['sort_status'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $sort_url, true);
        // $data['sort_description'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $sort_url, true);
        // $data['sort_location_id'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=location_id' . $sort_url, true);
        // $data['sort_batch_date'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $sort_url, true);
        // $data['sort_category'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $sort_url, true);
        $sort_url = '';

        if (isset($this->request->get['sort'])) {
            $sort_url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $sort_url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $sort_url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_invoice_prefix']))
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $url .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $url .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $url .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $url .= '&filter_category=' . $this->request->get['filter_category'];


        $data['user_view'] = $this->user->user_view;

        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_received->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_received->getLocations();
        }

        $data['staffs'] = $this->model_catalog_stock_received->getStaffs();
        $data['batch_dates'] = $this->model_catalog_stock_received->getAllStockReceivedBatchDates();

        $this->load->model('setting/store');
        $data['stores'] = [];
        $data['stores'][] = [
            'store_id' => 0,
            'name' => $this->config->get('config_name') . $this->language->get('text_default')
        ];
        $stores = $this->model_setting_store->getStores();
        foreach ($stores as $store) {
            $data['stores'][] = [
                'store_id' => $store['store_id'],
                'name' => $store['name']
            ];
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_received->getStatus();

        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_received->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $pagination = new Pagination();
        $pagination->total = $stock_received_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $sort_url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($stock_received_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($stock_received_total - $this->config->get('config_limit_admin'))) ? $stock_received_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $stock_received_total, ceil($stock_received_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;


        // $data['filter_invoice_prefix'] = $filter_invoice_prefix;
        // $data['filter_add_by'] = $filter_add_by;
        // $data['filter_date_from'] = $filter_date_from;
        // $data['filter_date_to'] = $filter_date_to;
        // $data['filter_status'] = $filter_status;
        // $data['filter_category'] = $filter_category;
        // $data['filter_store_id'] = $filter_store_id;
        // $data['filter_product_id'] = $filter_product_id;
        // $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";
        // $data['filter_product_code'] = $filter_product_code;
        // $data['filter_location_id'] = $filter_location_id;
        // $data['filter_batch_date'] = $filter_batch_date;

        $data['filter_invoice_prefix_memory'] = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : "";
        $data['filter_add_by'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";
        $data['filter_date_from_memory'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : "";
        $data['filter_date_to_memory'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : "";

        $data['filter_status'] = isset($this->request->get['filter_status']) ? explode(",",$this->request->get['filter_status']) : array();

        $data['filter_category'] = isset($this->request->get['filter_category']) ? explode(",",$this->request->get['filter_category']) : array();

        $data['filter_store_id'] = isset($this->request->get['filter_store_id']) ? explode(",",$this->request->get['filter_store_id']) : array();

        $data['filter_location_memory'] = isset($this->request->get['filter_location_id']) ? explode(",",$this->request->get['filter_location_id']) : array();

        $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";

        $data['filter_product_id_memory'] = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : "";

        $data['filter_product_code_memory'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : "";

        $data['filter_batch_date_to_memory'] = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : "";

        $data['filter_batch_date_from_memory'] = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : "";

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_received_list', $data));
    }

    public function getList()
    {
        $filter_invoice_prefix = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $filter_batch_date = isset($this->request->get['filter_batch_date']) ? $this->request->get['filter_batch_date'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : NULL;


        if(!empty($this->request->get['filter_store_id'])){
            $filter_store_id = explode(',', $this->request->get['filter_store_id']);
        }else{
            if(isset($this->request->get['filter_store_id']) && $this->request->get['filter_store_id'] == NULL){
                $filter_store_id = NULL;
            }elseif(isset($this->request->get['filter_store_id']) && $this->request->get['filter_store_id'] == 0){
                $filter_store_id = ['0'];
            }else{
                $filter_store_id = [$this->session->data['store_id']];
            }
        }
        
          
        // isset($this->request->get['filter_store_id']) ?  explode(',', $this->request->get['filter_store_id']) : ;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'date_modified';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_invoice_prefix']))
            $querystring .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $querystring, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_invoice_prefix'] = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : NULL;
        $data['filter_add_by'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $data['filter_date_from'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $data['filter_date_to'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        $data['filter_status'] = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : NULL;
        $data['filter_category'] = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : NULL;
        $data['filter_product_name'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $data['filter_product_id'] = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $data['filter_product_code'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $data['filter_location_id'] = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $data['filter_batch_date'] = isset($this->request->get['filter_batch_date']) ? $this->request->get['filter_batch_date'] : NULL;
        $data['filter_status'] = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : NULL;

        $data['filter_store_id'] = isset($this->request->get['filter_store_id']) ? $this->request->get['filter_store_id'] : $this->session->data['store_id'];






        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
        $querystring = '';

        if (isset($this->request->get['filter_invoice_prefix']))
            $querystring .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];


        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        // $data['sort_invoice_prefix'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystring, true);
        // $data['sort_add_by'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $querystring, true);
        // $data['sort_date_added'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystring, true);
        // $data['sort_status'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystring, true);
        // $data['sort_description'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $querystring, true);
        // $data['sort_location_id'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=location_id' . $querystring, true);
        // $data['sort_batch_date'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystring, true);
        // $data['sort_category'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystring, true);
        $querystring = '';

        if (isset($this->request->get['filter_invoice_prefix']))
            $querystring .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

        $data['filter'] = $this->url->link('catalog/stock_received/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['add'] = $this->url->link('catalog/stock_received/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/stock_received/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_status' => $filter_status,
            'filter_store_id' => $filter_store_id,
            'filter_product_id' => $filter_product_id,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_location_id' => $filter_location_id,
            'filter_batch_date' => $filter_batch_date,
            'filter_status' => $filter_status,
            'filter_category' => $filter_category,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['user_view'] = $this->user->user_view;

        //put here 
        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_received->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_received->getLocations();
        }

        $data['staffs'] = $this->model_catalog_stock_received->getStaffs();
        $data['batch_dates'] = $this->model_catalog_stock_received->getAllStockReceivedBatchDates();

        $this->load->model('setting/store');
        $data['stores'] = [];
        $data['stores'][] = [
            'store_id' => 0,
            'name' => $this->config->get('config_name') . $this->language->get('text_default')
        ];
        $stores = $this->model_setting_store->getStores();
        foreach ($stores as $store) {
            $data['stores'][] = [
                'store_id' => $store['store_id'],
                'name' => $store['name']
            ];
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_received->getStatus();

        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_received->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $data['stock_received'] = array();

        $results = $this->model_catalog_stock_received->getStockReceivedList($filter_data);

       
        foreach ($results as $sr) {
            if ($sr['status'] == 1) {
                $label = 'warning';
            } else {
                $label = 'success';
            }

            $product_code = !empty($sr['product_code']) ? '[' . $sr['product_code'] . ']' : '';
            $product_name = !empty($sr['product_name']) ? $sr['product_name'] : $this->language->get('text_no_product');
            // $product_location = !empty($sr['location']) ? $sr['location'] : $this->language->get('entry_location');

            $data['stock_received'][] = array(
                'stock_received_product_id' => $sr['stock_received_product_id'],
                'stock_received_id' => $sr['stock_received_id'],
                'doc_no' => $sr['doc_no'],
                'product_id' => $sr['product_id'],
                'stock_adjustment_id' => $sr['stock_adjustment_id'],
                'product_name' => $product_name,
                'product_name2' => $sr['product_name2'],
                'product_description' => $sr['product_description'],
                'product_code' => $product_code,
                'quantity' => $this->weight->format((float)$sr['quantity'] ? $sr['quantity'] : 0, $this->config->get('config_weight')) ,
                'store_name' => $sr['store_name'],
                'weight_class_id' => $sr['weight_class_id'],
                'uom' => $sr['uom'],
                'stock_onhand' => $this->weight->format((float)$sr['stock_onhand'] ? $sr['stock_onhand'] : 0, $this->config->get('config_weight')) ,
                'stock_balance' => $this->weight->format((float)$sr['stock_balance'] ? $sr['stock_balance'] : 0, $this->config->get('config_weight')) ,
                'location_id'   => $sr['location_id'],
                'location' => $sr['location'],
                'description' => $sr['description'],
                'status' => $sr['status'],
                'status_label' => $label,
                'status_name' => $sr['status_name'],
                'batch_date' => $sr['batch_date'],
                'category' => $sr['category'],
                'info' => $this->url->link('catalog/stock_received/info', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'] . $querystring, true),
                'edit' => $this->url->link('catalog/stock_received/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'] . $querystring, true),
                'export' => $this->url->link('catalog/stock_received/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_received_id=' . $sr['stock_received_id'], true),
                'print' => $this->url->link('catalog/stock_received/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_received_id=' . $sr['stock_received_id'], true),
                'add_by' => $sr['add_by'],
                'date_added' => date('Y-m-d', strtotime($sr['date_added'])),
                'modified_by' => $sr['modified_by'],
                'date_modified' => date('Y-m-d H:iA', strtotime($sr['date_modified'])),
            );
        }
        

        $this->load->model('service/service_form');
        $stock_received_total = $this->model_catalog_stock_received->totalStockReceived($filter_data);

        $querystring = '';
        if (isset($this->request->get['filter_invoice_prefix']))
        $querystring .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

    if (isset($this->request->get['filter_add_by']))
        $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

    if (isset($this->request->get['filter_date_from']))
        $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

    if (isset($this->request->get['filter_date_to']))
        $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

    if (isset($this->request->get['filter_status']))
        $querystring .= '&filter_status=' . $this->request->get['filter_status'];

    if (isset($this->request->get['filter_store_id']))
        $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

    if (isset($this->request->get['filter_product_name']))
        $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

    if (isset($this->request->get['filter_product_id']))
        $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

    if (isset($this->request->get['filter_product_code']))
        $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

    if (isset($this->request->get['filter_location_id']))
        $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

    if (isset($this->request->get['filter_batch_date']))
        $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
    
    if (isset($this->request->get['filter_category']))
        $querystring .= '&filter_category=' . $this->request->get['filter_category'];

         $data['barcode_link'] = $this->url->link('catalog/stock_received/printProductStickers', true);
         $data['export_all'] = $this->url->link('catalog/stock_received/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
         $data['export_searched'] = $this->url->link('catalog/stock_received/export_excel_searched', 'user_token=' . $this->session->data['user_token']. $querystring, true);

         $pagination = new Pagination();
         $pagination->total = $stock_received_total;
         $pagination->page = $page;
         $pagination->limit = $this->config->get('config_limit_admin');
         $pagination->url = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

         $data['pagination'] = $pagination->render();
 
         $data['results'] = sprintf($this->language->get('text_pagination'), ($stock_received_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($stock_received_total - $this->config->get('config_limit_admin'))) ? $stock_received_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $stock_received_total, ceil($stock_received_total / $this->config->get('config_limit_admin')));
 
         $data['sort'] = $sort;
         $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_received_list', $data));
    }

    public function getForm()
    {
        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_reason'] = isset($this->error['reason']) ? $this->error['reason'] : '';
        $data['error_products'] = isset($this->error['products']) ? $this->error['products'] : [];
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : [];
        $data['error_product_name'] = isset($this->error['product_name']) ? $this->error['product_name'] : [];
        $data['error_product_location'] = isset($this->error['product_location']) ? $this->error['product_location'] : [];

        //**URL
        $url = '';
        if (isset($this->request->get['sort']))
            $url .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $url .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $url .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_invoice_prefix']))
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

        if (isset($this->request->get['filter_add_by']))
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $url .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['stock_received_id']))
            $url .= '&stock_received_id=' . $this->request->get['stock_received_id'];

        if (isset($this->request->get['filter_product_id']))
            $url .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_name']))
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        //** Text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['stock_received_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**  Breadcrumbs
        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $action_mode = !(isset($this->request->get['stock_received_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/stock_received/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['cancel'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['print_sticker'] = $this->url->link('catalog/stock_received/printProductStickers', 'user_token=' . $this->session->data['user_token'], true);
        $data['barcode_link'] = $this->url->link('catalog/stock_received/printProductStickers', true);
        if(!empty($this->session->data['store_id'])){
            $store_id = $this->session->data['store_id'];
        }else{
            $store_id = 0;
        }

        $data['user_token'] = $this->session->data['user_token'];

        $stock_received_id = !empty($this->request->get['stock_received_id']) ? $this->request->get['stock_received_id'] : 0;
        $data['enable_add_products'] = !empty($stock_received_id) ? true : false;
        $stock_received_info = [];
        if (!empty($stock_received_id)) {
            $stock_received_info = $this->model_catalog_stock_received->getStockReceived($stock_received_id);
            if (!empty($stock_received_info['status']) && $stock_received_info['status'] == 5) {
                $this->response->redirect($this->url->link('catalog/stock_received/info', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        if (isset($this->request->get['stock_received_id'])) {
            $data['stock_received_id'] = $this->request->get['stock_received_id'];
        } else if (!empty($stock_received_info['stock_received_id'])) {
            $data['stock_received_id'] = $stock_received_info['stock_received_id'];
        } else {
            $data['stock_received_id'] = 0;
        }

        $doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_received', 'store' => $store_id));
        if (isset($this->request->post['doc_no'])) {
            $data['doc_no'] = $this->request->post['doc_no'];
        } else if (!empty($stock_received_info['doc_no'])) {
            $data['doc_no'] = $stock_received_info['doc_no'];
        } else {
            $data['doc_no'] = $doc_no;
        }

        date_default_timezone_set("Asia/Kuala_Lumpur");
        $doc_date  = date('Y-m-d');
        if (isset($this->request->post['doc_date'])) {
            $data['doc_date'] = date('Y-m-d', strtotime($this->request->post['doc_date']));
        } else if (!empty($stock_received_info['doc_date'])) {
            $data['doc_date'] = date('Y-m-d', strtotime($stock_received_info['doc_date']));
        } else {
            $data['doc_date'] = $doc_date;
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else if (!empty($stock_received_info['status'])) {
            $data['status'] = $stock_received_info['status'];
        } else {
            $data['status'] = 1;
        }

        if (isset($this->request->post['current_status'])) {
            $data['current_status'] = $this->request->post['current_status'];
        } else if (!empty($stock_received_info['status'])) {
            $data['current_status'] = $stock_received_info['status'];
        } else {
            $data['current_status'] = 0;
        }

        if (isset($this->request->post['cancelled'])) {
            $data['cancelled'] = $this->request->post['cancelled'];
        } else if (!empty($stock_received_info['reason'])) {
            $data['cancelled'] = $stock_received_info['reason'];
        } else {
            $data['cancelled'] = 0;
        }

        if (isset($this->request->post['description'])) {
            $data['description'] = $this->request->post['description'];
        } else if (!empty($stock_received_info['description'])) {
            $data['description'] = $stock_received_info['description'];
        } else {
            $data['description'] = '';
        }

        if (isset($this->request->post['stock_received_item'])) {
            $data['stock_received_items'] = $this->request->post['stock_received_item'];
        } else if (!empty($stock_received_info['stock_received_item'])) {
            $data['stock_received_items'] = $stock_received_info['stock_received_item'];
        } else {
            $data['stock_received_items'] = [];
        }

        if (isset($this->request->post['reason'])) {
            $data['reason'] = $this->request->post['reason'];
        } else if (!empty($stock_received_info['reason'])) {
            $data['reason'] = $stock_received_info['reason'];
        } else {
            $data['reason'] = '';
        }

        if (isset($this->request->post['authorized_by'])) {
            $data['authorized_by'] = $this->request->post['authorized_by'];
        } else if (!empty($stock_received_info['authorized_by'])) {
            $data['authorized_by'] = $stock_received_info['authorized_by'];
        } else {
            $data['authorized_by'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } else if (!empty($stock_received_info['remark'])) {
            $data['remark'] = $stock_received_info['remark'];
        } else {
            $data['remark'] = '';
        }

        $data['locations'] = $this->model_catalog_stock_received->getLocations();
        $data['weight_classes'] = $this->model_catalog_stock_received->getWeightClasses();
        // //Get Location List
        // $this->load->model('localisation/warehouse');
        // $locations = $this->model_localisation_warehouse->getLocations();
        // $data['locations'] = !empty($locations) ? $locations : [];

        // //Get Weight Class List
        //$this->load->model('localisation/weight_class');
        // $weight_classes = $this->model_catalog_stock_received->getWeightClasses();
        // $sort_weight_class = array_column($weight_classes, 'unit');
        // array_multisort($sort_weight_class, SORT_ASC, $weight_classes);
        // $data['weight_classes'] = $weight_classes;

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['store_id'] = $this->session->data['store_id'];


        $this->response->setOutput($this->load->view('catalog/stock_received_form', $data));
    }

    public function getInfo()
    {
        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_reason'] = isset($this->error['reason']) ? $this->error['reason'] : '';
        $data['error_products'] = isset($this->error['products']) ? $this->error['products'] : [];
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : [];
        $data['error_product_name'] = isset($this->error['product_name']) ? $this->error['product_name'] : [];
        $data['error_product_location'] = isset($this->error['product_location']) ? $this->error['product_location'] : [];

        //**URL
        $url = '';
        if (isset($this->request->get['sort']))
            $url .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $url .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $url .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_invoice_prefix']))
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

        if (isset($this->request->get['filter_add_by']))
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to']))
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $url .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['stock_received_id']))
            $url .= '&stock_received_id=' . $this->request->get['stock_received_id'];

        //** Text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['stock_received_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**  Breadcrumbs
        $data['breadcrumbs'] = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $action_mode = !(isset($this->request->get['stock_received_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link('catalog/stock_received/info', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['cancel'] = $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['print_sticker'] = $this->url->link('catalog/stock_received/printProductStickers', 'user_token=' . $this->session->data['user_token'], true);

        $store_id = $this->session->data['store_id'];
        $data['user_token'] = $this->session->data['user_token'];

        $stock_received_id = !empty($this->request->get['stock_received_id']) ? $this->request->get['stock_received_id'] : 0;
        $data['enable_add_products'] = !empty($stock_received_id) ? true : false;
        $stock_received_info = [];
        $stock_received_info = $this->model_catalog_stock_received->getStockReceived($stock_received_id);
        if (empty($stock_received_id) || empty($stock_received_info)) {
            $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        if (isset($this->request->get['stock_received_id'])) {
            $data['stock_received_id'] = $this->request->get['stock_received_id'];
        } else if (!empty($stock_received_info['stock_received_id'])) {
            $data['stock_received_id'] = $stock_received_info['stock_received_id'];
        } else {
            $data['stock_received_id'] = 0;
        }

        $doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_received', 'store' => $store_id));
        if (isset($this->request->post['doc_no'])) {
            $data['doc_no'] = $this->request->post['doc_no'];
        } else if (!empty($stock_received_info['doc_no'])) {
            $data['doc_no'] = $stock_received_info['doc_no'];
        } else {
            $data['doc_no'] = $doc_no;
        }

        date_default_timezone_set("Asia/Kuala_Lumpur");
        $doc_date  = date('Y-m-d h:i A');
        if (isset($this->request->post['doc_date'])) {
            $data['doc_date'] = $this->request->post['doc_date'];
        } else if (!empty($stock_received_info['doc_date'])) {
            $data['doc_date'] = $stock_received_info['doc_date'];
        } else {
            $data['doc_date'] = $doc_date;
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else if (!empty($stock_received_info['status'])) {
            $data['status'] = $stock_received_info['status'];
        } else {
            $data['status'] = 1;
        }

        if (isset($this->request->post['current_status'])) {
            $data['current_status'] = $this->request->post['current_status'];
        } else if (!empty($stock_received_info['status'])) {
            $data['current_status'] = $stock_received_info['status'];
        } else {
            $data['current_status'] = 0;
        }

        if (isset($this->request->post['cancelled'])) {
            $data['cancelled'] = $this->request->post['cancelled'];
        } else if (!empty($stock_received_info['reason'])) {
            $data['cancelled'] = $stock_received_info['reason'];
        } else {
            $data['cancelled'] = 0;
        }

        if (isset($this->request->post['description'])) {
            $data['description'] = $this->request->post['description'];
        } else if (!empty($stock_received_info['description'])) {
            $data['description'] = $stock_received_info['description'];
        } else {
            $data['description'] = '';
        }

        if (isset($this->request->post['stock_received_item'])) {
            $data['stock_received_items'] = $this->request->post['stock_received_item'];
        } else if (!empty($stock_received_info['stock_received_item'])) {
            $data['stock_received_items'] = $stock_received_info['stock_received_item'];
        } else {
            $data['stock_received_items'] = [];
        }

        if (isset($this->request->post['reason'])) {
            $data['reason'] = $this->request->post['reason'];
        } else if (!empty($stock_received_info['reason'])) {
            $data['reason'] = $stock_received_info['reason'];
        } else {
            $data['reason'] = '';
        }

        if (isset($this->request->post['authorized_by'])) {
            $data['authorized_by'] = $this->request->post['authorized_by'];
        } else if (!empty($stock_received_info['authorized_by'])) {
            $data['authorized_by'] = $stock_received_info['authorized_by'];
        } else {
            $data['authorized_by'] = '';
        }

        if (isset($this->request->post['store_name'])) {
            $data['store_name'] = $this->request->post['store_name'];
        } else if (!empty($stock_received_info['store_name'])) {
            $data['store_name'] = $stock_received_info['store_name'];
        } else {
            $data['store_name'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } else if (!empty($stock_received_info['remark'])) {
            $data['remark'] = $stock_received_info['remark'];
        } else {
            $data['remark'] = '';
        }

        //Get Location List
        $this->load->model('localisation/warehouse');
        $locations = $this->model_localisation_warehouse->getLocations();
        $data['locations'] = !empty($locations) ? $locations : [];

        //Get Weight Class List
        $this->load->model('localisation/weight_class');
        $weight_classes = $this->model_localisation_weight_class->getWeightClasses();
        $sort_weight_class = array_column($weight_classes, 'unit');
        array_multisort($sort_weight_class, SORT_ASC, $weight_classes);
        $data['weight_classes'] = $weight_classes;

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_received_info', $data));
    }

    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['name'])) {
            $this->load->model('catalog/stock_received');

            if (isset($this->request->get['name'])) {
                $product_name = $this->request->get['product_name'];
            } else {
                $product_name = '';
            }

            $results = $this->model_catalog_stock_transfer->getProductByName($product_name);

            foreach ($results as $result) {
                $json[] = array(
                    'product_id' => $result['product_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'code' => $result['code'],
                    'onhand_quantity' => $result['onhand_quantity']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function productAutocomplete()
    {
        $this->load->model('catalog/product');

        $json = [];
        $filter = [];
        $filter_status = false;

        if (!empty($this->request->get['name'])) {
            $filter['name'] = $this->request->get['name'];
            $filter_status = true;
        } else {
            $filter['name'] = '';
        }

        if (!empty($this->request->get['code'])) {
            $filter['code'] = $this->request->get['code'];
            $filter_status = true;
        } else {
            $filter['code'] = '';
        }

        $results = [];
        if ($filter_status) {
            $filter['start'] = 0;
            $filter['limit'] = 1;

            $results = $this->model_catalog_product->getProductForStockReceived($filter);

            foreach ($results as $result) {
                $json = [
                    'product_id' => $result['product_id'],
                    'name' =>  strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'code' => $result['code'],
                    'price' => $result['price'],
                    'costprice' => $result['costprice'],
                    'model' => $result['model'],
                    'weight_class_id' => $result['weight_class_id'],
                    'weight_title' => $result['title'],
                    'location' => (int)$result['location_id'],
                    'location_text' => $result['location_text'],
                    'onhand_quantity' => $result['onhand_quantity']
                ];
            }

            $json['success'] = !empty($json) ? true : false;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function deductItem()
    {
        $json = array('success' => false);

        $stock_received_product_id = (isset($this->request->post['stock_received_product_id'])) ? $this->request->post['stock_received_product_id'] : false;
        $remark = (isset($this->request->post['remark'])) ? $this->request->post['remark'] : false;

        if ($stock_received_product_id) {
            $this->load->model('catalog/stock_received');
            $this->model_catalog_stock_received->deductItem($stock_received_product_id, $remark);
            $json = array(
                'success' => true,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function insertProductToDatabase()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');

        $json = [];
        $error = false;
        $stock_received_id = !empty($this->request->post['stock_received_id']) ? $this->request->post['stock_received_id'] : 0;
        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_received_id)) {
            $error = true;
        }

        if (empty($product_id)) {
            $error = true;
        }

        if (empty($error)) {
            $stock_received_product_id = $this->model_catalog_stock_received->addStockReceivedProduct($this->request->post);
            $json['stock_received_id'] = !empty($stock_received_id) ? $stock_received_id : 0;
            $json['success'] = !empty($stock_received_product_id) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateProductToDatabase()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');

        $json = [];
        $error = false;
        $stock_received_product_id = !empty($this->request->post['stock_received_product_id']) ? $this->request->post['stock_received_product_id'] : 0;
        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;

        if (empty($stock_received_product_id))
            $error = true;

        if (empty($product_id))
            $error = true;

        if (empty($error)) {
            $this->model_catalog_stock_received->editStockReceivedProduct($this->request->post);
            $json['stock_received_product_id'] = !empty($stock_received_product_id) ? $stock_received_product_id : 0;
            $json['success'] = !empty($stock_received_product_id) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        $data['product_stickers'] = [];
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);
                    $data['product_stickers'][] = [
                        'product_id'   => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'        => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function printForm(){
        
        $this->load->language('catalog/stock_received');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_received');

        if (isset($this->request->get['stock_received_id'])) {
            $stock_received_id = $this->request->get['stock_received_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_received_info = [];
            $stock_received_info = $this->model_catalog_stock_received->getStockReceived($stock_received_id);

            $data['stock_received_item'] = [];

            if (!empty($stock_received_info)) {
                $stock_received_products = $this->model_catalog_stock_received->getStockReceivedProducts($stock_received_id);
                //load default language
            $this->load->language('catalog/stock_received');

            //set document title
            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

                $data['doc_no'] = $stock_received_info['doc_no'];
                $data['date_added'] = $stock_received_info['date_added'];
                $data['added_by'] = $stock_received_info['added_by'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_received_info['description'])) {
                    $data['description'] = $stock_received_info['description'];
                } else {
                    $data['description'] = '';
                }

                $stock_received_item = $stock_received_info['stock_received_item'];


                    if (!empty($stock_received_products)) {
                        foreach ($stock_received_products as $product) {
                            $data['stock_received_item'][] = [
                                'name' => $product['name'],
                                'product_name2' => $product['product_name2'],
                                'product_code' => $product['code'],
                                'qty' => $product['qty'],
                                'category' => $product['category'],
                                'batch_date' => $product['batch_date'],
                                'location' => $product['location'],
                                'unit' => $product['unit'],
                                'stock_onhand' => $product['stock_onhand'],
                                'stock_balance' => $product['stock_balance'],
                                'date_modified' => date('d/m/Y', strtotime($product['date_modified'])),
                                'modified_by' => $product['modified_by'],
                                'description' => $product['description'],
                                'added_by' => $product['added_by']
                            ];
                        }
                    }
                

                if (isset($this->request->get['pdf'])) {
                    $pdf = new PDF();
                    $page_size ='a4';
                    $pdf_file_name = $stock_received_info['doc_no'] . '.pdf';
    
                    $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_received_print', $data), $pdf_file_name, $page_size));
                }
                else {
                    $this->response->setOutput($this->load->view('catalog/stock_received_print', $data));
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_received', 'user_token=' . $this->session->data['user_token'], true));
        }

       
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');


            $received_info = $this->model_catalog_stock_received->getStockReceivedItemAll();

            if (!empty($received_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $received_item = $this->model_catalog_stock_received->getStockReceivedItemAll();

                $table_collection = array();

                if (!empty($received_item)) {
                    foreach ($received_item as $item) {
                        $table_collection[] = [
                            'stock_received_id' => $item['stock_received_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'location' => $item['location']. " (Batch Date: ".$item['batch_date']. ") ",
                            'quantity' => $item['quantity']. " " .$item['uom'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['uom'] . " => " . $item['stock_balance'] . $item['uom'],
                            'date_added' => $item['date_added'],
                            'added_by' => $item['added_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_location'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');

        $filter_invoice_prefix = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $filter_batch_date = isset($this->request->get['filter_batch_date']) ? $this->request->get['filter_batch_date'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : NULL;

        $filter_store_id = isset($this->request->get['filter_store_id']) ?  explode(',', $this->request->get['filter_store_id']) : NULL;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'date_modified';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_invoice_prefix']))
            $querystring .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_id']))
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_batch_date']))
            $querystring .= '&filter_batch_date=' . $this->request->get['filter_batch_date'];
        
        if (isset($this->request->get['filter_category']))
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];

            $filter_data = array(
                'filter_invoice_prefix' => $filter_invoice_prefix,
                'filter_add_by' => $filter_add_by,
                'filter_date_from' => $filter_date_from,
                'filter_date_to' => $filter_date_to,
                'filter_status' => $filter_status,
                'filter_store_id' => $filter_store_id,
                'filter_product_id' => $filter_product_id,
                'filter_product_name' => $filter_product_name,
                'filter_product_code' => $filter_product_code,
                'filter_location_id' => $filter_location_id,
                'filter_batch_date' => $filter_batch_date,
                'filter_status' => $filter_status,
                'filter_category' => $filter_category
            );

            $received_info = $this->model_catalog_stock_received->getStockReceivedItemAll();

            if (!empty($received_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $received_item = $this->model_catalog_stock_received->getStockReceivedItemSearched($filter_data);

                $table_collection = array();

                if (!empty($received_item)) {
                    foreach ($received_item as $item) {
                        $table_collection[] = [
                            'stock_received_id' => $item['stock_received_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'location' => $item['location']. " (Batch Date: ".$item['batch_date']. ") ",
                            'quantity' => $item['quantity']. " " .$item['uom'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['uom'] . " => " . $item['stock_balance'] . $item['uom'],
                            'date_added' => $item['date_added'],
                            'added_by' => $item['added_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_location'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');

        if (isset($this->request->get['receives'])) {
            $receive_ids = explode(",", $this->request->get['receives']);

            $received_info = $this->model_catalog_stock_received->getStockReceivedItemAll();

            if (!empty($received_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                    $table_collection = array();

                foreach ($receive_ids as $receive_id) {
                    $received_item = $this->model_catalog_stock_received->getStockReceivedItemSelected($receive_id);

                    if (!empty($received_item)) {
                        foreach ($received_item as $item) {
                            $table_collection[] = [
                                'stock_received_id' => $item['stock_received_id'],
                                'doc_no' => $item['doc_no'],
                                'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                                'product_code' => $item['product_code'],
                                'location' => $item['location']. " (Batch Date: ".$item['batch_date']. ") ",
                                'quantity' => $item['quantity']. " " .$item['uom'],
                                'status_name' => $item['status_name'],
                                'stock_onhand' => $item['stock_onhand'] . $item['uom'] . " => " . $item['stock_balance'] . $item['uom'],
                                'date_added' => $item['date_added'],
                                'added_by' => $item['added_by']
                            ];
                        }
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_location'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function exportExcel()
    {
        $this->load->language('catalog/stock_received');
        $this->load->model('catalog/stock_received');

        if (isset($this->request->get['stock_received_id'])) {
            $stock_received_id = $this->request->get['stock_received_id'];

            $sa_info = $this->model_catalog_stock_received->getStockAdjustment($stock_received_id);

            if (!empty($sa_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_received_item = $sa_info['stock_received_item'];

                $table_collection = array();

                if (!empty($stock_received_item)) {
                    foreach ($stock_received_item as $product_id => $item) {
                        $action = ($item['action'] > 0) ? $this->language->get('text_qty_add') : $this->language->get('text_qty_deduct');

                        $table_collection[] = [
                            'product_id' => $product_id,
                            'product_name' => $item['name'],
                            'product_code' => $item['code'],
                            'action' => $action,
                            'qty' => $item['qty']
                        ];
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Invoice Prefix : ', $sa_info['invoice_prefix']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $sa_info['description']);
                $table[] = array('Date : ', $sa_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_action'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $sa_info['invoice_prefix'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function getProductList()
    {
        $this->load->language('openwindow/material');
        $this->load->model('catalog/stock_received');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = NULL;
        }

        if (isset($this->request->get['code'])) {
            $code = $this->request->get['code'];
        } else {
            $code = NULL;
        }
        if (isset($this->request->get['product_type'])) {
            $product_type = $this->request->get['product_type'];
        } else {
            $product_type = 2;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';
        if (isset($this->request->get['row_id'])) {
            $url .= '&row_id=' . $this->request->get['row_id'];
        }

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['code'])) {
            $url .= '&code=' . $this->request->get['code'];
        }

        if (isset($this->request->get['product_type'])) {
            $url .= '&product_type=' . $this->request->get['product_type'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['user_token'] = $this->session->data['user_token'];
        $data['products'] = array();
        $filter_data = array(
            'name' => $name,
            'code' => $code,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $product_total = $this->model_catalog_stock_received->getTotalProductForStockReceived($filter_data);
        $results = $this->model_catalog_stock_received->getProductForStockReceived($filter_data);
        foreach ($results as $result) {
            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'name' => $result['name'],
                'code' => $result['code'],
                'price' => $result['price'],
                'costprice' => $result['costprice'],
                'model' => $result['model'],
                'weight_class_id' => $result['weight_class_id'],
                'weight_title' => $result['title'],
                'location' => (int)$result['location_id'],
                'location_text' => $result['location_text'],
                'onhand_quantity' => $result['onhand_quantity']
            );
        }

        $pagination = new Pagination();
        $pagination->total = $product_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('catalog/product/materialStockList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['code'] = $code;
        $data['product_type'] = $product_type;
        $data['row_id'] = isset($this->request->get['row_id']) ? $this->request->get['row_id'] : false;
        $data['header'] = $this->load->controller('common/header/pop_header');
        $data['store_id'] = $this->session->data['store_id'];

        $this->response->setOutput($this->load->view('openwindow/stock_received_product_list', $data));
    }

    public function getModalProductList()
    {
        $this->load->language('openwindow/material');
        $this->load->model('catalog/stock_received');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = NULL;
        }

        if (isset($this->request->get['code'])) {
            $code = $this->request->get['code'];
        } else {
            $code = NULL;
        }
        if (isset($this->request->get['product_type'])) {
            $product_type = $this->request->get['product_type'];
        } else {
            $product_type = 2;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';
        if (isset($this->request->get['row_id'])) {
            $url .= '&row_id=' . $this->request->get['row_id'];
        }

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['code'])) {
            $url .= '&code=' . $this->request->get['code'];
        }

        if (isset($this->request->get['product_type'])) {
            $url .= '&product_type=' . $this->request->get['product_type'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['user_token'] = $this->session->data['user_token'];
        $data['products'] = array();
        $filter_data = array(
            'name' => $name,
            'code' => $code,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $product_total = $this->model_catalog_stock_received->getTotalProductForStockReceived($filter_data);
        $results = $this->model_catalog_stock_received->getProductForStockReceived($filter_data);
        foreach ($results as $result) {
            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'name' => $result['name'],
                'code' => $result['code'],
                'price' => $result['price'],
                'costprice' => $result['costprice'],
                'model' => $result['model'],
                'weight_class_id' => $result['weight_class_id'],
                'weight_title' => $result['title'],
                'location' => (int)$result['location_id'],
                'location_text' => $result['location_text'],
                'onhand_quantity' => $result['onhand_quantity']
            );
        }

        $pagination = new Pagination();
        $pagination->total = $product_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('catalog/product/materialStockList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['code'] = $code;
        $data['product_type'] = $product_type;
        $data['row_id'] = isset($this->request->get['row_id']) ? $this->request->get['row_id'] : false;
        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/stock_received_product_list2', $data));
    }

    public function getDefaultLocationAndWeightClassId() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/stock_received');
            $def_location = $this->model_catalog_stock_received->getDefaultLocation($product_id);
            $def_wcid = $this->model_catalog_stock_received->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'def_location' => $def_location,
                'def_wcid' => $def_wcid,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    protected function validateForm()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_received') && !$this->user->userpermission('modify', 'catalog/stock_received')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['doc_no'])) {
            $this->error['doc_no'] = $this->language->get('error_doc_no');
        }

        if (empty($this->request->post['doc_date'])) {
            $this->error['doc_date'] = $this->language->get('error_doc_date');
        }

        if (!empty($this->request->post['cancelled'])) {
            if (empty($this->request->post['reason'])) {
                $this->error['reason'] = $this->language->get('error_reason');
            }
        }

        if (!empty($this->request->get['stock_received_id'])) {
            $stock_received_item = isset($this->request->post['stock_received_item']) ? $this->request->post['stock_received_item'] : [];
            if (!empty($stock_received_item)) {
                foreach ($stock_received_item as $row_id => $product) {
                    $error_product_qty = '';
                    if (empty($product['product_id'])) {
                        $this->error['products'][$row_id] = $this->language->get('error_product');
                    }

                    if (empty($product['code'])) {
                        $this->error['products'][$row_id] = $this->language->get('error_product');
                    }

                    if (empty($product['name'])) {
                        $this->error['product_name'][$row_id] = $this->language->get('error_product_name');
                    }

                    if (empty((float)$product['qty'])) {
                        $error_product_qty = $this->language->get('error_product_qty');
                    }

                    if (empty($product['weight_class_id'])) {
                        $error_product_qty .= $this->language->get('error_product_weight_class');
                    }

                    if (!empty($error_product_qty)) {
                        $this->error['product_qty'][$row_id] = $error_product_qty;
                    }
                }
            } else {
                if (!empty($this->request->post['status']) && $this->request->post['status'] == 5) {
                    $this->error['warning'] = $this->language->get('error_empty_stock_received');;
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDetailForm()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_received') && !$this->user->userpermission('modify', 'catalog/stock_received')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['doc_no'])) {
            $this->error['doc_no'] = $this->language->get('error_doc_no');
        }

        if (empty($this->request->post['doc_date'])) {
            $this->error['doc_date'] = $this->language->get('error_doc_date');
        }

        if (!empty($this->request->post['cancelled'])) {
            if (empty($this->request->post['reason'])) {
                $this->error['reason'] = $this->language->get('error_reason');
            }
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('delete', 'catalog/stock_received') && !$this->user->userpermission('delete', 'catalog/stock_received')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    private function install()
    {
    }

    private function uninstall()
    {
    }
}
