<?php
class ControllerCatalogProductionPackaging extends Controller {
    private $error = [];

    public function index() {
        $this->load->language('catalog/production_packaging');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_packaging');

        $this->getList();
    }

    public function add() {
        $this->load->language('catalog/production_packaging');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_packaging');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $packaging_id = $this->model_catalog_production_packaging->addProductionPackaging($this->request->post);

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }
    
            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }
    
            if (isset($this->request->get['filter_description'])) {
                $url .= '&filter_description=' . $this->request->get['filter_description'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->session->data['success'] = $this->language->get('text_success');
            
            $this->response->redirect($this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('catalog/production_packaging');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_packaging');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_production_packaging->editProductionPackaging($this->request->post, $this->request->get['packaging_id']);

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }
    
            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }
    
            if (isset($this->request->get['filter_description'])) {
                $url .= '&filter_description=' . $this->request->get['filter_description'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->session->data['success'] = $this->language->get('text_success');
            
            $this->response->redirect($this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('catalog/production_packaging');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_packaging');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $packaging_id) {
				$this->model_catalog_production_packaging->deleteProductionPackaging($packaging_id);
            }
            
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }
    
            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }
    
            if (isset($this->request->get['filter_description'])) {
                $url .= '&filter_description=' . $this->request->get['filter_description'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function print_sticker() {
        $this->load->language('catalog/production_packaging');
        
        $this->load->model('catalog/production_packaging');
        $this->load->model('catalog/production');

        if (isset($this->request->post['selected'])){
            $production_packagings = $this->request->post['selected'];

            $data['production_packaging_stickers'] = [];

            foreach ($production_packagings as $packaging_id) {
                $packaging_items_arr = [];
                $packaging_qty_arr = [];

                $packaging_info = $this->model_catalog_production_packaging->getProductionPackaging($packaging_id);

                if (!empty($packaging_info)) {
                    $packaging_materials = $packaging_info['materials'];

                    if (!empty($packaging_materials)) {
                        foreach ($packaging_materials as $material) {
                            $packaging_qty_arr[$material['packaging_material_id']] = $material['quantity'];
                        }
                    }
                }

                $serial_num_packaging_material_id = array_search(max($packaging_qty_arr), $packaging_qty_arr);

                $packaging_material_row = $this->model_catalog_production_packaging->getPackagingMaterial($serial_num_packaging_material_id);

                if (!empty($packaging_material_row)) {
                    foreach ($packaging_qty_arr as $packaging_material_id => $material) {
                        $material_production_info = $this->model_catalog_production_packaging->getPackagingMaterial($packaging_material_id);

                        if (!empty($material_production_info)) {
                            $production_details = $this->model_catalog_production->getProduction($material_production_info['production_id']);

                            if (!empty($production_details)) {
                                $product_name = $production_details['product_name'];

                                $packaging_items_arr[$material] = $material . ' ' . $product_name;
                            }
                        }
                    }

                    krsort($packaging_items_arr);

                    $production_info = $this->model_catalog_production->getProduction($packaging_material_row['production_id']);

                    if (!empty($production_info)) {
                        $qr_code_content = 'packaging_' . $packaging_id;
                        $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . base64_encode($qr_code_content) . '&choe=UTF-8';

                        $data['production_packaging_stickers'][] = [
                            'product_list'          => implode(' + ', $packaging_items_arr),
                            'expiry_date'           => date('j M Y', strtotime($production_info['expiry_date'])),
                            'serial_num'            => $production_info['serial_num'],
                            'qr_code'               => $qr_code
                        ];
                    }
                }             
            }       

            $data['num'] = count($data['production_packaging_stickers']);

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $filename = $this->language->get('text_pdf_production_packaging_sticker') . '.pdf';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/production_packaging_sticker', $data));
            $mpdf->Output($filename, 'I');
        }
    }

    protected function getList() {
        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = '';
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = '';
        }

        if (isset($this->request->get['filter_description'])) {
            $filter_description = $this->request->get['filter_description'];
        } else {
            $filter_description = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = NULL;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . $this->request->get['filter_description'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['production_packagings'] = [];

        $filter_data = array(
            'filter_date_added_from'        => $filter_date_added_from,
            'filter_date_added_to'          => $filter_date_added_to,
            'filter_description'            => $filter_description,
            'filter_status'                 => $filter_status,
            'sort'                          => $sort,
            'order'                         => $order,
            'start'                         => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                         => $this->config->get('config_limit_admin')
        );

        $results = $this->model_catalog_production_packaging->getProductionPackagings($filter_data);
        $total_production_packagings = $this->model_catalog_production_packaging->getTotalProductionPackagings($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['production_packagings'][] = [
                    'packaging_id'      => $result['packaging_id'],
                    'description'       => nl2br($result['description']),
                    'status'            => ($result['status'] == '1') ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                    'date_added'        => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'edit'              => $this->url->link('catalog/production_packaging/edit', 'user_token=' . $this->session->data['user_token'] . '&packaging_id=' . $result['packaging_id'], true)
                ];
            }
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        
        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }
        
        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . $this->request->get['filter_description'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_description'] = $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true);
        $data['sort_status'] = $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_date_added'] = $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['print_sticker'] = $this->url->link('catalog/production_packaging/print_sticker', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete'] = htmlspecialchars_decode($this->url->link('catalog/production_packaging/delete', 'user_token=' . $this->session->data['user_token'], true));
        $data['add'] = $this->url->link('catalog/production_packaging/add', 'user_token=' . $this->session->data['user_token'], true);

        $pagination = new Pagination();
        $pagination->total = $total_production_packagings;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_production_packagings) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_production_packagings - $this->config->get('config_limit_admin'))) ? $total_production_packagings : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_production_packagings, ceil($total_production_packagings / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_date_added_from'] = $filter_date_added_from;
        $data['filter_date_added_to'] = $filter_date_added_to;
        $data['filter_description'] = $filter_description;
        $data['filter_status'] = $filter_status;

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_packaging_list', $data));
    }

    protected function getForm() {
        $data['text_form'] = isset($this->request->get['packaging_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        if (!isset($this->request->get['packaging_id'])) {
			$data['text_form'] = $this->language->get('text_add');
			
            $data['action'] = $this->url->link('catalog/production_packaging/add', 'user_token=' . $this->session->data['user_token'], true);
        } else {
			$data['text_form'] = $this->language->get('text_edit');
			
            $packaging_id = $this->request->get['packaging_id'];

            $data['action'] = $this->url->link('catalog/production_packaging/edit', 'user_token=' . $this->session->data['user_token'] . '&packaging_id=' . $packaging_id, true);

            $production_packaging_info = $this->model_catalog_production_packaging->getProductionPackaging($packaging_id);
        }
        
        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $error_arr = ['warning', 'description'];

        foreach ($error_arr as $error) {
            if (isset($this->error[$error])) {
                $data['error_' . $error] = $this->error[$error];
            } else {
                $data['error_' . $error] = '';
            }
        }

        if (isset($this->error['material_serial_num'])) {
            $data['error_material_serial_num'] = $this->error['material_serial_num'];
        } else {
            $data['error_material_serial_num'] = [];
        }

        if (isset($this->error['material_quantity'])) {
            $data['error_material_quantity'] = $this->error['material_quantity'];
        } else {
            $data['error_material_quantity'] = [];
        }

        if (isset($this->request->post['description'])) {
            $data['description'] = $this->request->post['description'];
        } elseif (!empty($production_packaging_info)) {
            $data['description'] = $production_packaging_info['description'];  
        } else {
            $data['description'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($production_packaging_info)) {
            $data['status'] = $production_packaging_info['status'];  
        } else {
            $data['status'] = 1;
        }

        if (isset($this->request->post['materials'])) {
            $data['materials'] = $this->request->post['materials'];
        } elseif (!empty($production_packaging_info)) {
            $data['materials'] = $production_packaging_info['materials'];  
        } else {
            $data['materials'] = [];
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['cancel'] = $this->url->link('catalog/production_packaging', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_packaging_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'catalog/production_packaging')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['description'])) {
            $this->error['description'] = $this->language->get('error_description');
        }

        if (isset($this->request->post['materials'])) {
            foreach ($this->request->post['materials'] as $index => $material) {
                if (empty($material['production_id'])) {
                    $this->error['material_serial_num'][$index] = $this->language->get('error_material_serial_num');
                }

                if (empty($material['quantity']) && !is_int($material['quantity'])) {
                    $this->error['material_quantity'][$index] = $this->language->get('error_material_quantity');
                }
            }
        }
        
        if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
    }

    protected function validateDelete(){
		if (!$this->user->hasPermission('modify', 'catalog/production_packaging')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}
?>