<?php
class ControllerCatalogProduction extends Controller {
    private $error = [];
    private $total_round_num = 5;
    private $status_arr = [1, 7, 5];

    public function index() {
        $this->load->language('catalog/production');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production');
        $this->load->model('localisation/order_status');

        $this->getList();
    }

    public function add() {
        $this->load->language('catalog/production');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $production_id = $this->model_catalog_production->addProduction($this->request->post);

            if ($this->request->post['status'] == '5') {
                // deduct stock
                if (isset($this->request->post['production_stock'])) {
                    $this->model_catalog_production->deductProductionStock($production_id, $this->request->post['production_stock']);
                    $this->model_catalog_production->addProductionStock($production_id, $this->request->post);
                }
            }

            $url = '';

            if (isset($this->request->get['filter_production_date_from'])) {
                $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
            }
    
            if (isset($this->request->get['filter_production_date_to'])) {
                $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
            }
    
            if (isset($this->request->get['filter_expiry_date_from'])) {
                $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
            }
    
            if (isset($this->request->get['filter_expiry_date_to'])) {
                $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }
    
            if (isset($this->request->get['filter_serial_num'])) {
                $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
            }

            if (isset($this->request->get['filter_product_name'])) {
                $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
            }    
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }  

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->session->data['success'] = $this->language->get('text_success');
            
            $this->response->redirect($this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('catalog/production');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_production->editProduction($this->request->post, $this->request->get['production_id']);

            if ($this->request->post['status'] == '5') {
                // deduct stock
                if (isset($this->request->post['production_stock'])) {
                    $this->model_catalog_production->deductProductionStock($this->request->get['production_id'], $this->request->post['production_stock']);
                    $this->model_catalog_production->addProductionStock($this->request->get['production_id'], $this->request->post);
                }
            }

            $url = '';

            if (isset($this->request->get['filter_production_date_from'])) {
                $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
            }
    
            if (isset($this->request->get['filter_production_date_to'])) {
                $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
            }
    
            if (isset($this->request->get['filter_expiry_date_from'])) {
                $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
            }
    
            if (isset($this->request->get['filter_expiry_date_to'])) {
                $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }
    
            if (isset($this->request->get['filter_serial_num'])) {
                $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
            }

            if (isset($this->request->get['filter_product_name'])) {
                $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
            }    

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }  
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->session->data['success'] = $this->language->get('text_success');
            
            $this->response->redirect($this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function manage_qc() {
        $this->load->language('catalog/production');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production');
        $this->load->model('localisation/order_status');

        $this->getQcForm();
    }

    public function info() {
        $this->load->language('catalog/production');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production');
        $this->load->model('localisation/order_status');

        $url = '';

        if (isset($this->request->get['filter_production_date_from'])) {
            $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
            $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }    

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }    

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['production_id'])) {
            $this->response->redirect($this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'], true));
        } else {
            $production_id = $this->request->get['production_id'];

            $production_info = $this->model_catalog_production->getProduction($production_id);
            $production_histories = $this->model_catalog_production->getProductionQc($production_id);

            $data['qc_histories'] = [];
            $data['total_reject_quantity'] = 0;
        
            if (!empty($production_histories)) {
                foreach ($production_histories as $history) {
                    $data['qc_histories'][] = [
                        'reason_reject'         => $history['reason_reject'],
                        'reject_quantity'       => $history['reject_quantity'],
                        'date_added'            => date($this->language->get('date_format_short'), strtotime($history['date_added']))
                    ];

                    $data['total_reject_quantity'] += $history['reject_quantity'];
                }
            }

            if (!empty($production_info)) {
                $production_stocks = $this->model_catalog_production->getProductionStocks($production_id);

                if (!empty($production_stocks)) {
                    foreach ($production_stocks as $index => $stock) {
                        $production_stocks[$index]['expected_quantity'] = $production_info['quantity'];
                    }
                }
                
                $status_info = $this->model_localisation_order_status->getOrderStatus($production_info['status']);
                $status_name = !empty($status_info) ? $status_info['name'] : '';

                $machine_info = $this->model_catalog_production->getProductionMachine($production_info['machine_num']);
                $machine_num = !empty($machine_info) ? $machine_info['machine_name'] : '';
                
                $data['production_info'] = [
                    'invoice_prefix'        => $production_info['invoice_prefix'],
                    'serial_num'            => $production_info['serial_num'],
                    'production_date'       => date($this->language->get('date_format_short'), strtotime($production_info['production_date'])),
                    'expiry_date'           => date($this->language->get('date_format_short'), strtotime($production_info['expiry_date'])),
                    'product_name'          => $production_info['product_name'],
                    'quantity'              => $production_info['quantity'],
                    'actual_quantity'       => $production_info['actual_quantity'],
                    'reject_quantity'       => $data['total_reject_quantity'],
                    'quantity_left'         => $production_info['actual_quantity'] - $data['total_reject_quantity'],
                    'machine_num'           => $machine_num,
                    'round_num'             => $this->language->get('text_round') . ' ' . $production_info['round_num'],
                    'remark'                => nl2br($production_info['remark']),
                    'status'                => $production_info['status'],
                    'status_name'           => $status_name,
                    'production_stock'      => $production_stocks
                ];
            }
        }

        $data['cancel'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'], true);
        
        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_info', $data));
    }

    public function print_sticker() {
        $this->load->language('catalog/production');
        
        $this->load->model('catalog/production');

        if (isset($this->request->post['selected'])){
            $productions = $this->request->post['selected'];

            $data['production_stickers'] = [];

            foreach ($productions as $production_id) {
                $production_info = $this->model_catalog_production->getProduction($production_id);

                if (!empty($production_info)) {
                    $quantity = $production_info['actual_quantity'];

                    for ($i = 1; $i <= $quantity; $i++) {
                        $qr_code = 'https://chart.apis.google.com/chart?chs=100x100&cht=qr&chl=' . $production_info['serial_num'] . '&choe=UTF-8';

                        $data['production_stickers'][] = [
                            'serial_num'        => $production_info['serial_num'],
                            'qr_code'           => $qr_code,
                            'expiry_date'       => date('j M Y', strtotime($production_info['expiry_date']))
                        ];
                    }                    
                }
            }

            $data['num'] = count($data['production_stickers']);

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $filename = $this->language->get('text_pdf_production_sticker') . '.pdf';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/production_sticker', $data));
            $mpdf->Output($filename, 'I');
        }
    }

    public function get_serial_num() {
        $json = [];

        $production_date = !empty($this->request->post['production_date']) ? $this->request->post['production_date'] : false;
        $serial_num_prefix = !empty($this->request->post['serial_num_prefix']) ? $this->request->post['serial_num_prefix'] : false;
        $machine_num = isset($this->request->post['machine_num']) ? $this->request->post['machine_num'] : false;
        $round_num = isset($this->request->post['round_num']) ? $this->request->post['round_num'] : false;

        if ($production_date && $serial_num_prefix && $machine_num && $round_num) {
            $work_week = $this->week_of_the_month($production_date);

            $serial_num = $serial_num_prefix . date('ymd', strtotime($production_date)) . $work_week . $machine_num . $round_num;

            $json = [
                'error'     => false,
                'data'      => $serial_num,
                'message'   => 'get serial num success'
            ];
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function get_product_material_stock() {
        $json = [];
        $return_product_materials = [];

        $this->load->model('catalog/production');

        $production_id = isset($this->request->post['production_id']) ? $this->request->post['production_id'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;
        $quantity = isset($this->request->post['quantity']) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $production_stocks = ($production_id > 0) ? $this->model_catalog_production->getProductionStocks($production_id) : [];
            $product_materials = $this->model_catalog_production->getProductMaterials($product_id);

            $got_production_stock = !empty($production_stocks) ? true : false;

            if ($got_production_stock) {
                foreach ($production_stocks as $stock) {
                    $material_stock_info = $this->model_catalog_production->getProductStock($stock['product_id']);

                    if (!empty($material_stock_info)) {
                        $return_product_materials[] = [
                            'product_id'        => $stock['product_id'],
                            'product_name'      => $stock['product_name'],
                            'product_code'      => $stock['product_code'],
                            'used_quantity'     => $stock['used_quantity'],
                            'stock'             => $material_stock_info['onhand_quantity'],
                            'expected_quantity' => $quantity,
                            'total_quantity'    => $quantity * $stock['used_quantity']
                        ];
                    }                    
                }

            } else {
                if (!empty($product_materials)) {
                    foreach ($product_materials as $material) {
                        $material_stock_info = $this->model_catalog_production->getProductStock($material['metarial_id']);
    
                        if (!empty($material_stock_info)) {
                            $return_product_materials[] = [
                                'product_id'        => $material['metarial_id'],
                                'product_name'      => $material['material_name'],
                                'product_code'      => $material['product_code'],
                                'used_quantity'     => $material['used_quantity'],
                                'stock'             => $material_stock_info['onhand_quantity'],
                                'expected_quantity' => $quantity,
                                'total_quantity'    => $quantity * $material['used_quantity']
                            ];
                        }
                    }
                }
            }

            if (!empty($return_product_materials)) {
                $json = [
                    'error'                     => false,
                    'got_production_stock'      => $got_production_stock,
                    'data'                      => $return_product_materials,
                    'message'                   => 'get material stock success'
                ];
            } else {
                $json = [
                    'error'     => true,
                    'message'   => 'material stock not found'
                ];    
            }
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }
        
        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function load_qc_histories() {
        $json = [];
        $return_production_qc = [];
        $return_data = [];

        $total_reject_quantity = 0;

        $this->load->model('catalog/production');

        if (isset($this->request->post['production_id'])) {
            $production_id = $this->request->post['production_id'];

            $production_qc = $this->model_catalog_production->getProductionQc($production_id);

            if (!empty($production_qc)) {
                foreach ($production_qc as $qc) {
                    $return_production_qc[] = [
                        'reject_quantity'       => $qc['reject_quantity'],
                        'reason_reject'         => $qc['reason_reject'],
                        'date_added'            => date($this->language->get('date_format_short'), strtotime($qc['date_added']))
                    ];

                    $total_reject_quantity += $qc['reject_quantity'];
                }
            }

            $return_data = [
                'histories'                 => $return_production_qc,
                'total_reject_quantity'     => $total_reject_quantity
            ];

            $json = [
                'error'     => false,
                'data'      => $return_data,
                'message'   => 'get production qc success'
            ];
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function add_qc() {
        $json = [];

        $this->load->language('catalog/production');
        $this->load->model('catalog/production');

        $production_id = isset($this->request->post['production_id']) ? $this->request->post['production_id'] : false;
        $reject_quantity = (isset($this->request->post['reject_quantity']) && is_numeric($this->request->post['reject_quantity'])) ? (int)$this->request->post['reject_quantity'] : false;
        $reason_reject = !empty($this->request->post['reason_reject']) ? $this->request->post['reason_reject'] : '';

        if ($production_id && $reject_quantity) {
            $post_data = [
                'production_id'     => $production_id,
                'reject_quantity'   => $reject_quantity,
                'reason_reject'     => $reason_reject
            ];

            $production_qc_id = $this->model_catalog_production->addQualityControl($post_data);

            if ($production_qc_id > 0) {
                $json = [
                    'error'         => false,
                    'message'       => 'add quality control success'
                ];
            }
        } else {
            $json = [
                'error'                     => true,
                'error_reject_quantity'     => $this->language->get('error_reject_quantity')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));        
    }

    public function productionList() {
        $this->load->language('openwindow/production');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('catalog/production');

        if (isset($this->request->get['filter_serial_num'])) {
			$filter_serial_num = $this->request->get['filter_serial_num'];
		} else {
			$filter_serial_num = NULL;
        }
        
        if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = NULL;
		}

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
        }
        
        $url = '';

        if(isset($this->request->get['row_id'])){
            $url .= '&row_id='.$this->request->get['row_id'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
    
        $data['productions'] = array();

		$filter_data = array(
			'filter_serial_num'     => $filter_serial_num,
			'filter_product_name'	=> $filter_product_name,
			'start'                 => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                 => $this->config->get('config_limit_admin')
        );
        
        $results = $this->model_catalog_production->getProductions($filter_data);
        $total_productions = $this->model_catalog_production->getTotalProductions($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['productions'][] = [
                    'production_id'         => $result['production_id'],
                    'production_date_ori'   => $result['production_date'],
                    'production_date'       => date($this->language->get('date_format_short'), strtotime($result['production_date'])),
                    'expiry_date_ori'       => $result['expiry_date'],
                    'expiry_date'           => date($this->language->get('date_format_short'), strtotime($result['expiry_date'])),
                    'serial_num'            => $result['serial_num'],
                    'product_name'          => $result['product_name']
                ];
            }
        }

        $data['user_token'] = $this->session->data['user_token'];
        
        $pagination = new Pagination();
		$pagination->total = $total_productions;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');;
		$pagination->url = $this->url->link('catalog/production/productionList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_productions) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_productions - $this->config->get('config_limit_admin'))) ? $total_productions : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_productions, ceil($total_productions / $this->config->get('config_limit_admin')));

        $data['filter_serial_num'] = $filter_serial_num;
        $data['filter_product_name'] = $filter_product_name;
        
        $data['row_id'] = isset($this->request->get['row_id']) ? $this->request->get['row_id'] : '';
		$data['header'] = $this->load->controller('common/header/pop_header');

		$this->response->setOutput($this->load->view('openwindow/production_list', $data));
    }

    protected function getList() {
        if (isset($this->request->get['filter_production_date_from'])) {
            $filter_production_date_from = $this->request->get['filter_production_date_from'];
        } else {
            $filter_production_date_from = '';
        }

        if (isset($this->request->get['filter_production_date_to'])) {
            $filter_production_date_to = $this->request->get['filter_production_date_to'];
        } else {
            $filter_production_date_to = '';
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $filter_expiry_date_from = $this->request->get['filter_expiry_date_from'];
        } else {
            $filter_expiry_date_from = '';
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $filter_expiry_date_to = $this->request->get['filter_expiry_date_to'];
        } else {
            $filter_expiry_date_to = '';
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
        } else {
            $filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $filter_serial_num = $this->request->get['filter_serial_num'];
        } else {
            $filter_serial_num = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'pd.invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_production_date_from'])) {
            $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
            $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );
        
        $data['productions'] = [];

        $filter_data = array(
            'filter_production_date_from'   => $filter_production_date_from,
            'filter_production_date_to'     => $filter_production_date_to,
            'filter_expiry_date_from'       => $filter_expiry_date_from,
            'filter_expiry_date_to'         => $filter_expiry_date_to,
            'filter_invoice_prefix'         => $filter_invoice_prefix,
            'filter_serial_num'             => $filter_serial_num,
            'filter_product_name'           => $filter_product_name,
            'filter_status'                 => $filter_status,
            'sort'                          => $sort,
            'order'                         => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $results = $this->model_catalog_production->getProductions($filter_data);
        $total_productions = $this->model_catalog_production->getTotalProductions($filter_data);

        $data['total_production_quantity'] = 0;
        $data['total_actual_quantity'] = 0;
        $data['total_reject_quantity'] = 0;
        $data['total_quantity_left'] = 0;
        
        if (!empty($results)) {
            foreach ($results as $result) {
                $total_reject_quantity = 0;

                $production_qcs = $this->model_catalog_production->getProductionQc($result['production_id']);

                if (!empty($production_qcs)) {
                    foreach ($production_qcs as $qc) {
                        $total_reject_quantity += $qc['reject_quantity'];
                    }
                }

                $status_info = $this->model_localisation_order_status->getOrderStatus($result['status']);
                $status_name = !empty($status_info) ? $status_info['name'] : '';

                $quantity_left = $result['actual_quantity'] - $total_reject_quantity;

                $data['productions'][] = [
                    'production_id'         => $result['production_id'],
                    'production_date'       => date($this->language->get('date_format_short'), strtotime($result['production_date'])),
                    'expiry_date'           => date($this->language->get('date_format_short'), strtotime($result['expiry_date'])),
                    'invoice_prefix'        => $result['invoice_prefix'],
                    'serial_num'            => $result['serial_num'],
                    'product_name'          => $result['product_name'],
                    'quantity'              => $result['quantity'],
                    'actual_quantity'       => $result['actual_quantity'],
                    'reject_quantity'       => $total_reject_quantity,
                    'quantity_left'         => $quantity_left,
                    'status'                => $result['status'],
                    'status_name'           => $status_name,
                    'date_added'            => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'qc_link'               => $this->url->link('catalog/production/manage_qc', 'user_token=' . $this->session->data['user_token'] . '&production_id=' . $result['production_id'], true),
                    'view'                  => $this->url->link('catalog/production/info', 'user_token=' . $this->session->data['user_token'] . '&production_id=' . $result['production_id'], true),
                    'edit'                  => $this->url->link('catalog/production/edit', 'user_token=' . $this->session->data['user_token'] . '&production_id=' . $result['production_id'], true)
                ];

                $data['total_production_quantity'] += $result['quantity'];
                $data['total_actual_quantity'] += $result['actual_quantity'];
                $data['total_reject_quantity'] += $total_reject_quantity;
                $data['total_quantity_left'] += $quantity_left;
            }
        }

        if (isset($sort) && isset($order)){
            if ($sort == 'reject_quantity'){
                $reject_quantity_column = array_column($data['productions'], 'reject_quantity');

                if($order == 'ASC'){
                    array_multisort($data['productions'], SORT_NUMERIC, $reject_quantity_column, SORT_ASC);
                } else{
                    array_multisort($data['productions'], SORT_NUMERIC, $reject_quantity_column, SORT_DESC);
                }
            } elseif ($sort == 'quantity_left'){
                $quantity_left_column = array_column($data['productions'], 'quantity_left');

                if($order == 'ASC'){
                    array_multisort($data['productions'], SORT_NUMERIC, $quantity_left_column, SORT_ASC);
                } else{
                    array_multisort($data['productions'], SORT_NUMERIC, $quantity_left_column, SORT_DESC);
                }
            }
        }

        $data['productions'] = array_slice($data['productions'], $start, $limit);

        $data['print_sticker'] = $this->url->link('catalog/production/print_sticker', 'user_token=' . $this->session->data['user_token'], true);
        $data['add'] = $this->url->link('catalog/production/add', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }

        $url = '';

        if (isset($this->request->get['filter_production_date_from'])) {
            $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
            $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_invoice_prefix'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.invoice_prefix' . $url, true);
        $data['sort_serial_num'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.serial_num' . $url, true);
        $data['sort_product_name'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $url, true);
        $data['sort_production_date'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.production_date' . $url, true);
        $data['sort_expiry_date'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.expiry_date' . $url, true);
        $data['sort_quantity'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.quantity' . $url, true);
        $data['sort_actual_quantity'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.actual_quantity' . $url, true);
        $data['sort_reject_quantity'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=reject_quantity' . $url, true);
        $data['sort_quantity_left'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity_left' . $url, true);
        $data['sort_status'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.status' . $url, true);
        $data['sort_date_added'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.date_added' . $url, true);

        $data['production_statuses'] = [];

        foreach ($this->status_arr as $status_id) {
            $status_info = $this->model_localisation_order_status->getOrderStatus($status_id);

            if (!empty($status_info)) {
                $data['production_statuses'][] = [
                    'status_id'     => $status_id,
                    'name'          => $status_info['name']
                ];
            }
        }

        $pagination = new Pagination();
        $pagination->total = $total_productions;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_productions) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_productions - $this->config->get('config_limit_admin'))) ? $total_productions : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_productions, ceil($total_productions / $this->config->get('config_limit_admin')));

        $data['user_token'] = $this->session->data['user_token'];

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_production_date_from'] = $filter_production_date_from;
        $data['filter_production_date_to'] = $filter_production_date_to;
        $data['filter_expiry_date_from'] = $filter_expiry_date_from;
        $data['filter_expiry_date_to'] = $filter_expiry_date_to;
        $data['filter_invoice_prefix'] = $filter_invoice_prefix;
        $data['filter_serial_num'] = $filter_serial_num;
        $data['filter_product_name'] = $filter_product_name;
        $data['filter_status'] = $filter_status;

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_list', $data));
    }

    protected function getForm() {
        if (!isset($this->request->get['production_id'])) {
			$data['text_form'] = $this->language->get('text_add');
			
            $data['action'] = $this->url->link('catalog/production/add', 'user_token=' . $this->session->data['user_token'], true);
        } else {
			$data['text_form'] = $this->language->get('text_edit');
			
            $production_id = $this->request->get['production_id'];

            $data['action'] = $this->url->link('catalog/production/edit', 'user_token=' . $this->session->data['user_token'] . '&production_id=' . $production_id, true);

            $production_info = $this->model_catalog_production->getProduction($production_id);
        }
        
        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $error_arr = ['warning', 'serial_num', 'production_date', 'expiry_date', 'serial_num_prefix', 'quantity', 'actual_quantity', 'product', 'production_status', 'production_stock'];

        foreach ($error_arr as $error) {
            if (isset($this->error[$error])) {
                $data['error_' . $error] = $this->error[$error];
            } else {
                $data['error_' . $error] = '';
            }
        }

        $post_data_arr = ['serial_num', 'production_date', 'expiry_date', 'serial_num_prefix', 'quantity', 'product_name', 'product_id', 'remark', 'actual_quantity'];

        foreach ($post_data_arr as $post_data) {
            if (isset($this->request->post[$post_data])) {
                $data[$post_data] = $this->request->post[$post_data];
            } elseif (!empty($production_info)) {
                $data[$post_data] = $production_info[$post_data];
            } else {
                $data[$post_data] = '';
            }
        }

        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($production_info)) {
            $data['invoice_prefix'] = $production_info['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/production','store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($production_info)) {
            $data['status'] = $production_info['status'];  
        } else {
            $data['status'] = '';
        }

        if (isset($this->request->post['machine_num'])) {
            $data['machine_num'] = $this->request->post['machine_num'];
        } elseif (!empty($production_info)) {
            $data['machine_num'] = $production_info['machine_num'];  
        } else {
            $data['machine_num'] = 1;
        }

        if (isset($this->request->post['round_num'])) {
            $data['round_num'] = $this->request->post['round_num'];
        } elseif (!empty($production_info)) {
            $data['round_num'] = $production_info['round_num'];
        } else {
            $data['round_num'] = 1;
        }
        
        if (isset($this->request->post['production_stock'])) {
            $data['production_stock'] = $this->request->post['production_stock'];
        } elseif (!empty($production_info)) {
            $data['production_stock'] = !empty($production_info['production_stock']) ? $production_info['production_stock'] : [];
        } else {
            $data['production_stock'] = [];
        }

        $production_machines = $this->model_catalog_production->getProductionMachines();

        if (!empty($production_machines)) {
            foreach ($production_machines as $machine) {
                $data['machine_numbers'][] = [
                    'value'             => $machine['production_machine_id'],
                    'text_num'          => $machine['machine_name']
                ];
            }
        }      

        for ($num = 1; $num <= $this->total_round_num; $num++) {
            $data['round_numbers'][] = [
                'value'             => $num,
                'text_num'          => $this->language->get('text_round') . ' ' . $num
            ];
        }

        $this->load->model('localisation/order_status');

        $data['production_statuses'] = [];

        foreach ($this->status_arr as $status_id) {
            $status_info = $this->model_localisation_order_status->getOrderStatus($status_id);

            if (!empty($status_info)) {
                $data['production_statuses'][] = [
                    'status_id'     => $status_id,
                    'name'          => $status_info['name']
                ];
            }
        }

        $data['cancel'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'], true);

        $data['production_id'] = isset($this->request->get['production_id']) ? $this->request->get['production_id'] : 0;
        $data['on_landing'] = (isset($this->request->get['production_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) ? '1' : '0';

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_form', $data));
    }

    protected function getQcForm() {
        if (!isset($this->request->get['production_id'])) {
            $this->response->redirect($this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['production_id'] = $this->request->get['production_id'];
        
        $production_info = $this->model_catalog_production->getProduction($data['production_id']);

        $data['production_info'] = [];

        if (!empty($production_info)) {
            $production_stocks = $this->model_catalog_production->getProductionStocks($data['production_id']);

            if (!empty($production_stocks)) {
                foreach ($production_stocks as $index => $stock) {
                    $production_stocks[$index]['expected_quantity'] = $production_info['quantity'];
                }
            }

            $status_info = $this->model_localisation_order_status->getOrderStatus($production_info['status']);
            $status_name = !empty($status_info) ? $status_info['name'] : '';

            $machine_info = $this->model_catalog_production->getProductionMachine($production_info['machine_num']);
            $machine_num = !empty($machine_info) ? $machine_info['machine_name'] : '';

            $data['production_info'] = [
                'invoice_prefix'    => $production_info['invoice_prefix'],
                'serial_num'        => $production_info['serial_num'],
                'production_date'   => date($this->language->get('date_format_short'), strtotime($production_info['production_date'])),
                'expiry_date'       => date($this->language->get('date_format_short'), strtotime($production_info['expiry_date'])),
                'product_name'      => $production_info['product_name'],
                'quantity'          => $production_info['quantity'],
                'actual_quantity'   => $production_info['actual_quantity'],
                'machine_num'       => $machine_num,
                'round_num'         => $this->language->get('text_round') . ' ' . $production_info['round_num'],
                'remark'            => nl2br($production_info['remark']),
                'status'            => $production_info['status'],
                'status_name'       => $status_name,
                'production_stock'  => $production_stocks
            ];
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add_qc_action'] = $this->url->link('catalog/production/add_qc', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('catalog/production', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_qc_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'catalog/production')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['status'])) {
            $this->error['production_status'] = $this->language->get('error_production_status');
        }

        if (empty($this->request->post['serial_num'])) {
            $this->error['serial_num'] = $this->language->get('error_serial_num');
        }

        if (!empty($this->request->post['serial_num'])) {
            if (!isset($this->request->get['production_id'])){
                $production_row = $this->model_catalog_production->getProductionBySerialNum($this->request->post['serial_num']);
            } else {
                $production_row = $this->model_catalog_production->getProductionBySerialNum($this->request->post['serial_num'], $this->request->get['production_id']);
            }

            if (!empty($production_row)) {
                $this->error['serial_num'] = $this->language->get('error_serial_num_exists');
            }
        }

        if (empty($this->request->post['production_date'])) {
            $this->error['production_date'] = $this->language->get('error_production_date');
        }

        if (empty($this->request->post['expiry_date'])) {
            $this->error['expiry_date'] = $this->language->get('error_expiry_date');
        }

        if (empty($this->request->post['product_id'])) {
            $this->error['product'] = $this->language->get('error_product');
        }

        if (empty($this->request->post['serial_num_prefix'])) {
            $this->error['serial_num_prefix'] = $this->language->get('error_serial_num_prefix');
        }

        if (empty($this->request->post['quantity']) && !is_int($this->request->post['quantity'])) {
            $this->error['quantity'] = $this->language->get('error_quantity');
        }

        if (!empty($this->request->post['actual_quantity'])) {
            if (!is_numeric($this->request->post['actual_quantity'])) {
                $this->error['actual_quantity'] = $this->language->get('error_actual_quantity');
            }
        }       

        if (isset($this->request->post['production_stock'])) {
            foreach ($this->request->post['production_stock'] as $index => $stock) {
                if ($stock['stock'] < $stock['quantity']) {
                    $this->error['production_stock'][$index] = $this->language->get('error_production_stock');
                }
            }
        }
        
        if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
    }

    private function week_of_the_month($date) {
        // estract date parts
        list($year, $month, $day) = explode('-', date('Y-m-d', strtotime($date)));
    
        // current week, min 1
        $week = 1;
    
        // for each day since the start of the month
        for ($i = 1; $i <= $day; ++$i) {
            // if that day was a sunday and is not the first day of month
            if ($i > 1 && date('w', strtotime("$year-$month-$i")) == 0) {
                // increment current week
                ++$week;
            }
        }
    
        // now return
        return $week;
    }
}
?>