<?php

class ControllerCatalogPrescription extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/prescription');

        $this->getList();
    }

    public function add() {
        $this->load->language('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/prescription');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_prescription->addPrescription($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            $this->response->redirect($this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/prescription');

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            if (isset($this->session->data['prescription_item'])) {
                $this->request->post['prescription_item'] = $this->session->data['prescription_item'];
            }
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_catalog_prescription->editPrescription($this->request->get['prescription_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            $this->response->redirect($this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/prescription');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $prescription_id)
                $this->model_catalog_prescription->deletePrescription($prescription_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/prescription');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_status']))
                $querystring .= '&filter_status=' . $this->request->post['filter_status'];

            $this->response->redirect($this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getList();
    }

    public function getList() {

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : NULL;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $status = isset($this->request->get['status']) ? $this->request->get['status'] : NULL;
        $sort_order = isset($this->request->get['sort_order']) ? $this->request->get['sort_order'] : NULL;
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_pinyin'])) {
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['sort_order'])) {
            $querystring .= '&sort_order=' . $this->request->get['sort_order'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $querystring, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_name_memory'] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data['filter_code_memory'] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data['filter_pinyin_memory'] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        $data['filter_status_memory'] = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : "";

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_pinyin'])) {
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystring, true);
        $data['sort_code'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystring, true);
        $data['sort_status'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystring, true);
        $data['sort_order'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystring, true);
        $data['sort_sort_order'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystring, true);
        $data['sort_pinyin'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystring, true);

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        $data['filter'] = $this->url->link('catalog/prescription/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('catalog/prescription/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/prescription/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_pinyin' => $filter_pinyin,
            'filter_code' => $filter_code,
            'filter_status' => $filter_status,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['prescriptions'] = array();

        $prescriptionList = $this->model_catalog_prescription->getPrescriptionList($filter_data);

        foreach ($prescriptionList as $prescription) {
            $data['prescriptions'][] = array(
                'prescription_id' => $prescription['prescription_id'],
                'name' => $prescription['name'],
                'code' => $prescription['code'],
                'pinyin' => $prescription['pinyin'],
                'status' => $prescription['status'],
                'sort_order' => $prescription['sort_order'],
                'edit' => $this->url->link('catalog/prescription/edit', 'user_token=' . $this->session->data['user_token'] . '&prescription_id=' . $prescription['prescription_id'] . $querystring, true)
            );
        }

        $total_prescription = $this->model_catalog_prescription->totalPrescription($filter_data);

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_pinyin'])) {
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }

        if (isset($this->request->get['filter_price'])) {
            $querystring .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_prescription;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_prescription) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_prescription - $this->config->get('config_limit_admin'))) ? $total_prescription : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_prescription, ceil($total_prescription / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/prescription_list', $data));
    }

    public function getForm() {

        if (isset($this->session->data['prescription_item'])) {
            unset($this->session->data['prescription_item']);
        }

        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages

        $nameMemory = array();
        if (isset($this->request->get['prescription_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_catalog_prescription->getPrescriptionColumn($this->request->get['prescription_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_prescription_name"] = isset($this->request->post['prescription_name']) ? // if request post from form
                $this->request->post['prescription_name'] :
                (isset($this->request->get['prescription_id']) ? $nameMemory : array());


        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['prescription_id']) ?
                $this->model_catalog_prescription->getPrescriptionColumn($this->request->get['prescription_id'], 'code') :
                ""
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['prescription_id']) ?
                $this->model_catalog_prescription->getPrescriptionColumn($this->request->get['prescription_id'], 'pinyin') :
                ""
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['prescription_id']) ?
                $this->model_catalog_prescription->getPrescriptionColumn($this->request->get['prescription_id'], 'sort_order') :
                0
                );
       
        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['prescription_id']) ?
                $this->model_catalog_prescription->getPrescriptionColumn($this->request->get['prescription_id'], 'status') :
                1
                );

        //prescription item
        $data["form_memory_prescription_items"] = isset($this->request->post['prescription_item']) ? // if request post from form
                $this->request->post['prescription_item'] :
                (
                isset($this->request->get['prescription_id']) ?
                $this->model_catalog_prescription->getPerscriptionItems($this->request->get['prescription_id'], 'status') :
                array()
                );

        /*
          $prescription_item = array();
          if(isset($this->request->post['prescription_item'])){
          $this->session->data['prescription_item'] = $this->request->post['prescription_item'];
          } else if(isset($this->request->get['prescription_id'])){
          $this->session->data['prescription_item'] = $this->model_catalog_prescription->getPerscriptionItems($this->request->get['prescription_id']);
          }


          if(isset($this->session->data['prescription_item'])){
          $items = $this->session->data['prescription_item'];

          foreach($items as $id => $item){
          $this->load->model('catalog/product');
          $product_info = $this->model_catalog_product->getProduct($id);

          $prescription_item[$id] = $product_info;
          $prescription_item[$id]['used_qty'] = $item['used_qty'];
          $prescription_item[$id]['display_order'] = $item['display_order'];
          $prescription_item[$id]['remark'] = $item['remark'];
          }
          }
          $data["form_memory_prescription_items"] = $prescription_item;
         */

        //**text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['prescription_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'], true)
        );

        //**query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        //**urls
        $data['cancel'] = $this->url->link('catalog/prescription', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['prescription_id']))
            $querystring .= '&prescription_id=' . $this->request->get['prescription_id'];
        $action_mode = !(isset($this->request->get['prescription_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/prescription/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        $data['error_product'] = $this->language->get('error_product');
        $data['error_used_qty'] = $this->language->get('error_used_qty');
        $data['error_display_order'] = $this->language->get('error_display_order');

        $data['user_token'] = $this->session->data['user_token'];

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/prescription_form', $data));
    }

    public function addPrescriptionItem() {
        $json = array('success' => false);

        if (
                isset($this->request->get['product_id']) &&
                isset($this->request->get['used_qty']) &&
                isset($this->request->get['display_order'])
        ) {
            $product_id = $this->request->get['product_id'];

            if ($product_id) {
                $used_qty = $this->request->get['used_qty'];
                $display_order = $this->request->get['display_order'];
                $remark = $this->request->get['remark'];

                if (!isset($this->session->data['prescription_item'])) {
                    $this->session->data['prescription_item'] = array();
                }

                if (!isset($this->session->data['prescription_item'][$product_id])) {
                    $this->load->model('catalog/product');
                    $product_info = $this->model_catalog_product->getProduct($product_id);

                    $this->session->data['prescription_item'][$product_id] = array(
                        "code" => $product_info['code'],
                        "used_qty" => $used_qty,
                        "display_order" => $display_order,
                        'remark' => $remark
                    );

                    $json = $product_info;

                    $json['used_qty'] = $used_qty;
                    $json['display_order'] = $display_order;
                    $json['remark'] = $remark;

                    $json['success'] = true;
                } else {
                    $json['success'] = 'exists';
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function deletePrescriptionItem() {
        $json = array('success' => false);

        $product_id = isset($this->request->get['product_id']) ? $this->request->get['product_id'] : false;

        if ($product_id) {
            if (isset($this->session->data['prescription_item'][$product_id])) {
                unset($this->session->data['prescription_item'][$product_id]);
            }

            $json = array(
                'product_id' => $product_id,
                'success' => true
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function viewSession() {
        echo "<pre>";
        print_r($this->session->data['prescription_item']);
        echo "</pre>";
    }

    protected function validateForm() {

        // validation function
        function validStrLen($str, $min, $max) {
            return (utf8_strlen($str) >= $min && utf8_strlen($str) <= $max);
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/prescription') && !$this->user->userpermission('modify', 'catalog/prescription'))
            $this->error['warning'] = $this->language->get('error_permission');

        //name
        foreach ($this->request->post['prescription_name'] as $language_id => $row) {
            if (!validStrLen($row['name'], 1, 200)) {
                $this->error['name']['name' . $language_id] = $this->language->get('error_prescription_name');
            }
        }
        //code
        if (!validStrLen($this->request->post['code'], 1, 100)) {
            $this->error['name']['code'] = $this->language->get('error_prescription_code');
        }

        //code
        if (!validStrLen($this->request->post['pinyin'], 1, 100)) {
            $this->error['name']['pinyin'] = $this->language->get('error_prescription_pinyin');
        }

        $prescription_item = isset($this->request->post['prescription_item']) ? $this->request->post['prescription_item'] : false;

        if ($prescription_item) {

            $products_id_list = array();

            foreach ($prescription_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                if (empty($product_id)) {
                    $this->error['name']['prescription_item_product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    if (in_array($product_id, $products_id_list)) {
                        $this->error['name']['prescription_item_product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    }

                    $products_id_list[] = $product_id;
                }

                $used_qty = $product['used_qty'];
                $used_qty = trim($used_qty);
                if (!is_numeric($used_qty)) {
                    $this->error['name']['prescription_item_used_qty'][$row_id] = $this->language->get('error_used_qty');
                } else {
                    if ($used_qty <= 0) {
                        $this->error['name']['prescription_item_used_qty'][$row_id] = $this->language->get('error_used_qty');
                    }
                }

                $display_order = $product['display_order'];
                $display_order = trim($display_order);
                if (!is_numeric($display_order)) {
                $this->error['name']['prescription_item_display_order'][$row_id] = $this->language->get('error_display_order');
                } else {
                    if ($display_order < 0) {
                        $this->error['name']['prescription_item_display_order'][$row_id] = $this->language->get('error_display_order');
                    }
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_prescription');
            ;
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');


        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'catalog/prescription') && !$this->user->userpermission('delete', 'catalog/prescription')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function openWindow() {

        $this->load->language('catalog/prescription');
        $this->load->model('catalog/prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $sort_order = isset($this->request->get['sort_order']) ? $this->request->get['sort_order'] : NULL;
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }


        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['sort_order'])) {
            $querystring .= '&sort_order=' . $this->request->get['sort_order'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_name_memory'] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data['filter_code_memory'] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data['filter_status_memory'] = isset($this->request->get['filter_status']) ? $this->request->get['filter_status'] : "";

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystring, true);
        $data['sort_code'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystring, true);
        $data['sort_status'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystring, true);
        $data['sort_order'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystring, true);
        $data['sort_sort_order'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystring, true);

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];


        $data['filter'] = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('catalog/prescription/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/prescription/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['prescriptions'] = array();

        $prescriptionList = $this->model_catalog_prescription->getPrescriptionList($filter_data);

        foreach ($prescriptionList as $prescription) {
            $data['prescriptions'][] = array(
                'prescription_id' => $prescription['prescription_id'],
                'name' => $prescription['name'],
                'code' => $prescription['code'],
            );
        }

        $total_prescription = $this->model_catalog_prescription->totalPrescription($filter_data);

        $querystring = '';

        if (isset($this->request->get['filter_name'])) {
            $querystring .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        }

        if (isset($this->request->get['filter_price'])) {
            $querystring .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_prescription;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/prescription/openWindow', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_prescription) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_prescription - $this->config->get('config_limit_admin'))) ? $total_prescription : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_prescription, ceil($total_prescription / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/prescription_list', $data));
    }

    public function prescriptionItem() {
        $json = array();

        $this->load->language('catalog/prescription');
        $this->load->model('catalog/prescription');

        $perscription_items = $this->model_catalog_prescription->getPerscriptionItemsJson($this->request->get['prescription_id']);

        $json['prescription'] = array();
        $json['error'] = '';
        $json['entry_product_name'] = $this->language->get('entry_product_name');
        $json['entry_product_code'] = $this->language->get('entry_product_code');
        $json['entry_product_used_qty'] = $this->language->get('entry_product_used_qty');

        if (!empty($perscription_items)) {
            foreach ($perscription_items as $item) {
                $json['prescription'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'used_qty' => $item['used_qty']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('catalog/prescription');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $prescriptionList = $this->model_catalog_prescription->getPrescriptionList($filter_data);

            foreach ($prescriptionList as $row => $prescription) {
                $json[] = array(
                    'prescription_id' => $prescription['prescription_id'],
                    'name' => $prescription['name'],
                    'code' => $prescription['code'],
                    'pinyin' => $prescription['pinyin']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}
?>