<?php

class ControllerCatalogLotTransfer extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('catalog/lot_transfer');

        $this->document->setTitle($this->language->get('heading_title'));


        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('catalog/lot_transfer');
        $this->getList();
    }

    public function add()
    {
        $this->load->language('catalog/lot_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/lot_transfer');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && isset($this->request->post['add_product'])) {
            $lot_transfer_id = $this->model_catalog_lot_transfer->addLotTransfer($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/lot_transfer/edit', 'user_token=' . $this->session->data['user_token'] . '&lot_transfer_id=' . $lot_transfer_id . $querystring, true));
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_lot_transfer->addLotTransfer($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/lot_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/lot_transfer');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_lot_transfer->editLotTransfer($this->request->get['lot_transfer_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            $this->response->redirect($this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function info()
    {
        $this->load->language('catalog/lot_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/lot_transfer');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateInfoDesc()) {
            $this->model_catalog_lot_transfer->editLotTransferInfo(
                $this->request->get['lot_transfer_id'],
                $this->request->post
            );


            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'], true));
        }

        $store_id = $this->session->data['store_id'];

        $lot_transfer_id = isset($this->request->get['lot_transfer_id']) ? $this->request->get['lot_transfer_id'] : 0;

        $lot_transfer_info = $this->model_catalog_lot_transfer->getLotTransfer($lot_transfer_id);
        if ($lot_transfer_info) {
            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_form'] = $this->language->get('heading_title');

            //**sitemap data
            $data['breadcrumbs'] = array();
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'], true)
            );

            $lot_transfer_item = $lot_transfer_info['lot_transfer_item'];

            $data['doc_no'] = $lot_transfer_info['doc_no'];
            $data['doc_date'] = date('d-m-Y', strtotime($lot_transfer_info['doc_date']));
            $data['staff'] = $lot_transfer_info['staff'];

            $data['lot_transfer_item'] = $lot_transfer_item;

            //**query string
            $querystring = '';

            if (isset($this->request->get['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $querystring .= '&page=' . $this->request->get['page'];
            }

            if (isset($this->request->get['filter_doc_no'])) {
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
            }

            if (isset($this->request->get['filter_add_by'])) {
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            if (isset($this->request->get['filter_date_from'])) {
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }


            //**urls
            $data['barcode_link'] = $this->url->link('catalog/lot_transfer/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $querystring, true);
            $data['cancel'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->get['lot_transfer_id']))
                $querystring .= '&lot_transfer_id=' . $this->request->get['lot_transfer_id'];
            // $action_mode = !(isset($this->request->get['lot_transfer_id'])) ? 'add' : 'edit';
            // $data['action'] = $this->url->link("catalog/lot_transfer/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->post['description'])) {
                $data['description'] = $this->request->post['description'];
            } else if (isset($this->request->get['lot_transfer_id'])) {
                $data['description'] = $lot_transfer_info['description'];
            } else {
                $data['description'] = '';
            }

            //**error
            $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
            $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

            $data['user_token'] = $this->session->data['user_token'];

            //**load template module
            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/lot_transfer_info_form', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function filter()
    {
        $this->load->language('catalog/lot_transfer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/lot_transfer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';


            if (isset($this->request->post['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->post['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }


            //post from filter form
            if (isset($this->request->post['filter_doc_no'])) {
                $querystring .= '&filter_doc_no=' . $this->request->post['filter_doc_no'];
            }

            if (isset($this->request->post['filter_date_from'])) {
                $querystring .= '&filter_date_from=' . $this->request->post['filter_date_from'];
            }

            if (isset($this->request->post['filter_date_to'])) {
                $querystring .= '&filter_date_to=' . $this->request->post['filter_date_to'];
            }

            if (isset($this->request->post['filter_batch_date_from'])) {
                $querystring .= '&filter_batch_date_from=' . $this->request->post['filter_batch_date_from'];
            }

            if (isset($this->request->post['filter_batch_date_to'])) {
                $querystring .= '&filter_batch_date_to=' . $this->request->post['filter_batch_date_to'];
            }

            if (isset($this->request->post['filter_source_locations'])) {
                $querystring .= '&filter_source_locations=' . implode(",", $this->request->post['filter_source_locations']);
            }

            if (isset($this->request->post['filter_target_locations'])) {
                $querystring .= '&filter_target_locations=' . implode(",", $this->request->post['filter_target_locations']);
            }

            if (isset($this->request->post['filter_product_id'])) {
                $querystring .= '&filter_product_id=' . $this->request->post['filter_product_id'];
            }

            if (isset($this->request->post['filter_product_name'])) {
                $querystring .= '&filter_product_name=' . $this->request->post['filter_product_name'];
            }

            if (isset($this->request->post['filter_product_code'])) {
                $querystring .= '&filter_product_code=' . $this->request->post['filter_product_code'];
            }

            if (isset($this->request->post['filter_add_by'])) {
                $querystring .= '&filter_add_by=' . $this->request->post['filter_add_by'];
            }

            if (isset($this->request->post['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->post['filter_store_id'];
            }

            $this->response->redirect($this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getList();
    }

    public function getList()
    {

        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;

        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;

        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;

        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;

        $filter_source_locations = isset($this->request->get['filter_source_locations']) ? explode(",", $this->request->get['filter_source_locations']) : NULL;

        $filter_target_locations = isset($this->request->get['filter_target_locations']) ? explode(",", $this->request->get['filter_target_locations']) : NULL;

        $filter_store_id = isset($this->request->get['filter_store_id']) ? $this->request->get['filter_store_id'] : $this->session->data['store_id'];

        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'doc_no';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_product_id'])) {
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_source_locations'])) {
            $querystring .= '&filter_source_locations=' . $this->request->get['filter_source_locations'];
        }

        if (isset($this->request->get['filter_target_locations'])) {
            $querystring .= '&filter_target_locations=' . $this->request->get['filter_target_locations'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }



        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['sort_order'])) {
            $querystring .= '&sort_order=' . $this->request->get['sort_order'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_doc_no_memory'] = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : "";
        $data['filter_add_by_memory'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";
        $data['filter_date_from_memory'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : "";
        $data['filter_date_to_memory'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : "";

        $data['filter_batch_date_from_memory'] = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : "";
        $data['filter_batch_date_to_memory'] = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : "";

        $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";
        $data['filter_product_id_memory'] = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : "";
        $data['filter_product_code_memory'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : "";

        $data['filter_source_locations_memory'] = isset($this->request->get['filter_source_locations']) ? $filter_source_locations : array();
        $data['filter_target_locations_memory'] = isset($this->request->get['filter_target_locations']) ? $filter_target_locations : array();

        $data['filter_store_id'] = isset($this->request->get['filter_store_id']) ? $this->request->get['filter_store_id'] : $this->session->data['store_id'];

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $querystring = '';

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_product_id'])) {
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_source_locations'])) {
            $querystring .= '&filter_source_locations=' . $this->request->get['filter_source_locations'];
        }

        if (isset($this->request->get['filter_target_locations'])) {
            $querystring .= '&filter_target_locations=' . $this->request->get['filter_target_locations'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_doc_date'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_date' . $querystring, true);
        $data['sort_doc_no'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_no' . $querystring, true);
        $data['sort_product_name'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $querystring, true);
        $data['sort_product_code'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $querystring, true);
        $data['sort_source_location'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=source_location' . $querystring, true);
        $data['sort_target_location'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=target_location' . $querystring, true);
        $data['sort_batch_date'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystring, true);
        $data['sort_qty'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $querystring, true);
        $data['sort_add_by'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $querystring, true);
        $data['sort_description'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $querystring, true);
        $querystring = '';

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_source_locations'])) {
            $querystring .= '&filter_source_locations=' . $this->request->get['filter_source_locations'];
        }

        if (isset($this->request->get['filter_target_locations'])) {
            $querystring .= '&filter_target_locations=' . $this->request->get['filter_target_locations'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        $data['filter'] = $this->url->link('catalog/lot_transfer/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('catalog/lot_transfer/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/lot_transfer/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_doc_no' => $filter_doc_no,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_product_id' => $filter_product_id,
            'filter_product_code' => $filter_product_code,
            'filter_source_locations' => $filter_source_locations,
            'filter_target_locations' => $filter_target_locations,
            'filter_store_id' => $filter_store_id,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }


        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_lot_transfer->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_lot_transfer->getLocations();
        }


        $data['lotTransfers'] = array();

        $lotTransferList = $this->model_catalog_lot_transfer->getLotTransferList($filter_data);

        foreach ($lotTransferList as $lotTransfer) {
            $data['lotTransfers'][] = array(
                'lot_transfer_id' => $lotTransfer['lot_transfer_id'],
                // 'date_added' => date('d/m/Y h:i A', strtotime($lotTransfer['date_added'])),
                'doc_date' => $lotTransfer['doc_date'],
                'doc_no' => $lotTransfer['doc_no'],
                'product_name' => $lotTransfer['product_name'],
                'product_code' => $lotTransfer['product_code'],

                'source_location' => $lotTransfer['source_location'],
                'target_location' => $lotTransfer['target_location'],
                'batch_date' => $lotTransfer['batch_date'],
                'qty' => (float)$lotTransfer['qty'],
                'uom' => $lotTransfer['uom'],
                'source_mvmt' => $lotTransfer['source_mvmt'],
                'target_mvmt' => $lotTransfer['target_mvmt'],

                'description' => $lotTransfer['description'],
                'status' => $lotTransfer['status'],
                'add_by' => $lotTransfer['add_by'],

                'info' => $this->url->link('catalog/lot_transfer/info', 'user_token=' . $this->session->data['user_token'] . '&lot_transfer_id=' . $lotTransfer['lot_transfer_id'] . $querystring, true),
                'edit' => $this->url->link('catalog/lot_transfer/edit', 'user_token=' . $this->session->data['user_token'] . '&lot_transfer_id=' . $lotTransfer['lot_transfer_id'] . $querystring, true),
                'export' => $this->url->link('catalog/lot_transfer/export_excel', 'user_token=' . $this->session->data['user_token'] . '&lot_transfer_id=' . $lotTransfer['lot_transfer_id'], true)
            );
        }

        $total_lot_transfer = $this->model_catalog_lot_transfer->totalLotTransfer($filter_data);

        $querystring = '';

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_source_locations'])) {
            $querystring .= '&filter_source_locations=' . $this->request->get['filter_source_locations'];
        }

        if (isset($this->request->get['filter_target_locations'])) {
            $querystring .= '&filter_target_locations=' . $this->request->get['filter_target_locations'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_lot_transfer;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_lot_transfer) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_lot_transfer - $this->config->get('config_limit_admin'))) ? $total_lot_transfer : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_lot_transfer, ceil($total_lot_transfer / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/lot_transfer_list', $data));
    }


    public function insertProductToDatabase()
    {

        $this->load->language('catalog/lot_transfer');
        $this->load->model('catalog/lot_transfer');

        $json = [];
        $error = false;

        $lot_transfer_id = !empty($this->request->post['lot_transfer_id']) ? $this->request->post['lot_transfer_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;



        if (empty($lot_transfer_id)) {
            $error = true;
        }



        if (empty($product_id)) {
            $error = true;
        }



        if (empty($error)) {
            $result = $this->model_catalog_lot_transfer->addLotTransferProduct($this->request->post);

            $json['lot_transfer_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['source_stock_onhand'] = !empty($result['source_stock_onhand']) ? $result['source_stock_onhand'] : 0;
            $json['target_stock_onhand'] = !empty($result['target_stock_onhand']) ? $result['target_stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateProductToDatabase()
    {

        $this->load->language('catalog/lot_transfer');
        $this->load->model('catalog/lot_transfer');

        $json = [];
        $error = false;

        $lot_transfer_product_id = !empty($this->request->post['lot_transfer_product_id']) ? $this->request->post['lot_transfer_product_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;



        if (empty($lot_transfer_product_id)) {
            $error = true;
        }



        if (empty($product_id)) {
            $error = true;
        }



        if (empty($error)) {

            $result = $this->model_catalog_lot_transfer->editLotTransferProduct($this->request->post);

            $json['lot_transfer_product_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['source_stock_onhand'] = !empty($result['source_stock_onhand']) ? $result['source_stock_onhand'] : 0;
            $json['target_stock_onhand'] = !empty($result['target_stock_onhand']) ? $result['target_stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {

            $json['errors'][] = [

                'error' => 'missing_product_data',

                'msg'   => $this->language->get('error_missing_product_data')

            ];
        }



        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }

    public function deleteProductFromDatabase()
    {

        $this->load->language('catalog/lot_transfer');
        $this->load->model('catalog/lot_transfer');

        $json = [];
        $error = false;

        $lot_transfer_product_id = !empty($this->request->post['lot_transfer_product_id']) ? $this->request->post['lot_transfer_product_id'] : 0;



        if (empty($lot_transfer_product_id)) {
            $error = true;
        }

        if (empty($error)) {

            $this->model_catalog_lot_transfer->deleteLotTransferProduct($lot_transfer_product_id);

            $json['lot_transfer_product_id'] = !empty($lot_transfer_product_id) ? $lot_transfer_product_id : 0;

            $json['success'] = !empty($lot_transfer_product_id) ? true : false;
        } else {

            $json['errors'][] = [

                'error' => 'missing_product_data',

                'msg'   => $this->language->get('error_missing_product_data')

            ];
        }



        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }

    public function reverseTransfer()
    {
        $json = array('success' => false);

        $lot_transfer_product_id = (isset($this->request->post['lot_transfer_product_id'])) ? $this->request->post['lot_transfer_product_id'] : false;
        $remark = (isset($this->request->post['remark'])) ? $this->request->post['remark'] : false;

        if ($lot_transfer_product_id) {
            $this->load->model('catalog/lot_transfer');
            $this->model_catalog_lot_transfer->reverseTransfer($lot_transfer_product_id, $remark);
            $json = array(
                'success' => true,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getDefaultLocationAndWeightClassId()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/lot_transfer');
            $def_location = $this->model_catalog_lot_transfer->getDefaultLocation($product_id);
            $def_wcid = $this->model_catalog_lot_transfer->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'def_location' => $def_location,
                'def_wcid' => $def_wcid,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getForm()
    {

        $data['user_token'] = $this->session->data['user_token'];

        $store_id = $this->session->data['store_id'];

        if (isset($this->request->get['lot_transfer_id'])) {
            $lot_transfer_info = $this->model_catalog_lot_transfer->getLotTransfer($this->request->get['lot_transfer_id']);
            $data["form_memory_doc_no"] = $lot_transfer_info['doc_no'];
            $data['lot_transfer_id'] = $this->request->get['lot_transfer_id'];
        } else {
            $data["form_memory_doc_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/lot_transfer', 'store' => $store_id));
            $data['lot_transfer_id'] = 0;
        }

        $empty_product = array(
            array(
                'name' => '',
                'product_id' => '',
                'lot_transfer_product_id' => 0,
                'code' => '',
                'source_onhand_quantity' => '',
                'source_location' => '',
                'target_onhand_quantity' => '',
                'target_location' => '',
                'qty' => '',
                'weight_class_id' => '',
                'batch_date' => '',
                'remark' => '',
            )
        );
        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $data["form_memory_doc_date"] = isset($this->request->post['doc_date']) ? $this->request->post['doc_date'] : date('Y-m-d');
            $form_memory_lot_transfer_items = isset($this->request->post['lot_transfer_item']) ? $this->request->post['lot_transfer_item'] : (!empty($lot_transfer_info) ? $empty_product : array());
            $data["form_memory_lot_transfer_items"] = $form_memory_lot_transfer_items;
            $data['description'] = $this->request->post['description'];
        } elseif (!empty($lot_transfer_info)) {
            $data["form_memory_doc_date"] = $lot_transfer_info['doc_date'];
            $data["form_memory_lot_transfer_items"] = isset($lot_transfer_info['lot_transfer_item']) ? $lot_transfer_info['lot_transfer_item'] : $empty_product;
            $data['description'] = $lot_transfer_info['description'];
        } else {
            $data["form_memory_doc_date"] = date('Y-m-d');
            $data["form_memory_lot_transfer_items"] = array();
            $data['description'] = '';
        }


        foreach ($data["form_memory_lot_transfer_items"] as $item) {
            if (!empty($item['product_id'])) {
                $data['source_locations'][$item['product_id']] = $this->model_catalog_lot_transfer->getLocationList($item['product_id']);

                $data['batchDates'][$item['product_id']][$item['source_location']] = $this->model_catalog_lot_transfer->getBatchDateList($item['product_id'], $item['source_location']);
            }
        }



        $target_locations[0] = "Default Location"; //pre set default locations.
        $locations = $this->model_catalog_lot_transfer->getLocations();
        foreach ($locations as $loc) {
            $target_locations[$loc['location_id']] = $loc['warehouse'] . ">" . $loc['zone'] . ">" . $loc['lot'];
        }
        $data['target_locations'] = $target_locations;
        $data['weight_classes'] = $this->model_catalog_lot_transfer->getWeightClasses();


        //**text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['lot_transfer_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'], true)
        );

        //**query string
        $querystring = '';

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**urls
        $data['cancel'] = $this->url->link('catalog/lot_transfer', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['barcode_link'] = $this->url->link('catalog/lot_transfer/printProductStickers', true);

        if (isset($this->request->get['lot_transfer_id']))
            $querystring .= '&lot_transfer_id=' . $this->request->get['lot_transfer_id'];

        $action_mode = !(isset($this->request->get['lot_transfer_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/lot_transfer/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);



        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_product_id'] = isset($this->error['product_id']) ? $this->error['product_id'] : NULL;
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : NULL;
        $data['error_product_loc'] = isset($this->error['product_location']) ? $this->error['product_location'] : NULL;

        $data['user_token'] = $this->session->data['user_token'];

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/lot_transfer_form', $data));
    }

    protected function validateForm()
    {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/lot_transfer') && !$this->user->userpermission('modify', 'catalog/lot_transfer'))
            $this->error['warning'] = $this->language->get('error_permission');

        $lot_transfer_item = isset($this->request->post['lot_transfer_item']) ? $this->request->post['lot_transfer_item'] : false;

        if ($lot_transfer_item) {

            $products_id_list = array();

            foreach ($lot_transfer_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                $location_id = isset($product['source_location']) ? $product['source_location'] : null;
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    // if (in_array($product_id, $products_id_list)) {
                    //     $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    // }

                    $products_id_list[] = $product_id;
                }

                $qty = $product['qty'];
                $qty = trim($qty);
                $source_qty = $product['source_onhand_quantity'];
                $source_qty = trim($source_qty);
                if (!is_numeric($qty)) {
                    $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                } else {
                    if ($qty <= 0) {
                        $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                    } elseif ($qty > $source_qty) {
                        $this->error['product_qty'][$row_id] = $this->language->get('error_qty_over');
                    }
                }
                if (!is_numeric($location_id)) {
                    $this->error['product_location'][$row_id] = $this->language->get('error_location');
                }

                // error_product_loc
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_lot_transfer');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
    protected function validateDraftForm()
    {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/lot_transfer') && !$this->user->userpermission('modify', 'catalog/lot_transfer'))
            $this->error['warning'] = $this->language->get('error_permission');

        $lot_transfer_item = isset($this->request->post['lot_transfer_item']) ? $this->request->post['lot_transfer_item'] : false;

        if ($lot_transfer_item) {

            $products_id_list = array();

            foreach ($lot_transfer_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    // if (in_array($product_id, $products_id_list)) {
                    //     $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                    // }

                    $products_id_list[] = $product_id;
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_lot_transfer');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = count($data['product_stickers']);

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function getLocationList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/lot_transfer');
            $locationList = $this->model_catalog_lot_transfer->getLocationList($product_id);
            $def_wcid = $this->model_catalog_lot_transfer->getweightClassProduct($product_id);

            if (!empty($locationList)) {
                $json = array(
                    'success'  => true,
                    'list'     => $locationList,
                    'def_wcid' => $def_wcid,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getBatchDateList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;

        if ($product_id) {
            $this->load->model('catalog/lot_transfer');
            $batchDateList = $this->model_catalog_lot_transfer->getBatchDateList($product_id, $location_id);

            if (!empty($batchDateList)) {
                $json = array(
                    'success' => true,
                    'list'    => $batchDateList,
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
    protected function validateInfoDesc()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/lot_transfer') && !$this->user->userpermission('modify', 'catalog/lot_transfer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        // if (empty($this->request->post['description'])) {
        //     $this->error['description'] = $this->language->get('error_description');
        // }





        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
}
