<?php

class ControllerAppointmentAppointmentEtcm extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('appointment/appointment_etcm');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_etcm');

        $this->getList();
    }

    protected function getList() {
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_no'])) {
            $filter_no = $this->request->get['filter_no'];
        } else {
            $filter_no = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_date'])) {
            $filter_date = $this->request->get['filter_date'];
        } else {
            $filter_date = null;
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'appointment_date';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_no'])) {
            $url .= '&filter_no=' . $this->request->get['filter_no'];
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . $this->request->get['filter_ic'];
        }

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['delete'] = $this->url->link('appointment/appointment_etcm/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $customer_data = array();
        $data['appointment'] = array();

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_ic' => $filter_ic,
            'filter_no' => $filter_no,
            'filter_date' => $filter_date,
            'filter_doctor' => $filter_doctor,
            'filter_remark' => $filter_remark,
            'filter_status' => $filter_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $appointment_etcm_total = $this->model_appointment_appointment_etcm->getTotalAppointments($filter_data);

        $results = $this->model_appointment_appointment_etcm->getAppointments($filter_data);

        foreach ($results as $result) {
            $customer_id = $result['customer_id'];

            $customer_data = $this->model_appointment_appointment_etcm->getCustomer($customer_id);

            $data['appointment'][] = array(
                'appointment_id' => $result['appointment_id'],
                'date' => $result['appointment_date'],
                'time' => $result['appointment_time'],
                'store' => isset($result['store_name']) ? $result['store_name'] : $this->config->get('config_name'),
                'name' => $customer_data['customer_name'],
                'ic' => $customer_data['customer_ic'],
                'status' => $result['status'],
                'edit' => $this->url->link('appointment/appointment_etcm/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'] . $url, true),
                'view' => $this->url->link('appointment/appointment_etcm/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'] . $url, true)
            );
        }


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . $this->request->get['filter_ic'];
        }

        if (isset($this->request->get['filter_no'])) {
            $url .= '&filter_no=' . $this->request->get['filter_no'];
        }

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_date'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=appointment_date' . $url, true);
        $data['sort_time'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=appointment_time' . $url, true);
        $data['sort_store'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=store_id' . $url, true);
        $data['sort_status'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_name'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=firstname' . $url, true);
        $data['sort_ic'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_ic' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . urlencode(html_entity_decode($this->request->get['filter_date'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_no'])) {
            $url .= '&filter_no=' . urlencode(html_entity_decode($this->request->get['filter_no'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . urlencode(html_entity_decode($this->request->get['filter_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . urlencode(html_entity_decode($this->request->get['filter_doctor'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . urlencode(html_entity_decode($this->request->get['filter_remark'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $doctors = $this->model_appointment_appointment_etcm->getDoctors();

        foreach ($doctors as $doctor) {
            $data['doctors'][] = array(
                'user_id' => $doctor['user_id'],
                'doctor_name' => $doctor['firstname'] . ' ' . $doctor['lastname']
            );
        }

        $pagination = new Pagination();
        $pagination->total = $appointment_etcm_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($appointment_etcm_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($appointment_etcm_total - $this->config->get('config_limit_admin'))) ? $appointment_etcm_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $appointment_etcm_total, ceil($appointment_etcm_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_date'] = $filter_date;
        $data['filter_status'] = $filter_status;
        $data['filter_name'] = $filter_name;
        $data['filter_no'] = $filter_no;
        $data['filter_ic'] = $filter_ic;
        $data['filter_doctor'] = $filter_doctor;
        $data['filter_remark'] = $filter_remark;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_etcm_list.twig', $data));
    }

    public function delete() {
        $this->load->language('appointment/appointment_etcm');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_etcm');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $appointment_id) {
                $this->model_appointment_appointment_etcm->deleteAppointment($appointment_id);

                $appointment_info = $this->model_appointment_appointment_etcm->getAppointment($appointment_id);

                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($appointment_id, '3', $appointment_info['from_etcm'], $appointment_info['appointment_date'], $appointment_info['appointment_time']);
                }
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_date'])) {
                $url .= '&filter_date=' . $this->request->get['filter_date'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($appointment_id) && $appointment_id != 0) {
                $url .= '&appointment_id=' . $appointment_id;
            }

            $this->response->redirect($this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'appointment/appointment_etcm')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function view() {
        $this->load->language('appointment/appointment_etcm');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_etcm');

        $this->getFormView();
    }

    public function getFormView() {

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $appointment_id = $this->request->get['appointment_id'];

        $data['appointment_info'] = $this->model_appointment_appointment_etcm->getAppointment($appointment_id);
        $data['customer_info'] = $this->model_appointment_appointment_etcm->getCustomer($data['appointment_info']['customer_id']);

        $data['doctor_info'] = $this->model_appointment_appointment_etcm->getDoctor($data['appointment_info']['doctor_id']);
        $data['service_info'] = $this->model_appointment_appointment_etcm->getService($data['appointment_info']['clinicalservice_id']);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_etcm_form_view.twig', $data));
    }

    public function edit() {
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $this->load->language('appointment/appointment_etcm');
        $this->load->language('mail/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_etcm');
        $this->load->model('appointment/appointment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormAppointment()) {
            $appointment_info = $this->model_appointment_appointment_etcm->getAppointment($this->request->get['appointment_id']);

            $appointment_date = $appointment_info['appointment_date'];
            $appointment_time = $appointment_info['appointment_time'];
            $appointment_status = $appointment_info['status'];
            $customer_id = $appointment_info['customer_id'];

            $result = $this->model_appointment_appointment_etcm->editAppointment($this->request->get['appointment_id'], $this->request->post);

            $store = $this->model_appointment_appointment_etcm->getStore($this->request->get['appointment_id']);

            if ($store) {
                $store_name = $store['name'];
            } else {
                $store_name = $this->config->get('config_name');
            }

            if ($this->request->post['status'] == 3) {
                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '4', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }

                if ($this->request->post['service'] != '') {
                    //service
                    $transaction_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
                    $this->model_appointment_appointment_etcm->addService($this->request->post, $transaction_no);
                }

                //herbalremedies
                $transaction_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
                $herbal_id = $this->model_appointment_appointment_etcm->addHerbal($this->request->post, $transaction_no);

                $this->load->model('herbal/herbal');
                $this->load->model('sale/customer');

                $herbal_row = $this->model_herbal_herbal->getHerbal($herbal_id);

                if ($herbal_row['doctor_id'] != 0) {
                    $notification_template = $this->config->get('config_gcm_new_herbal');

                    if ($notification_template['status'] == '1') {
                        $template_title = $notification_template['title'];
                        $template_message = $notification_template['message'];

                        $customer_data = $this->model_sale_customer->getCustomer($herbal_row['customer_id']);
                        $customer_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

                        $invoice_prefix = $herbal_row['invoice_prefix'];

                        $find_title = array(
                            '{customer_name}'
                        );

                        $replace_title = array(
                            'customer_name' => $customer_name
                        );

                        $find_message = array(
                            '{invoice_prefix}'
                        );

                        $replace_message = array(
                            'invoice_prefix' => $invoice_prefix
                        );

                        $notification_title = str_replace($find_title, $replace_title, $template_title);
                        $notification_message = str_replace($find_message, $replace_message, $template_message);

                        $notification_data = array(
                            'body' => $notification_title,
                            'badge' => 1,
                            'sound' => 'ping.aiff'
                        );

                        $data_gcm = array(
                            'title' => $notification_title,
                            'message' => $notification_message,
                            'user_id' => $herbal_row['doctor_id'],
                            'type' => 2      // New herbal remedies type
                        );

                        $doctor_device = $this->model_herbal_herbal->getDoctorDevice($herbal_row['doctor_id']);

                        if (!empty($doctor_device)) {
                            $gcm = new GCM($this->registry);
                            $gcm->sendTo($gcm->get_user_token($herbal_row['doctor_id']))
                                    ->setData($data_gcm)
                                    ->setIosNotification($notification_data)
                                    ->setContentAvailable(true)
                                    ->send();
                        }
                    }
                }
            }

            if ($this->request->post['status'] == 1) {
                $customer_data = $this->model_appointment_appointment_etcm->getCustomer($customer_id);

                $customer_name = $customer_data['customer_name'];
                $customer_telephone = $customer_data['telephone'];

                if ($customer_data['country_id'] == 0) {
                    $country_id = $this->config->get('config_country_id');
                } else {
                    $country_id = $customer_data['country_id'];
                }

                $country_details = $this->model_localisation_country->getCountry($country_id);
                $mobile_code = $country_details['mobile_code'];

                if (isset($this->request->post['doctor'])) {
                    if ($this->request->post['doctor'] > 0) {
                        $doctor = $this->model_appointment_appointment->getDoctor($this->request->post['doctor']);

                        $doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];
                    } else {
                        $doctor_name = '';
                    }
                }

                if (($this->request->post['date'] == $appointment_date) && ($this->request->post['time'] == $appointment_time)) {
                    if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                        $appointment_details = array();

                        $appointment_details['url'] = HTTPS_CATALOG;

                        if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                            $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                        } else {
                            $appointment_details['image'] = '';
                        }

                        if (!empty($customer_name)) {
                            $appointment_details['customer_name'] = $customer_name;
                        } else {
                            $appointment_details['customer_name'] = '';
                        }

                        $appointment_details['appointment_date'] = $this->request->post['date'];
                        $appointment_details['appointment_time'] = $this->request->post['time'];
                        $appointment_details['store_name'] = $store_name;
                        $appointment_details['doctor_name'] = $doctor_name;

                        $store_id = $this->config->get('config_store_id');
                        $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                        //address
                        $appointment_details['config_name'] = $store_info['config_name'];
                        $appointment_details['config_address'] = nl2br($store_info['config_address']);
                        $appointment_details['config_country'] = $country['name'];
                        $appointment_details['config_zone'] = $zone['name'];
                        $appointment_details['config_telephone'] = $store_info['config_telephone'];
                        $appointment_details['config_email'] = $store_info['config_email'];

                        $subject = sprintf($this->language->get('text_subject'), $appointment_details['appointment_date']);

                        $message = $this->load->view('appointment/email.tpl', $appointment_details);

                        $mail = new Mail($this->config->get('config_mail'));
                        $mail->setTo($this->request->post['email']);
                        $mail->setFrom($this->config->get('config_email'));
                        $mail->setSender($store_name);
                        $mail->setSubject($subject);
                        $mail->setHtml($message);
                        $mail->send();
                    }

                    //SMS
                    $sms_appointment_info = $this->config->get('config_sms_appointment');

                    if ($sms_appointment_info['status'] == '1') {
                        $appointment_template = $sms_appointment_info['template'];

                        $find = array(
                            '{action}',
                            '{date}',
                            '{time}',
                            '{storename}'
                        );

                        $replace = array(
                            'action' => 'confirmed on',
                            'date' => $this->request->post['date'],
                            'time' => $this->request->post['time'],
                            'storename' => $store_name
                        );

                        $sms_message = str_replace($find, $replace, $appointment_template);

                        $sms = new SMS($this->config->get('config_sms'));
                        $sms->sendTo($mobile_code, $this->request->post['telephone'])
                                ->setMessage($sms_message)
                                ->send();
                    }

                    // gcm for user app
                    if ($appointment_info['from_etcm'] > 0) {
                        $this->pushToUserApp($this->request->get['appointment_id'], '1', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                    }
                } else {
                    if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                        $appointment_details = array();

                        $appointment_details['url'] = HTTPS_CATALOG;

                        if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                            $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                        } else {
                            $appointment_details['image'] = '';
                        }

                        if (!empty($customer_name)) {
                            $appointment_details['customer_name'] = $customer_name;
                        } else {
                            $appointment_details['customer_name'] = '';
                        }


                        $appointment_details['appointment_date'] = $this->request->post['date'];
                        $appointment_details['appointment_time'] = $this->request->post['time'];
                        $appointment_details['store_name'] = $store_name;
                        $appointment_details['doctor_name'] = $doctor_name;

                        $store_id = $this->config->get('config_store_id');
                        $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                        //address
                        $appointment_details['config_name'] = $store_info['config_name'];
                        $appointment_details['config_address'] = nl2br($store_info['config_address']);
                        $appointment_details['config_country'] = $country['name'];
                        $appointment_details['config_zone'] = $zone['name'];
                        $appointment_details['config_telephone'] = $store_info['config_telephone'];
                        $appointment_details['config_email'] = $store_info['config_email'];

                        $subject = sprintf($this->language->get('text_subject_changed'), $appointment_details['appointment_date']);

                        $message = $this->load->view('appointment/changed_appointment_email.tpl', $appointment_details);

                        $mail = new Mail($this->config->get('config_mail'));
                        $mail->setTo($this->request->post['email']);
                        $mail->setFrom($this->config->get('config_email'));
                        $mail->setSender($store_name);
                        $mail->setSubject($subject);
                        $mail->setHtml($message);
                        $mail->send();
                    }

                    //SMS
                    $sms_appointment_info = $this->config->get('config_sms_appointment');

                    if ($sms_appointment_info['status'] == '1') {
                        $appointment_template = $sms_appointment_info['template'];

                        $find = array(
                            '{action}',
                            '{date}',
                            '{time}',
                            '{storename}'
                        );

                        $replace = array(
                            'action' => 'changed to',
                            'date' => $this->request->post['date'],
                            'time' => $this->request->post['time'],
                            'storename' => $store_name
                        );

                        $sms_message = str_replace($find, $replace, $appointment_template);

                        $sms = new SMS($this->config->get('config_sms'));
                        $sms->sendTo($mobile_code, $this->request->post['telephone'])
                                ->setMessage($sms_message)
                                ->send();
                    }

                    // gcm for user app
                    if ($appointment_info['from_etcm'] > 0) {
                        $this->pushToUserApp($this->request->get['appointment_id'], '2', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                    }
                }
            }

            // cancel appointment
            if ($this->request->post['status'] == 2) {
                //customer
                $customer_data = $this->model_appointment_appointment_etcm->getCustomer($customer_id);
                $customer_name = $customer_data['customer_name'];

                if ($customer_data['country_id'] == 0) {
                    $country_id = $this->config->get('config_country_id');
                } else {
                    $country_id = $customer_data['country_id'];
                }

                $country_details = $this->model_localisation_country->getCountry($country_id);
                $mobile_code = $country_details['mobile_code'];

                $customer_name = $customer_data['firstname'];

                if (isset($this->request->post['doctor'])) {
                    if ($this->request->post['doctor'] > 0) {
                        $doctor = $this->model_appointment_appointment->getDoctor($this->request->post['doctor']);

                        $doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];
                    } else {
                        $doctor_name = '';
                    }
                }

                if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                    $appointment_details = array();

                    $appointment_details['url'] = HTTPS_CATALOG;

                    if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                        $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                    } else {
                        $appointment_details['image'] = '';
                    }

                    if (!empty($customer_name)) {
                        $appointment_details['customer_name'] = $customer_name;
                    } else {
                        $appointment_details['customer_name'] = '';
                    }


                    $appointment_details['appointment_date'] = $this->request->post['date'];
                    $appointment_details['appointment_time'] = $this->request->post['time'];
                    $appointment_details['store_name'] = $store_name;
                    $appointment_details['doctor_name'] = $doctor_name;

                    $store_id = $this->config->get('config_store_id');
                    $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                    $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                    $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                    //address
                    $appointment_details['config_name'] = $store_info['config_name'];
                    $appointment_details['config_address'] = nl2br($store_info['config_address']);
                    $appointment_details['config_country'] = $country['name'];
                    $appointment_details['config_zone'] = $zone['name'];
                    $appointment_details['config_telephone'] = $store_info['config_telephone'];
                    $appointment_details['config_email'] = $store_info['config_email'];

                    $subject = sprintf($this->language->get('text_subject_canceled'), $appointment_details['appointment_date']);

                    $message = $this->load->view('appointment/email_cancel_appointment.tpl', $appointment_details);

                    $mail = new Mail($this->config->get('config_mail'));
                    $mail->setTo($this->request->post['email']);
                    $mail->setFrom($this->config->get('config_email'));
                    $mail->setSender($store_name);
                    $mail->setSubject($subject);
                    $mail->setHtml($message);
                    $mail->send();
                }

                // SMS
                $sms_appointment_info = $this->config->get('config_sms_appointment');

                if ($sms_appointment_info['status'] == '1') {
                    $appointment_template = $sms_appointment_info['template'];

                    $find = array(
                        '{action}',
                        '{date}',
                        '{time}',
                        '{storename}'
                    );

                    $replace = array(
                        'action' => 'canceled on',
                        'date' => $this->request->post['date'],
                        'time' => $this->request->post['time'],
                        'storename' => $store_name
                    );

                    $sms_message = str_replace($find, $replace, $appointment_template);

                    $sms = new SMS($this->config->get('config_sms'));
                    $sms->sendTo($mobile_code, $this->request->post['telephone'])
                            ->setMessage($sms_message)
                            ->send();
                }

                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '3', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }
            }

            // if status still pending
            if ($this->request->post['status'] == 0) {
                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '5', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_date'])) {
                $url .= '&filter_date=' . $this->request->get['filter_date'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($appointment_id) && $appointment_id != 0) {
                $url .= '&appointment_id=' . $appointment_id;
            }

            $this->response->redirect($this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getFormAppointment();
    }

    protected function validateFormAppointment() {
        if (!$this->user->hasPermission('modify', 'appointment/appointment_etcm')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (isset($this->request->get['new']) && $this->request->get['new'] != 1) {
            if ((utf8_strlen($this->request->post['service']) < 1)) {
                $this->error['service'] = $this->language->get('error_service');
            }
        }

        if ($this->request->post['doctor_required'] == 1) {
            if ((utf8_strlen($this->request->post['doctor']) < 1)) {
                $this->error['doctor'] = $this->language->get('error_doctor');
            }
        }

        if ((utf8_strlen($this->request->post['date']) < 1)) {
            $this->error['date'] = $this->language->get('error_date');
        }

        if (strtotime($this->request->post['date']) < strtotime(date('Y-m-d'))) {
            $this->error['date'] = $this->language->get('error_date_less');
        }

        $user_holiday = $this->model_appointment_appointment_etcm->checkUserHoliday($this->request->post['doctor']);
        $store_holiday = $this->model_appointment_appointment_etcm->checkStoreHoliday($this->session->data['store_id']);

        foreach ($user_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['date'] = $this->language->get('error_date_unavailable');
            }
        }

        foreach ($store_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['date'] = $this->language->get('error_date_unavailable');
            }
        }

        if ((utf8_strlen($this->request->post['status']) < 1)) {
            $this->error['status'] = $this->language->get('error_status');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function getFormAppointment() {

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['service'])) {
            $data['error_service'] = $this->error['service'];
        } else {
            $data['error_service'] = '';
        }

        if (isset($this->error['doctor'])) {
            $data['error_doctor'] = $this->error['doctor'];
        } else {
            $data['error_doctor'] = '';
        }

        if (isset($this->error['date'])) {
            $data['error_date'] = $this->error['date'];
        } else {
            $data['error_date'] = '';
        }

        if (isset($this->error['time'])) {
            $data['error_time'] = $this->error['time'];
        } else {
            $data['error_time'] = '';
        }

        if (isset($this->error['status'])) {
            $data['error_status'] = $this->error['status'];
        } else {
            $data['error_status'] = '';
        }

        if (isset($this->error['price'])) {
            $data['error_price'] = $this->error['price'];
        } else {
            $data['error_price'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['new'])) {
            $url .= '&new=' . $this->request->get['new'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('appointment/appointment_etcm/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $this->request->get['appointment_id'] . $url, true);
        $data['cancel'] = $this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['appointment_id'])) {
            $appointment_info = $this->model_appointment_appointment_etcm->getAppointment($this->request->get['appointment_id']);

            if (empty($appointment_info)) {
                $this->response->redirect($this->url->link('appointment/appointment_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        $customer = $this->model_appointment_appointment_etcm->getCustomer($appointment_info['customer_id']);

        $data['customer_id'] = $appointment_info['customer_id'];
        $data['customer_card'] = $customer['customer_card'];
        $data['customer_ic'] = $customer['customer_ic'];
        $data['firstname'] = $customer['firstname'];
        $data['lastname'] = $customer['lastname'];
        $data['gender'] = $customer['gender'];
        $data['email'] = $customer['email'];
        $data['telephone'] = $customer['telephone'];
        $data['telephone2'] = $customer['telephone2'];
        $data['home'] = $customer['home'];
        $data['fax'] = $customer['fax'];

        $new_customer = $appointment_info['new_customer'];
        $data['new'] = $new_customer;

        if ($new_customer) {
            $data['service'] = (isset($this->request->post['service'])) ? $this->request->post['service'] : 0;
        } else {
            $data['service'] = (isset($this->request->post['service'])) ? $this->request->post['service'] : $appointment_info['clinicalservice_id'];
        }

        if (isset($this->request->post['doctor'])) {
            $data['doctor'] = $this->request->post['doctor'];
        } elseif (!empty($appointment_info)) {
            $data['doctor'] = $appointment_info['doctor_id'];
        } else {
            $data['doctor'] = '';
        }

        if (isset($this->request->post['doctor_required'])) {
            $data['doctor_required'] = $this->request->post['doctor_required'];
        } else {
            $data['doctor_required'] = '';
        }

        if (isset($this->request->post['date'])) {
            $data['date'] = $this->request->post['date'];
        } elseif (!empty($appointment_info)) {
            $data['date'] = $appointment_info['appointment_date'];
            if ($data['date'] == '0000-00-00') {
                $data['date'] = '';
            }
        } else {
            $data['date'] = '';
        }

        if (isset($this->request->post['time'])) {
            $data['time'] = $this->request->post['time'];
        } elseif (!empty($appointment_info)) {
            $data['time'] = $appointment_info['appointment_time'];
        } else {
            $data['time'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($appointment_info)) {
            $data['status'] = $appointment_info['status'];
        } else {
            $data['status'] = '';
        }

        if (isset($this->request->post['price'])) {
            $data['price'] = $this->request->post['price'];
        } elseif (!empty($appointment_info)) {
            $data['price'] = $appointment_info['price'];
            if ($data['price'] == 0) {
                $data['price'] = '';
            }
        } else {
            $data['price'] = '';
        }

        if (isset($this->request->post['start'])) {
            $data['start'] = $this->request->post['start'];
        } elseif (!empty($appointment_info)) {
            $data['start'] = $appointment_info['start_time'];
            if ($data['start'] == '00:00:00') {
                $data['start'] = '';
            }
        } else {
            $data['start'] = '';
        }

        if (isset($this->request->post['end'])) {
            $data['end'] = $this->request->post['end'];
        } elseif (!empty($appointment_info)) {
            $data['end'] = $appointment_info['end_time'];
            if ($data['end'] == '00:00:00') {
                $data['end'] = '';
            }
        } else {
            $data['end'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } elseif (!empty($appointment_info)) {
            $data['remark'] = $appointment_info['remark'];
        } else {
            $data['remark'] = '';
        }

        $data['store_id'] = $this->session->data['store_id'];

        $data['services'] = $this->model_appointment_appointment_etcm->getServices();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_etcm_form.twig', $data));
    }

    public function getService() {
        $json = array();

        $this->load->model('appointment/appointment_etcm');

        if (isset($this->request->get['service_id'])) {
            $service_id = $this->request->get['service_id'];
        } else {
            $service_id = '';
        }

        $json = $this->model_appointment_appointment_etcm->getService($service_id);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getDoctors() {
        $json = array();

        $this->load->model('appointment/appointment_etcm');

        $json = $this->model_appointment_appointment_etcm->getDoctors();

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getTimes() {
        $json = array();

        $this->load->model('appointment/appointment_etcm');

        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }

        $time = $this->model_appointment_appointment_etcm->getTimes($this->session->data['store_id'], $date);

        if ($time['closed'] == 1) {
            array_push($json, '');
        } else {

            $temp = strtotime($time['start1']);
            array_push($json, date('h:i A', $temp));
            while (strtotime($time['end1']) > $temp) {
                $temp = $temp + ($time['minutes'] * 60);
                $temp2 = $temp + ($time['minutes'] * 60);
                if ($temp2 <= strtotime($time['end1'])) {
                    array_push($json, date('h:i A', $temp));
                }
            }

            $temp = strtotime($time['start2']);
            array_push($json, date('h:i A', $temp));
            while (strtotime($time['end2']) > $temp) {
                $temp = $temp + ($time['minutes'] * 60);
                $temp2 = $temp + ($time['minutes'] * 60);
                if ($temp2 <= strtotime($time['end2'])) {
                    array_push($json, date('h:i A', $temp));
                }
            }
        }

        $json = array_reverse($json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function createDateRangeArray($strDateFrom, $strDateTo) {
        $aryRange = array();

        $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
            while ($iDateFrom < $iDateTo) {
                $iDateFrom += 86400; // add 24 hours
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }

        return $aryRange;
    }

    public function pushToUserApp($appointment_id, $status, $hosting, $appointment_date, $appointment_time) {
        $user_appSession = curl_init();

        $url = HTTP_API . 'index.php?route=appointment/appointment/push_notification&appointment_id=' . $appointment_id . '&status=' . $status . '&hosting=' . $hosting . '&date=' . $appointment_date . '&time=' . $appointment_time;

        $new_url = str_replace(' ', '%20', $url);

        curl_setopt($user_appSession, CURLOPT_URL, $new_url);
        curl_setopt($user_appSession, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($user_appSession, CURLOPT_HEADER, false);

        curl_exec($user_appSession);
        curl_close($user_appSession);
    }

}
?>