<?php

class ControllerAppointmentAppointmentEmergency extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('appointment/appointment_emergency');
        $this->load->language('mail/appointment_emergency');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_emergency');

        if (isset($this->request->get['emergency_id']) && isset($this->request->get['notification']) && $this->validateForm()) {
            $emergency_id = $this->request->get['emergency_id'];
            $notification = $this->request->get['notification'];

            $this->model_appointment_appointment_emergency->updateEmergency($emergency_id, $notification);

            $customer = $this->model_appointment_appointment_emergency->getCustomer($emergency_id);

            $store = $this->model_appointment_appointment_emergency->getStore($emergency_id);

            if ($store) {
                $store_name = $store['name'];
            } else {
                $store_name = $this->config->get('config_name');
            }

            if ($notification == 'sms') {
                //SMS
                $sms = file_get_contents("http://broadcast.smsgateway.cc/API/ReceiveSMS.aspx?Username=lim@nexphere.com&Password=7411f064&MobileNumber=6" . $customer['telephone'] . "&ContentType=1&MsgText=Your+appointment+on+" . $customer['appointment_olddate'] . "+" . str_replace(' ', '+', $customer['appointment_oldtime']) . "+at+" . str_replace(' ', '+', $store_name) . "+has+been+hold.+Thank+you");
            } elseif ($notification == 'email') {
                /*
                  //EMAIL
                  $subject = sprintf($this->language->get('text_subject'), $store_name);

                  $message  = sprintf($this->language->get('text_greeting'), $customer['appointment_olddate'] . ' ' . $customer['appointment_oldtime'], $store_name);

                  $mail = new Mail($this->config->get('config_mail'));
                  $mail->setTo($this->request->post['email']);
                  $mail->setFrom($this->config->get('config_email'));
                  $mail->setSender($store_name);
                  $mail->setSubject($subject);
                  $mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
                  $mail->send();
                 */
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function getList() {
        if (isset($this->request->get['filter_date'])) {
            $filter_date = $this->request->get['filter_date'];
        } else {
            $filter_date = null;
        }

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_no'])) {
            $filter_no = $this->request->get['filter_no'];
        } else {
            $filter_no = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_ic'])) {
            $filter_ic = $this->request->get['filter_ic'];
        } else {
            $filter_ic = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'date';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_no'])) {
            $url .= '&filter_no=' . $this->request->get['filter_no'];
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . $this->request->get['filter_ic'];
        }

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['emergencys'] = array();

        $filter_data = array(
            'filter_date' => $filter_date,
            'filter_name' => $filter_name,
            'filter_no' => $filter_no,
            'filter_ic' => $filter_ic,
            'filter_status' => $filter_status,
            'filter_doctor' => $filter_doctor,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $emergency_total = $this->model_appointment_appointment_emergency->getTotalEmergencys($filter_data);

        $results = $this->model_appointment_appointment_emergency->getEmergencys($filter_data);

        foreach ($results as $result) {
            $data['emergencys'][] = array(
                'emergency_id' => $result['emergency_id'],
                'date' => $result['appointment_olddate'],
                'doctor' => $result['d_firstname'] . ' ' . $result['d_lastname'],
                'name' => $result['c_firstname'] . ' ' . $result['c_lastname'],
                'ic' => $result['customer_ic'],
                'sms' => $result['sms_notification'],
                'email' => $result['email_notification'],
                'status' => $result['emergency_status'],
                'edit' => $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'] . $url, true),
                'view' => $this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'] . $url, true)
            );
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_no'])) {
            $url .= '&filter_no=' . $this->request->get['filter_no'];
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . $this->request->get['filter_ic'];
        }

        if (isset($this->request->get['filter_date'])) {
            $url .= '&filter_date=' . $this->request->get['filter_date'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_date'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $url, true);
        $data['sort_doctor'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=doctor' . $url, true);
        $data['sort_name'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        $data['sort_ic'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=ic' . $url, true);
        $data['sort_sms'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=sms' . $url, true);
        $data['sort_email'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=email' . $url, true);
        $data['sort_status'] = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $emergency_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('appointment/appointment_emergency', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($emergency_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($emergency_total - $this->config->get('config_limit_admin'))) ? $emergency_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $emergency_total, ceil($emergency_total / $this->config->get('config_limit_admin')));

        $data['filter_date'] = $filter_date;
        $data['filter_name'] = $filter_name;
        $data['filter_no'] = $filter_no;
        $data['filter_ic'] = $filter_ic;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;

        $data['user_token'] = $this->session->data['user_token'];

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_emergency_list', $data));
    }

    public function validateForm() {
        if (!$this->user->hasPermission('modify', 'appointment/appointment_emergency')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

}
