<?php echo $header; ?><?php echo $content_top; ?>
<div class="container">
  <ul class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
    <?php } ?>
  </ul>
  <div class="row">
    <div id="content" class="col-sm-12">
      <h1 class="page-heading"><?php echo $heading_title; ?></h1>
      <?php if ($error_warning) { ?>
 	  <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?></div>
  	  <?php } ?>
      <div class="row">
        <?php if(!isset($customer_id)) { ?>
        <div class="col-sm-8">
            <div class="small-div">
            <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-icnum">
            	<div class="form-group required">
                	<label class="control-label col-sm-5" for="input-customer-ic"><?php echo $text_customer_ic; ?></label>
                    <div class="col-sm-6">
                        <input type="text" name="customer_ic" id="input-customer-ic" placeholder="<?php echo $text_placeholder_ic; ?>" class="form-control" value="<?php echo $customer_ic; ?>" />
                        <div id="warning"></div>
                        <?php if ($error_customer_ic) { ?>
                        <div class="text-danger"><?php echo $error_customer_ic; ?></div>
                        <?php } ?>
                   	</div>
                </div>
                <div class="form-group required">
                	<label class="control-label col-sm-5" for="input-phone-no"><?php echo $text_phone_no; ?></label>
                    <div class="col-sm-6">
                        <input type="text" name="phone_no" id="input-phone-no" placeholder="<?php echo $text_placeholder_phone_no; ?>" class="form-control" value="<?php echo $phone_no; ?>" />
                        <div id="warning"></div>
                        <?php if ($error_phone_no) { ?>
                        <div class="text-danger"><?php echo $error_phone_no; ?></div>
                        <?php } ?>
                  	</div>
                </div>
                <div class="form-group text-right" style="margin-right:8%;">
                	<div class="col-sm-2">
                		<input type="submit" class="btn btn-primary" value="<?php echo $button_submit; ?>" />
                   	</div>
                </div>
            </form>
            </div>
        </div>
        <?php } ?>
        <?php if(isset($customer_id)) { ?>
        <div class="col-sm-4">
        	<h3 class="row-heading"><?php echo $text_patient_details; ?></h3>
        	<div class="row" style="margin-bottom:3%">
                <div class="col-sm-5">
                    <b><?php echo $text_patient_name; ?></b>
                </div>
                <div class="col-sm-7">
                    <?php echo $customer['name']; ?>
                </div>
            </div>

            <div class="row" style="margin-bottom:3%">
                <div class="col-sm-5">
                    <b><?php echo $text_patient_ic; ?></b>
                </div>
                <div class="col-sm-7">
                    <?php echo $customer['customer_ic']; ?>
                </div>
            </div>

            <div class="row" style="margin-bottom:3%">
                <div class="col-sm-5">
                    <b><?php echo $text_gender; ?></b>
                </div>
                <div class="col-sm-7">
                    <?php if($customer['gender'] == 1) { ?>
                        <?php echo $text_male; ?>
                    <?php } else { ?>
                        <?php echo $text_female; ?>
                    <?php } ?>
                </div>
            </div>

            <div class="row" style="margin-bottom:3%">
                <div class="col-sm-5">
                    <b><?php echo $text_email_details; ?></b>
                </div>
                <div class="col-sm-7">
                    <?php if($customer['email'] == '') { ?>
                        <?php echo '-'; ?>
                    <?php } else { ?>
                        <?php echo $customer['email']; ?>
                    <?php } ?>
                </div>
            </div>

            <div class="row" style="margin-bottom:3%">
                <div class="col-sm-5">
                    <b><?php echo $text_telephone; ?></b>
                </div>
                <div class="col-sm-7">
                    <?php if(($customer['telephone'] == '-') || ($customer['telephone'] == '')){ ?>
                        <?php echo '-'; ?>
                    <?php } else { ?>
                        <?php echo $customer['telephone']; ?>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="col-sm-12 table-responsive" style="margin-top:3%;padding-left:0;padding-right:0;">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <td class="text-left"><?php echo $column_appointment_date; ?></td>
                        <td class="text-left"><?php echo $column_appointment_time; ?></td>
                        <td class="text-left"><?php echo $column_doctor; ?></td>
                        <td class="text-left"><?php echo $column_remark; ?></td>
                        <td class="text-left"><?php echo $column_status; ?></td>
                        <td class="text-right"><?php echo $column_action; ?></td>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($appointments as $appointment){ ?>
                        <tr>
                            <td class="text-left"><?php echo $appointment['appointment_date']; ?></td>
                            <td class="text-left"><?php echo $appointment['appointment_time']; ?></td>
                            <td class="text-left">
                				<?php if(!empty($appointment['doctor_image'])) { ?>
                					<a href="<?php echo $appointment['doctor_image']; ?>" data-toggle="tooltip" title="<?php echo $button_doctor_image; ?>" class="openwindow"><?php echo $appointment['doctor_name']; ?></a>
                    			<?php } else { ?>
                    				<?php echo $appointment['doctor_name']; ?>
                    			<?php } ?>
                			</td>
                            <td class="text-left"><?php echo $appointment['remark']; ?></td>
                            <td class="text-left">
                                <?php if($appointment['status'] == 0){ ?>
                                        <label class="label label-warning"><?php echo $text_pending ?></label>
                                <?php } else if($appointment['status'] == 1){ ?>
                                        <label class="label label-success"><?php echo $text_confirm ?></label>
                                <?php } else if($appointment['status'] == 2){ ?>
                                        <label class="label label-danger"><?php echo $text_canceled ?></label>
                                <?php } else if($appointment['status'] == 3){ ?>
                                        <label class="label label-success"><?php echo $text_attended ?></label>
                                <?php } else if($appointment['status'] == 4){ ?>
                                        <label class="label label-success"><?php echo $text_draft ?></label>
                                <?php } ?>
                            </td>
                            <td class="text-right">
                            <?php if(($appointment['status'] != 2) && ($appointment['status'] != 1) && ($appointment['status'] != 3)) { ?>
                                <a href="<?=$appointment['print']?>" target="_blank" data-toggle="tooltip" title="<?php echo $button_print_appointment; ?>" class="btn btn-info"><i class="fa fa-print"></i></a> <a href="<?=$appointment['cancel']?>" data-toggle="tooltip" title="<?php echo $button_cancel_appointment; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></a>
                            <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
          </table>
        </div>
        <?php } ?>
      </div>
<script type="text/javascript">
$('.openwindow').click(function(event){
	event.preventDefault();
	window.open($(this).attr("href"),"popupWindow","width=800,height=800,scrollbars=yes");
});

$("#input-customer-ic").keypress(function (event) {
	var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
    if(keyCode >= 48 && keyCode <= 57){
		// when user type 0 to 9
        return true;
	} else if(keyCode >= 97 && keyCode <= 122){
		// when user type a to z auto change to uppercase
		this.value = this.value.toUpperCase();
		return true;
	} else if(keyCode >= 65 && keyCode <= 90){
		// when user type A to Z
		return true;
	} else if(keyCode == 32){
		return true;
	} else {
		return false;
	}
});

$('#input-phone-no').keypress(function (event) {
	var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
	if(keyCode >=48 && keyCode <= 57)
		return true;
	else return false;
});
</script>
</div>
</div>
</div>
<?php echo $footer; ?>
