<?php echo $header; ?><?php echo $content_top; ?>
<div class="container">
  <ul class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
    <?php } ?>
  </ul>

  <div class="row">
  	<div id="content" class="col-sm-12">
    	<h1><?php echo $heading_title; ?></h1>
        <h3><?php echo $text_available_store; ?></h3>
        <div class="row">
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-user" class="form-horizontal">
        	<div class="form-group">
            	<label class="col-sm-2 control-label" for="filter_country"><?php echo $entry_country; ?></label>
                <div class="col-sm-10">
                	<select name="filter_country_id" id="filter_country" onchange="country(this, '<?php echo $zone_id; ?>');" class="form-control">
                    	<option value=""><?php echo $text_select; ?></option>
                    	<?php foreach ($countries as $country) { ?>
                        <?php if ($country['country_id'] == $country_id) { ?>
              			<option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
              			<?php } else { ?>
                        <option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
                        <?php } ?>
                        <?php } ?>
                 	</select>
                    <?php if(isset($error_name['country_id'])):?>
                    	<div class="text-danger">
                       		<?=$error_name['country_id']?>
                        </div>
               	    <?php endif;?>
              	</div>
      		</div>
            <div class="form-group">
            	<label class="col-sm-2 control-label" for="filter_zone"><?php echo $entry_zone; ?></label>
          		<div class="col-sm-10">
                	<select name="filter_zone_id" id="filter_zone" class="form-control">
                    </select>
                    <?php if(isset($error_name['zone_id'])):?>
                    	<div class="text-danger">
                          	<?=$error_name['zone_id']?>
                        </div>
                  	<?php endif;?>
              	</div>
         	</div>

           	<div class="form-group">
            	<label class="col-sm-2 control-label"></label>
                <div class="col-sm-10">
                	<button id="button-search-store" type="button" class="btn btn-primary">
                    	<li class="fa fa-search"></li>
                        <?PHP echo $button_search_available_store;?>
                   	</button>
               	</div>
         	</div>
        </form>
      	</div>

		<div id="store_list" class="herbal-store-list"></div>
    </div>
  </div>
<script type="text/javascript">
$('#button-search-store').on('click',function(){
	var country_id = $('#filter_country').val();
	var zone_id = $('#filter_zone').val();

	 $.ajax({
		url: 'index.php?route=appointment/appointment/ajaxGetStores',
		data:{
			country_id:country_id,
			zone_id:zone_id
		},
		type:'POST',
		beforeSend: function(){
		},
		success: function(respond) {
			$('#store_list').html(respond);
		},
		complete: function(){
		}
	});
 });

 function country(element, zone_id) {
  if (element.value != '') {
		$.ajax({
			url: 'index.php?route=appointment/appointment/country&country_id=' + element.value,
			dataType: 'json',
			beforeSend: function() {
				$('select[name=\'filter_country_id\']').after(' <i class="fa fa-circle-o-notch fa-spin"></i>');
			},
			complete: function() {
				$('.fa-spin').remove();
			},
			success: function(json) {
				if (json['postcode_required'] == '1') {
					$('input[name=\'postcode\']').parent().addClass('required');
				} else {
					$('input[name=\'postcode\']').parent().parent().removeClass('required');
				}

				html = '<option value=""><?php echo $text_select; ?></option>';

				if (json['zone'] != '') {
					for (i = 0; i < json['zone'].length; i++) {
						html += '<option value="' + json['zone'][i]['zone_id'] + '"';

						if (json['zone'][i]['zone_id'] == zone_id) {
							html += ' selected="selected"';
						}

						html += '>' + json['zone'][i]['name'] + '</option>';
					}
				} else {
					html += '<option value="0"><?php echo $text_none; ?></option>';
				}

				$('select[name=\'filter_zone_id\']').html(html);
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
		});
	}
}

$('select[name=\'filter_country_id\']').trigger('change');
</script>
</div>
<?php echo $footer; ?>
