<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<?php if (!$is_pdf) { ?>
<link href="catalog/view/javascript/bootstrap/css/bootstrap.css" rel="stylesheet" media="all" />
<script type="text/javascript" src="catalog/view/javascript/bootstrap/js/bootstrap.min.js"></script>
<link href="catalog/view/javascript/font-awesome/css/font-awesome.min.css" type="text/css" rel="stylesheet" />
<link type="text/css" href="catalog/view/theme/default/stylesheet/stylesheet/stylesheet.css" rel="stylesheet" media="all" />
<?php } else { ?>
<link href="catalog/view/javascript/bootstrap/css/bootstrap.css" rel="stylesheet" media="all" />
<link type="text/css" href="catalog/view/theme/default/stylesheet/stylesheet/stylesheet.css" rel="stylesheet" media="all" />
<style type="text/css">
<?php if ($margin_top && $margin_bottom && $margin_right && $margin_left) { ?>
@page { 
    margin-top: <?php echo $margin_top; ?>px; 
    margin-right: <?php echo $margin_right; ?>px;
    margin-bottom: <?php echo $margin_bottom; ?>px; 
    margin-left: <?php echo $margin_left; ?>px; 
}
<?php } ?>
</style>
<?php } ?>			
</head>
<body>
<div class="container">
  	<table class="table a5_table">
    	<tbody>
        	<tr>
            	<td style="width:50%;" class="text-left">
                	<b><?=$json_config_data['store_name']; ?></b><br />
                    <?php echo nl2br($json_config_data['store_address']); ?><br/>	
                    <?php echo $text_telephone . ': ' . $json_config_data['store_telephone']; ?><br />
                    <?php echo $text_email . ': ' . $json_config_data['store_email']; ?><br />
                </td>
                <td style="width:50%;font-size:20px" class="text-left">
                	<b><?php echo $text_status; ?></b><br />
                    <?php if($appointment_data['status'] == 0){ ?>
                        <label class="label label-warning"><?php echo $text_pending ?></label>
                    <?php } else if($appointment_data['status'] == 1){ ?>
                        <label class="label label-success"><?php echo $text_confirm ?></label>
                    <?php } else if($appointment_data['status'] == 2){ ?>
                        <label class="label label-danger"><?php echo $text_canceled ?></label>
                    <?php } else if($appointment_data['status'] == 3){ ?>
                        <label class="label label-success"><?php echo $text_attended ?></label>
                    <?php } else if($appointment_data['status'] == 4){ ?>
                        <label class="label label-success"><?php echo $text_draft ?></label>
                    <?php } ?>     
                </td>
            </tr>
        </tbody>
    </table>
  	<div class="tax_invoice"><?PHP echo $en_text_appointment;?></div>
   
    <table class="table a5_table">
       <tr>
       		<td><b><?php echo $text_appointment_date; ?></b></td>
            <td><?php echo $appointment_data['appointment_date']; ?></td>
            <td><b><?php echo $text_patient_name; ?></b></td>
            <td><?php echo $appointment_data['customer_name']; ?></td>
       </tr>
       <tr>
       		<td><b><?php echo $text_appointment_time; ?></b></td>
            <td><?php echo $appointment_data['appointment_time']; ?></td>
            <td><b><?php echo $text_patient_ic; ?></b></td>
            <td><?php echo $appointment_data['customer_ic']; ?></td>
       </tr>
       <tr>
       		<td><b><?php echo $text_service; ?></b></td>
            <td><?php echo $appointment_data['service_name']; ?></td>
            <td><b><?php echo $text_gender; ?></b></td>
            <td>
              <?php if($appointment_data['gender'] == 1) { ?>
                  <?php echo $text_male; ?>
              <?php } else { ?>
                  <?php echo $text_female; ?>
              <?php } ?>
            </td>
       </tr>
       <tr>
       		<td><b><?php echo $text_doctor; ?></b></td>
            <td><?php echo $appointment_data['doctor_name']; ?></td>
            <td><b><?php echo $text_email; ?></b></td>
            <td><?php echo $appointment_data['email']; ?></td>
       </tr>
       <tr>
       		<td><b><?php echo $text_remark; ?></b></td>
            <td><?php echo $appointment_data['remark']; ?></td>
            <td><b><?php echo $text_telephone; ?></b></td>
            <td><?php echo $appointment_data['telephone']; ?></td>
       </tr>
   	</table>
</div>
</body>
</html>